#include "framecpp/Common/Description.hh"
#include "framecpp/Common/TOCInfo.hh"

#include "framecpp/Version4/FrameSpec.hh"
#include "framecpp/Version4/FrTOCAdcData.hh"
#include "framecpp/Version4/FrSE.hh"
#include "framecpp/Version4/FrSH.hh"
#include "framecpp/Version4/FrTOC.hh"

#include "framecpp/Version4/STRING.hh"

using FrameCPP::Common::Description;
using FrameCPP::Common::FrameSpec;
using FrameCPP::Common::TOCInfo;

namespace FrameCPP
{
  namespace Version_4
  {
    //===================================================================
    //===================================================================
    void FrTOCAdcData::
    Description( Common::Description& Desc )
    {
      Desc( FrSE( "nADC", "INT_4U",
		  "Number of unique FrAdcData names in file." ) );
      Desc( FrSE( "nameADC", "*STRING", "Array of FrAdcData names" ) );
      Desc( FrSE( "positionADC", "*INT_8U",
		  "Array of lists of FrAdcData offset positions, in bytes,"
		  " from beginning of file (size of nFrame*nADC)"
		  ) );
    }
    void FrTOCAdcData::
    QueryADC( const Common::TOCInfo& Info,
	       INT_4U FrameOffset,
	       INT_8U Position )
    {
      STRING	name;
      INT_4U	channel_id;
      INT_4U	group_id;

      Info.TOCQuery( TOCInfo::IC_NAME, TOCInfo::DT_STRING_2, &name,
		     TOCInfo::IC_CHANNEL_ID, TOCInfo::DT_INT_4U,
		     &channel_id,
		     TOCInfo::IC_GROUP_ID, TOCInfo::DT_INT_4U,
		     &group_id,
		     TOCInfo::IC_EOQ );

      adc_info_type& i( m_adc_info[ name ] );
      i.channelID = channel_id;
      i.groupID = group_id;
      i.positionADC.resize( FrameOffset + 1 );
      i.positionADC[ FrameOffset ] = Position;
    }
  } // namespace - Version_4
} // namespace - FrameCPP
