/* -*- mode: c++ -*- */

#if defined(SWIGPYTHON)

%exception
{
  //---------------------------------------------------------------------
  // Ensure that no exceptions leave the C++ layer
  //---------------------------------------------------------------------
  try
  {
    $action;
  }
  catch( const std::exception& Exception )
  {
    //-------------------------------------------------------------------
    // Handle exceptions derived from std::exception
    //-------------------------------------------------------------------
    PyErr_SetString( PyExc_IndexError,
		     const_cast<char*>( Exception.what( ) ) );
    goto fail;
  }
  catch( ... )
  {
    //-------------------------------------------------------------------
    // Catch everything else to make sure they do not leak outside
    //-------------------------------------------------------------------
    PyErr_SetString( PyExc_IndexError,
		     const_cast<char*>( "unknown error" ) );
    goto fail;
  }
}

%define LDAS_PROPERTY_READ_ONLY(Name,ReadFunc)
  %insert("python") %{
     __swig_getmethods__[Name] = ReadFunc
  %}
%enddef /* LDAS_PROPERTY_READ_ONLY(Name,ReadFunc) */

%define LDAS_PROPERTY_READ_WRITE(Name,ReadFunc,WriteFunc)
  %insert("python") %{
    __swig_getmethods__[Name] = ReadFunc
    __swig_setmethods__[Name] = WriteFunc
  %}
%enddef /* LDAS_PROPERTY_READ_ONLY(Name,ReadFunc) */

#endif /* defined(SWIGPYTHON) */
