#ifndef SINC_HH
#define SINC_HH

#include <cmath>

#include "LDASConstants.hh"

namespace Filters {

  //: Sinc(x) returns sin(pi*x)/(pi*x)
  inline double Sinc(const double& x)
  {
      return ((x != 0.0) ? (std::sin(LDAS_PI*x)/(LDAS_PI*x)) : (1.0));
  }

}

#endif // SINC_HH
