/*
 * LALPulsarVCSInfo.h - LALPulsar VCS Information
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 * Copyright (C) 2009-2013 Adam Mercer
 * Copyright (C) 2014 Karl Wette
 */

#ifndef _LALPULSARVCSINFO_H
#define _LALPULSARVCSINFO_H

#include <lal/LALVCSInfoType.h>

#ifdef __cplusplus
extern "C" {
#endif

/**
 * \defgroup LALPulsarVCSInfo_h Header LALPulsarVCSInfo.h
 * \ingroup lalpulsar_general
 * \brief VCS information for LALPulsar
 */
/*@{*/

/** \name Global variables for LALPulsar VCS information */
/*@{*/
extern const char *const lalPulsarVCSVersion;
extern const char *const lalPulsarVCSId;
extern const char *const lalPulsarVCSDate;
extern const char *const lalPulsarVCSBranch;
extern const char *const lalPulsarVCSTag;
extern const char *const lalPulsarVCSAuthor;
extern const char *const lalPulsarVCSCommitter;
extern const char *const lalPulsarVCSStatus;
/*@}*/

/** \name Identable global variables for LALPulsar VCS information */
/*@{*/
extern const char *const lalPulsarVCSIdentId;
extern const char *const lalPulsarVCSIdentDate;
extern const char *const lalPulsarVCSIdentBranch;
extern const char *const lalPulsarVCSIdentTag;
extern const char *const lalPulsarVCSIdentAuthor;
extern const char *const lalPulsarVCSIdentCommitter;
extern const char *const lalPulsarVCSIdentStatus;
/*@}*/

/** LALPulsar VCS information */
extern const LALVCSInfo lalPulsarVCSInfo;

/** List of VCS information for LALPulsar and its LALSuite dependencies (<tt>NULL</tt>-terminated) */
extern const LALVCSInfo *const lalPulsarVCSInfoList[32];

/** LALPulsar <tt>configure</tt> arguments */
extern const char *const lalPulsarConfigureArgs;

/** LALPulsar <tt>configure</tt> date */
extern const char *const lalPulsarConfigureDate;

/** LALPulsar build date */
extern const char *const lalPulsarBuildDate;

/** Check LALPulsar VCS information for compile-time/run-time version mismatch */
#ifndef SWIG /* exclude from SWIG interface */
int XLALPulsarVCSInfoCheck(void);
#endif /* SWIG */


/*@}*/

#ifdef __cplusplus
}
#endif

#endif /* _LALPULSARVCSINFO_H */

/*
 * vim: tw=0 ts=2 et
 */
