%define _prefix /usr
%define _mandir %{_prefix}/share/man
%define _sysconfdir %{_prefix}/etc

Name: lalinference
Version: 1.9.4
Release: 1%{?dist}
Summary: LSC Algorithm Inference Library
License: GPLv2+
Group: LAL
Source: %{name}-%{version}.tar.xz
URL: https://wiki.ligo.org/DASWG/LALSuite
Packager: Adam Mercer <adam.mercer@ligo.org>
BuildRoot: %{_tmppath}/%{name}-%{version}-root
BuildRequires: chealpix-devel >= 3.30.0
BuildRequires: gsl-devel
BuildRequires: hdf5-devel
BuildRequires: healpy >= 1.9.1
BuildRequires: python-matplotlib >= 1.2.0
BuildRequires: python-shapely
BuildRequires: libmetaio-devel
BuildRequires: libxml2-devel
BuildRequires: numpy >= 1.7
BuildRequires: octave-devel
BuildRequires: python-devel
BuildRequires: scipy >= 0.8
BuildRequires: swig >= 3.0.7
BuildRequires: glue >= 1.54.1
BuildRequires: lal-devel >= 6.18.0
BuildRequires: lal-octave >= 6.18.0
BuildRequires: lal-python >= 6.18.0
BuildRequires: lalmetaio-devel >= 1.3.1
BuildRequires: lalmetaio-octave >= 1.3.1
BuildRequires: lalmetaio-python >= 1.3.1
BuildRequires: lalxml-devel >= 1.2.4
BuildRequires: lalxml-octave >= 1.2.4
BuildRequires: lalxml-python >= 1.2.4
BuildRequires: lalsimulation-devel >= 1.7.0
BuildRequires: lalsimulation-octave >= 1.7.0
BuildRequires: lalsimulation-python >= 1.7.0
BuildRequires: lalburst-devel >= 1.4.4
BuildRequires: lalburst-octave >= 1.4.4
BuildRequires: lalburst-python >= 1.4.4
BuildRequires: lalinspiral-devel >= 1.7.7
BuildRequires: lalinspiral-octave >= 1.7.7
BuildRequires: lalinspiral-python >= 1.7.7
BuildRequires: lalpulsar-devel >= 1.16.0
BuildRequires: lalpulsar-octave >= 1.16.0
BuildRequires: lalpulsar-python >= 1.16.0
Requires: chealpix
Requires: gsl >= 1.15
Requires: hdf5
Requires: libmetaio
Requires: libxml2
Requires: lal >= 6.18.0
Requires: lalmetaio >= 1.3.1
Requires: lalxml >= 1.2.4
Requires: lalsimulation >= 1.7.0
Requires: lalburst >= 1.4.4
Requires: lalinspiral >= 1.7.7
Requires: lalpulsar >= 1.16.0
Prefix: %{_prefix}

%description
The LSC Algorithm Inference Library for gravitational wave data analysis. This
package contains the shared-object libraries needed to run applications
that use the LAL Inference library.

%package devel
Summary: Files and documentation needed for compiling programs that use LAL Inference
Group: LAL
Requires: %{name} = %{version}
Requires: chealpix-devel >= 3.30.0
Requires: gsl-devel >= 1.15
Requires: libmetaio-devel
Requires: libxml2-devel
Requires: lal-devel >= 6.18.0
Requires: lalmetaio-devel >= 1.3.1
Requires: lalxml-devel >= 1.2.4
Requires: lalsimulation-devel >= 1.7.0
Requires: lalburst-devel >= 1.4.4
Requires: lalinspiral-devel >= 1.7.7
Requires: lalpulsar-devel >= 1.16.0
%description devel
The LSC Algorithm Inference Library for gravitational wave data analysis. This
package contains files needed build applications that use the LAL Inference
library.

%package python
Summary: Python Bindings for LALInference
Group: LAL
Requires: %{name} = %{version}
Requires: healpy >= 1.9.1
Requires: python-shapely
Requires: numpy >= 1.7
Requires: python
Requires: scipy >= 0.8
Requires: python-matplotlib >= 1.2.0
Requires: python-six
Requires: python-seaborn
Requires: glue >= 1.54.1
Requires: ligo-gracedb
Requires: lal-python >= 6.18.0
Requires: lalmetaio-python >= 1.3.1
Requires: lalxml-python >= 1.2.4
Requires: lalsimulation-python >= 1.7.0
Requires: lalburst-python >= 1.4.4
Requires: lalinspiral-python >= 1.7.7
Requires: lalpulsar-python >= 1.16.0
%description python
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Python bindings for LALInference.

%package octave
Summary: Octave Bindings for LALInference
Group: LAL
Requires: %{name} = %{version}
Requires: octave
Requires: lal-octave >= 6.18.0
Requires: lalmetaio-octave >= 1.3.1
Requires: lalxml-octave >= 1.2.4
Requires: lalsimulation-octave >= 1.7.0
Requires: lalburst-octave >= 1.4.4
Requires: lalinspiral-octave >= 1.7.7
Requires: lalpulsar-octave >= 1.16.0
%description octave
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Octave bindings for LALInference.

%prep
%setup -q

%build
%configure --disable-gcc-flags --enable-swig --enable-openmp
%{__make} V=1

%check
%{__make} V=1 check

%install
%make_install
find $RPM_BUILD_ROOT%{_libdir} -name '*.la' -delete

%post
ldconfig

%postun
ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}

%files
%defattr(-,root,root)
%{_bindir}/lalinference_*
%{_datarootdir}/lalinference/*
%{_libdir}/*.so.*
%{_sysconfdir}/*

%files devel
%defattr(-,root,root)
%{_includedir}/lal
%{_libdir}/*.a
%{_libdir}/*.so
%{_libdir}/pkgconfig/*

%files python
%defattr(-,root,root)
%{_bindir}/bayestar_*
%{_bindir}/imrtgr_*
%{_bindir}/rapidpe_*
%{_libdir}/python*

%files octave
%defattr(-,root,root)
%{_prefix}/lib*/octave/*/site/oct/*/lalinference.oct*

# dates should be formatted using: 'date +"%a %b %d %Y"'
%changelog
* Thu Jul 27 2017 Adam Mercer <adam.mercer@ligo.org> 1.9.4-1
- bayestar_plot_volume: work around broken fonts in SL7

* Wed Jul 26 2017 Adam Mercer <adam.mercer@ligo.org> 1.9.3-1
- BAYESTAR and sky map post-processing updates

* Thu Mar 16 2017 Adam Mercer <adam.mercer@ligo.org> 1.9.2-1
- lalinference.io.fits: remove some redundant keys on reading
- lalinference.io.fits: fix writing single-column sky maps

* Sat Feb 18 2017 Adam Mercer <adam.mercer@ligo.org> 1.9.1-1
- Do not use $(..._la_LIBADD) to link against external libraries
- Track version info API change
- Fix to weights calculation so that posterior samples are now drawn correctly
- Fix incorrect axes limits for Mollweide sky maps
- Drop code for reading past EOF of named pipe
- Fix incorrect reordering of IDL-compatible sky maps
- Tune default max distance for volume rendering plots

* Tue Feb 07 2017 Adam Mercer <adam.mercer@ligo.org> 1.9.0-1
- O2 release

* Thu Dec 15 2016 Adam Mercer <adam.mercer@ligo.org> 1.8.2-1
- Be more emphatic about switching matplotlib backend
- Prevent trying to build python3 packages when unsupported

* Fri Dec 09 2016 Adam Mercer <adam.mercer@ligo.org> 1.8.1-1
- Explicitly set no-op Matplotlib backend
- Set matplotlib backend to no-op

* Mon Sep 26 2016 Adam Mercer <adam.mercer@ligo.org> 1.8.0-1
- ER10 release

* Thu Jun 23 2016 Adam Mercer <adam.mercer@ligo.org> 1.7.0-1
- ER9 release

* Fri Mar 25 2016 Adam Mercer <adam.mercer@ligo.org> 1.6.0-1
- Pre O2 packaging test release
