%define nightly %{nil}
%define _sysconfdir %{_prefix}/etc
%define release 1
%define configure_opts %{nil}

%if "%{?nightly:%{nightly}}%{!?nightly:0}" == "%{nil}"
%undefine nightly
%endif

# -- metadata ---------------

Name: lalframe
Version: 1.5.1
Release: %{?nightly:0.%{nightly}}%{!?nightly:%{release}}%{?dist}
Summary: LSC Algorithm Frame Library
License: GPLv2+
Group: LAL
Source0: http://software.ligo.org/lscsoft/source/lalsuite/%{name}-%{version}%{?nightly:-%{nightly}}.tar.xz
URL: https://wiki.ligo.org/Computing/LALSuite
Packager: Adam Mercer <adam.mercer@ligo.org>
Prefix: %{_prefix}

# -- build requirements -----

# C
BuildRequires: libframel-devel >= 8.39.2
BuildRequires: gcc
BuildRequires: gcc-c++
BuildRequires: help2man
BuildRequires: lal-devel >= 7.0.0
BuildRequires: ldas-tools-framecpp-c-devel >= 2.5.5
BuildRequires: make
BuildRequires: pkgconfig >= 0.18.0

# swig
BuildRequires: swig >= 3.0.9

# python2
BuildRequires: python2-rpm-macros
BuildRequires: python-devel
BuildRequires: python2-lal >= 7.0.0
BuildRequires: python2-mock
BuildRequires: python2-numpy
BuildRequires: python-pathlib
BuildRequires: pytest

# python3x
BuildRequires: python-srpm-macros
BuildRequires: python3-rpm-macros
BuildRequires: epel-rpm-macros
BuildRequires: python%{python3_pkgversion}-devel
BuildRequires: python%{python3_pkgversion}-numpy
BuildRequires: python%{python3_pkgversion}-lal >= 7.0.0
BuildRequires: python%{python3_pkgversion}-pytest

# octave
BuildRequires: octave-devel
BuildRequires: lal-octave >= 7.0.0

# -- packages ---------------

# lalframe
Requires: lal >= 7.0.0
Requires: ldas-tools-framecpp-c >= 2.5.5
Requires: libframel >= 8.39.2

%description
The LSC Algorithm Frame Library for gravitational wave data analysis. This
package contains the shared-object libraries needed to run applications
that use the LAL Frame library.

# lalframe-devel
%package devel
Summary: Files and documentation needed for compiling programs that use LAL Frame
Group: LAL
Requires: %{name} = %{version}
Requires: libframel-devel >= 8.39.2
Requires: lal-devel >= 7.0.0
Requires: ldas-tools-framecpp-c-devel >= 2.5.5
%description devel
The LSC Algorithm Frame Library for gravitational wave data analysis. This
package contains files needed build applications that use the LAL Frame
library.

# python2-lalframe
%package -n python2-%{name}
Summary: Python %{python2_version} Bindings for LALFrame
Group: LAL
Requires: %{name} = %{version}
Requires: python
Requires: python2-lal >= 7.0.0
Requires: python2-numpy
Provides: %{name}-python = %{version}-%{release}
Obsoletes: %{name}-python < %{version}-%{release}
%{?python_provide:%python_provide python2-%{name}}
%description -n python2-%{name}
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Python %{python2_version} bindings for LALFrame.

# python3x-lalframe
%package -n python%{python3_pkgversion}-%{name}
Summary: Python %{python3_version} Bindings for LALFrame
Group: LAL
Requires: %{name} = %{version}
Requires: python%{python3_pkgversion}
Requires: python%{python3_pkgversion}-lal >= 7.0.0
Requires: python%{python3_pkgversion}-numpy
%{?python_provide:%python_provide python%{python3_pkgversion}-%{name}}
%description -n python%{python3_pkgversion}-%{name}
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Python %{python3_version} bindings for LALFrame.

# lalframe-octave
%package octave
Summary: Octave Bindings for LALFrame
Group: LAL
Requires: %{name} = %{version}
Requires: octave
Requires: lal-octave >= 7.0.0
%description octave
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Octave bindings for LALFrame.

# -- build stages -----------

%prep
%setup -q -n %{name}-%{version}%{?nightly:-%{nightly}}

%build
# build C library with python2
%configure %{configure_opts} --disable-gcc-flags --enable-swig PYTHON=%{__python2}
%{__make} %{?_smp_mflags} V=1

# build python3 library (copy things so we don't have to rebuild them)
rm -rf %py3dir
cp -r . %py3dir
pushd %py3dir
rm -rfv python/%{name}/*.{la,lo,o} python/%{name}/.libs
%configure %{configure_opts} --disable-doxygen --disable-gcc-flags --disable-swig-octave --enable-swig-python PYTHON=%{__python3}
%{__make} V=1 -C swig
%{__make} V=1 -C python/%{name}
popd

%check
# C + python2 + octave
%{__make} %{?_smp_mflags} V=1 VERBOSE=1 check
# python3
%{__make} %{?_smp_mflags} V=1 VERBOSE=1 -C %py3dir -C test/python check

%install
# C + python2 + octave
%make_install
# python3
%{__make} -C %py3dir -C swig install-exec-am DESTDIR=%{?buildroot}
%{__make} -C %py3dir -C python/%{name} install DESTDIR=%{?buildroot}
find $RPM_BUILD_ROOT%{_libdir} -name '*.la' -delete

%post
ldconfig

%postun
ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}%{?nightly:-%{nightly}}

# -- files ------------------

%files
%defattr(-,root,root)
%license COPYING
%{_bindir}/lalfr-*
%{_bindir}/lalframe_version
%{_mandir}/man1/*
%{_libdir}/*.so.*
%{_sysconfdir}/*

%files devel
%defattr(-,root,root)
%license COPYING
%{_includedir}/lal
%{_libdir}/*.a
%{_libdir}/*.so
%{_libdir}/pkgconfig/*

%files -n python2-%{name}
%defattr(-,root,root)
%license COPYING
%{python2_sitearch}/*

%files -n python%{python3_pkgversion}-%{name}
%defattr(-,root,root)
%license COPYING
%{python3_sitearch}/*

%files octave
%defattr(-,root,root)
%license COPYING
%{_prefix}/lib*/octave/*/site/oct/*/lalframe.oct*

# -- changelog --------------

# dates should be formatted using: 'date +"%a %b %d %Y"'
%changelog
* Mon Jun 08 2020 Adam Mercer <adam.mercer@ligo.org> 1.5.1-1
- Update for 1.5.1

* Mon Dec 09 2019 Adam Mercer <adam.mercer@ligo.org> 1.5.0-4
- Packaging updates

* Wed Dec 04 2019 Adam Mercer <adam.mercer@ligo.org> 1.5.0-3
- Packaging updates

* Wed Dec 04 2019 Adam Mercer <adam.mercer@ligo.org> 1.5.0-2
- Add missing dependency on python2-mock

* Fri Nov 22 2019 Adam Mercer <adam.mercer@ligo.org> 1.5.0-1
- O3b release

* Thu May 23 2019 Adam Mercer <adam.mercer@ligo.org> 1.4.5-1
- O3 release

* Thu Sep 13 2018 Adam Mercer <adam.mercer@ligo.org> 1.4.4-1
- Pre O3 release

* Tue Feb 07 2017 Adam Mercer <adam.mercer@ligo.org> 1.4.3-1
- O2 release

* Mon Sep 26 2016 Adam Mercer <adam.mercer@ligo.org> 1.4.2-1
- ER10 release

* Thu Jun 23 2016 Adam Mercer <adam.mercer@ligo.org> 1.4.1-1
- ER9 release

* Fri Mar 25 2016 Adam Mercer <adam.mercer@ligo.org> 1.4.0-1
- Pre O2 packaging test release
