%define _prefix /usr
%define _mandir %{_prefix}/share/man
%define _sysconfdir %{_prefix}/etc

Name: lalburst
Version: 1.3.0
Release: 1
Summary: LSC Algorithm Burst Library
License: GPL
Group: LAL
Source: %{name}-%{version}.tar.gz
URL: https://www.lsc-group.phys.uwm.edu/daswg/projects/lalsuite.html
Packager: Adam Mercer <adam.mercer@ligo.org>
BuildRoot: %{_tmppath}/%{name}-%{version}-root
BuildRequires: swig, python-devel, octave-devel, gsl-devel
BuildRequires: libmetaio-devel, numpy
BuildRequires: lal-devel >= 6.14.0
BuildRequires: lal-python >= 6.14.0
BuildRequires: lal-octave >= 6.14.0
BuildRequires: lalmetaio-devel >= 1.2.0
BuildRequires: lalmetaio-python >= 1.2.0
BuildRequires: lalmetaio-octave >= 1.2.0
BuildRequires: lalsimulation-devel >= 1.3.0
BuildRequires: lalsimulation-python >= 1.3.0
BuildRequires: lalsimulation-octave >= 1.3.0
Requires: gsl, libmetaio
Requires: lal >= 6.14.0
Requires: lalmetaio >= 1.2.0
Requires: lalsimulation >= 1.3.0
Prefix: %{_prefix}

%description
The LSC Algorithm Burst Library for gravitational wave data analysis. This
package contains the shared-object libraries needed to run applications
that use the LAL Burst library.

%package devel
Summary: Files and documentation needed for compiling programs that use LAL Burst
Group: LAL
Requires: %{name} = %{version}
Requires: gsl-devel, libmetaio-devel
Requires: lal-devel >= 6.14.0
Requires: lalmetaio-devel >= 1.2.0
Requires: lalsimulation-devel >= 1.3.0
%description devel
The LSC Algorithm Burst Library for gravitational wave data analysis. This
package contains files needed build applications that use the LAL Burst
library.

%package python
Summary: Python Bindings for LALBurst
Group: LAL
Requires: %{name} = %{version}
Requires: python, numpy
Requires: lal-python >= 6.14.0
Requires: lalmetaio-python >= 1.2.0
Requires: lalsimulation-python >= 1.3.0
%description python
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Python bindings for LALBurst.

%package octave
Summary: Octave Bindings for LALBurst
Group: LAL
Requires: %{name} = %{version}
Requires: octave
Requires: lal-octave >= 6.14.0
Requires: lalmetaio-octave >= 1.2.0
Requires: lalsimulation-octave >= 1.3.0
%description octave
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Octave bindings for LALBurst.

%prep
%setup -q

%build
%configure --disable-gcc-flags --enable-swig
%{__make} V=1

%check
%{__make} V=1 check

%install
%make_install
rm -f $RPM_BUILD_ROOT%{_libdir}/*.la

%post
ldconfig

%postun
ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}

%files
%defattr(-,root,root)
%{_libdir}/*.so*
%{_sysconfdir}/*
%exclude %{_libdir}/python*

%files devel
%defattr(-,root,root)
%{_libdir}/*.a
%{_libdir}/pkgconfig/*
%{_includedir}/lal

%files python
%defattr(-,root,root)
%{_libdir}/python*/site-packages/lalburst/*.py
%{_libdir}/python*/site-packages/lalburst/*.pyc
%{_libdir}/python*/site-packages/lalburst/_lalburst.so*
%exclude %{_libdir}/python*/site-packages/lalburst/*.pyo

%files octave
%defattr(-,root,root)
%{_libexecdir}/octave/*/site/oct/*/lalburst.oct*
