/*
 * Decompiled with CFR 0.152.
 */
package org.jline.utils;

import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jline.utils.AttributedCharSequence;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;

public class AttributedString
extends AttributedCharSequence {
    final char[] buffer;
    final long[] style;
    final int start;
    final int end;
    public static final AttributedString EMPTY = new AttributedString("");
    public static final AttributedString NEWLINE = new AttributedString("\n");

    public AttributedString(CharSequence str) {
        this(str, 0, str.length(), null);
    }

    public AttributedString(CharSequence str, int start, int end) {
        this(str, start, end, null);
    }

    public AttributedString(CharSequence str, AttributedStyle s) {
        this(str, 0, str.length(), s);
    }

    public AttributedString(CharSequence str, int start, int end, AttributedStyle s) {
        if (end < start) {
            throw new InvalidParameterException();
        }
        if (str instanceof AttributedString) {
            AttributedString as = (AttributedString)str;
            this.buffer = as.buffer;
            if (s != null) {
                this.style = (long[])as.style.clone();
                for (int i = 0; i < this.style.length; ++i) {
                    this.style[i] = this.style[i] & (s.getMask() ^ 0xFFFFFFFFFFFFFFFFL) | s.getStyle();
                }
            } else {
                this.style = as.style;
            }
            this.start = as.start + start;
            this.end = as.start + end;
        } else if (str instanceof AttributedStringBuilder) {
            AttributedStringBuilder asb = (AttributedStringBuilder)str;
            AttributedString as = asb.subSequence(start, end);
            this.buffer = as.buffer;
            this.style = as.style;
            if (s != null) {
                for (int i = 0; i < this.style.length; ++i) {
                    this.style[i] = this.style[i] & (s.getMask() ^ 0xFFFFFFFFFFFFFFFFL) | s.getStyle();
                }
            }
            this.start = as.start;
            this.end = as.end;
        } else {
            int l = end - start;
            this.buffer = new char[l];
            for (int i = 0; i < l; ++i) {
                this.buffer[i] = str.charAt(start + i);
            }
            this.style = new long[l];
            if (s != null) {
                Arrays.fill(this.style, s.getStyle());
            }
            this.start = 0;
            this.end = l;
        }
    }

    AttributedString(char[] buffer, long[] style, int start, int end) {
        this.buffer = buffer;
        this.style = style;
        this.start = start;
        this.end = end;
    }

    public static AttributedString fromAnsi(String ansi) {
        return AttributedString.fromAnsi(ansi, 0);
    }

    public static AttributedString fromAnsi(String ansi, int tabs) {
        return AttributedString.fromAnsi(ansi, Arrays.asList(tabs));
    }

    public static AttributedString fromAnsi(String ansi, List<Integer> tabs) {
        if (ansi == null) {
            return null;
        }
        return new AttributedStringBuilder(ansi.length()).tabs(tabs).ansiAppend(ansi).toAttributedString();
    }

    public static String stripAnsi(String ansi) {
        if (ansi == null) {
            return null;
        }
        return new AttributedStringBuilder(ansi.length()).ansiAppend(ansi).toString();
    }

    @Override
    protected char[] buffer() {
        return this.buffer;
    }

    @Override
    protected int offset() {
        return this.start;
    }

    @Override
    public int length() {
        return this.end - this.start;
    }

    @Override
    public AttributedStyle styleAt(int index2) {
        return new AttributedStyle(this.style[this.start + index2], this.style[this.start + index2]);
    }

    @Override
    long styleCodeAt(int index2) {
        return this.style[this.start + index2];
    }

    @Override
    public AttributedString subSequence(int start, int end) {
        return new AttributedString(this, start, end);
    }

    public AttributedString styleMatches(Pattern pattern, AttributedStyle style) {
        Matcher matcher2 = pattern.matcher(this);
        boolean result2 = matcher2.find();
        if (result2) {
            long[] newstyle = (long[])this.style.clone();
            do {
                for (int i = matcher2.start(); i < matcher2.end(); ++i) {
                    newstyle[this.start + i] = newstyle[this.start + i] & (style.getMask() ^ 0xFFFFFFFFFFFFFFFFL) | style.getStyle();
                }
            } while (result2 = matcher2.find());
            return new AttributedString(this.buffer, newstyle, this.start, this.end);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributedString that = (AttributedString)o;
        return this.end - this.start == that.end - that.start && this.arrEq(this.buffer, that.buffer, this.start, that.start, this.end - this.start) && this.arrEq(this.style, that.style, this.start, that.start, this.end - this.start);
    }

    private boolean arrEq(char[] a1, char[] a2, int s1, int s2, int l) {
        for (int i = 0; i < l; ++i) {
            if (a1[s1 + i] == a2[s2 + i]) continue;
            return false;
        }
        return true;
    }

    private boolean arrEq(long[] a1, long[] a2, int s1, int s2, int l) {
        for (int i = 0; i < l; ++i) {
            if (a1[s1 + i] == a2[s2 + i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result2 = Arrays.hashCode(this.buffer);
        result2 = 31 * result2 + Arrays.hashCode(this.style);
        result2 = 31 * result2 + this.start;
        result2 = 31 * result2 + this.end;
        return result2;
    }

    public static AttributedString join(AttributedString delimiter, AttributedString ... elements) {
        Objects.requireNonNull(delimiter);
        Objects.requireNonNull(elements);
        return AttributedString.join(delimiter, Arrays.asList(elements));
    }

    public static AttributedString join(AttributedString delimiter, Iterable<AttributedString> elements) {
        Objects.requireNonNull(elements);
        AttributedStringBuilder sb = new AttributedStringBuilder();
        int i = 0;
        for (AttributedString str : elements) {
            if (i++ > 0 && delimiter != null) {
                sb.append(delimiter);
            }
            sb.append(str);
        }
        return sb.toAttributedString();
    }
}

