/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.SourceFile;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.multiplatform.IsCommonSourceKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceFile;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/SealedInheritorInSameModuleChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "isFromCommonSource", "", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;)Z", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
public final class SealedInheritorInSameModuleChecker
implements DeclarationChecker {
    @NotNull
    public static final SealedInheritorInSameModuleChecker INSTANCE = new SealedInheritorInSameModuleChecker();

    private SealedInheritorInSameModuleChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context, "context");
        if (!(descriptor2 instanceof ClassDescriptor) || !(declaration instanceof KtClassOrObject)) {
            return;
        }
        ModuleDescriptor currentModule = DescriptorUtilsKt.getModule(descriptor2);
        for (KtSuperTypeListEntry superTypeListEntry : ((KtClassOrObject)declaration).getSuperTypeListEntries()) {
            ClassifierDescriptor superClass;
            KotlinType superType2;
            KtTypeReference typeReference;
            if (superTypeListEntry.getTypeReference() == null) continue;
            BindingContext bindingContext = context.getTrace().getBindingContext();
            Intrinsics.checkNotNullExpressionValue(bindingContext, "context.trace.bindingContext");
            KotlinType kotlinType = BindingContextUtilsKt.getAbbreviatedTypeOrType(typeReference, bindingContext);
            if (kotlinType == null) continue;
            if ((kotlinType = kotlinType.unwrap()) == null || (superType2 = kotlinType).getConstructor().getDeclarationDescriptor() == null || !DescriptorUtilKt.isSealed(superClass)) continue;
            if (this.isFromCommonSource((ClassifierDescriptor)descriptor2) && Intrinsics.areEqual(DescriptorUtilsKt.getModule(superClass), currentModule)) {
                return;
            }
            if (((ClassDescriptor)superClass).isExpect() || Intrinsics.areEqual(DescriptorUtilsKt.getModule(superClass), currentModule) && !this.isFromCommonSource(superClass)) continue;
            context.getTrace().report(Errors.SEALED_INHERITOR_IN_DIFFERENT_MODULE.on((KtTypeReference)((PsiElement)typeReference)));
        }
    }

    private final boolean isFromCommonSource(ClassifierDescriptor $this$isFromCommonSource) {
        SourceFile sourceFile = $this$isFromCommonSource.getSource().getContainingFile();
        PsiSourceFile psiSourceFile = sourceFile instanceof PsiSourceFile ? (PsiSourceFile)sourceFile : null;
        PsiFile psiFile = psiSourceFile != null ? psiSourceFile.getPsiFile() : null;
        Object object = psiFile instanceof KtFile ? (KtFile)psiFile : null;
        return object != null && (object = IsCommonSourceKt.isCommonSource((KtFile)object)) != null ? (Boolean)object : false;
    }
}

