/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.sisu.plexus;

import java.util.Map;
import org.jetbrains.kotlin.com.google.inject.Binder;
import org.jetbrains.kotlin.com.google.inject.Module;
import org.jetbrains.kotlin.org.codehaus.plexus.component.annotations.Component;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusAnnotatedMetadata;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusBeanMetadata;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusBeanModule;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusBeanSource;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusTypeBinder;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusTypeVisitor;
import org.jetbrains.kotlin.org.eclipse.sisu.space.BeanScanning;
import org.jetbrains.kotlin.org.eclipse.sisu.space.ClassSpace;
import org.jetbrains.kotlin.org.eclipse.sisu.space.SpaceModule;
import org.jetbrains.kotlin.org.eclipse.sisu.space.SpaceVisitor;

public final class PlexusAnnotatedBeanModule
implements PlexusBeanModule {
    private static final SpaceModule.Strategy PLEXUS_STRATEGY = new SpaceModule.Strategy(){

        @Override
        public SpaceVisitor visitor(Binder binder) {
            return new PlexusTypeVisitor(new PlexusTypeBinder(binder));
        }
    };
    private Module spaceModule;
    private final PlexusBeanSource beanSource;

    public PlexusAnnotatedBeanModule(ClassSpace space, Map<?, ?> variables) {
        this(space, variables, BeanScanning.ON);
    }

    public PlexusAnnotatedBeanModule(ClassSpace space, Map<?, ?> variables, BeanScanning scanning) {
        this.spaceModule = space != null && scanning != BeanScanning.OFF ? new SpaceModule(space, scanning).with(PLEXUS_STRATEGY) : null;
        this.beanSource = new PlexusAnnotatedBeanSource(variables);
    }

    public PlexusBeanModule with(SpaceModule.Strategy _strategy) {
        if (this.spaceModule instanceof SpaceModule) {
            this.spaceModule = ((SpaceModule)this.spaceModule).with(_strategy);
        }
        return this;
    }

    @Override
    public PlexusBeanSource configure(Binder binder) {
        if (this.spaceModule != null) {
            this.spaceModule.configure(binder);
        }
        return this.beanSource;
    }

    private static final class PlexusAnnotatedBeanSource
    implements PlexusBeanSource {
        private final PlexusBeanMetadata metadata;

        PlexusAnnotatedBeanSource(Map<?, ?> variables) {
            this.metadata = new PlexusAnnotatedMetadata(variables);
        }

        @Override
        public PlexusBeanMetadata getBeanMetadata(Class<?> implementation2) {
            return implementation2.isAnnotationPresent(Component.class) ? this.metadata : null;
        }
    }
}

