/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.util.version;

import java.util.ArrayList;
import java.util.Objects;
import org.jetbrains.kotlin.org.eclipse.aether.util.version.GenericVersion;
import org.jetbrains.kotlin.org.eclipse.aether.util.version.GenericVersionConstraint;
import org.jetbrains.kotlin.org.eclipse.aether.util.version.GenericVersionRange;
import org.jetbrains.kotlin.org.eclipse.aether.util.version.UnionVersionRange;
import org.jetbrains.kotlin.org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.jetbrains.kotlin.org.eclipse.aether.version.Version;
import org.jetbrains.kotlin.org.eclipse.aether.version.VersionConstraint;
import org.jetbrains.kotlin.org.eclipse.aether.version.VersionRange;
import org.jetbrains.kotlin.org.eclipse.aether.version.VersionScheme;

public final class GenericVersionScheme
implements VersionScheme {
    @Override
    public Version parseVersion(String version) throws InvalidVersionSpecificationException {
        Objects.requireNonNull(version, "version cannot be null");
        return new GenericVersion(version);
    }

    public VersionRange parseVersionRange(String range) throws InvalidVersionSpecificationException {
        Objects.requireNonNull(range, "range cannot be null");
        return new GenericVersionRange(range);
    }

    @Override
    public VersionConstraint parseVersionConstraint(String constraint2) throws InvalidVersionSpecificationException {
        Objects.requireNonNull(constraint2, "constraint cannot be null");
        ArrayList<VersionRange> ranges2 = new ArrayList<VersionRange>();
        String process2 = constraint2;
        while (process2.startsWith("[") || process2.startsWith("(")) {
            int index2;
            int index1 = process2.indexOf(41);
            int index3 = index2 = process2.indexOf(93);
            if (index2 < 0 || index1 >= 0 && index1 < index2) {
                index3 = index1;
            }
            if (index3 < 0) {
                throw new InvalidVersionSpecificationException(constraint2, "Unbounded version range " + constraint2);
            }
            VersionRange range = this.parseVersionRange(process2.substring(0, index3 + 1));
            ranges2.add(range);
            if ((process2 = process2.substring(index3 + 1).trim()).length() <= 0 || !process2.startsWith(",")) continue;
            process2 = process2.substring(1).trim();
        }
        if (process2.length() > 0 && !ranges2.isEmpty()) {
            throw new InvalidVersionSpecificationException(constraint2, "Invalid version range " + constraint2 + ", expected [ or ( but got " + process2);
        }
        GenericVersionConstraint result2 = ranges2.isEmpty() ? new GenericVersionConstraint(this.parseVersion(constraint2)) : new GenericVersionConstraint(UnionVersionRange.from(ranges2));
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj != null && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

