/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl;

import java.util.Objects;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.SimpleLocalRepositoryManager;
import org.jetbrains.kotlin.org.eclipse.aether.repository.LocalRepository;
import org.jetbrains.kotlin.org.eclipse.aether.repository.LocalRepositoryManager;
import org.jetbrains.kotlin.org.eclipse.aether.repository.NoLocalRepositoryManagerException;
import org.jetbrains.kotlin.org.eclipse.aether.spi.localrepo.LocalRepositoryManagerFactory;

@Singleton
@Named(value="simple")
public class SimpleLocalRepositoryManagerFactory
implements LocalRepositoryManagerFactory {
    private float priority;

    @Override
    public LocalRepositoryManager newInstance(RepositorySystemSession session2, LocalRepository repository) throws NoLocalRepositoryManagerException {
        Objects.requireNonNull(session2, "session cannot be null");
        Objects.requireNonNull(repository, "repository cannot be null");
        if ("".equals(repository.getContentType()) || "simple".equals(repository.getContentType())) {
            return new SimpleLocalRepositoryManager(repository.getBasedir());
        }
        throw new NoLocalRepositoryManagerException(repository);
    }

    @Override
    public float getPriority() {
        return this.priority;
    }
}

