/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.codehaus.plexus.classworlds.realm;

import java.io.Closeable;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.kotlin.org.codehaus.plexus.classworlds.ClassWorld;
import org.jetbrains.kotlin.org.codehaus.plexus.classworlds.realm.Entry;
import org.jetbrains.kotlin.org.codehaus.plexus.classworlds.strategy.Strategy;
import org.jetbrains.kotlin.org.codehaus.plexus.classworlds.strategy.StrategyFactory;

public class ClassRealm
extends URLClassLoader {
    private ClassWorld world;
    private String id;
    private SortedSet<Entry> foreignImports;
    private SortedSet<Entry> parentImports;
    private Strategy strategy;
    private ClassLoader parentClassLoader;
    private static final boolean isParallelCapable = Closeable.class.isAssignableFrom(URLClassLoader.class);
    private final ConcurrentMap<String, Object> lockMap;

    public ClassRealm(ClassWorld world, String id, ClassLoader baseClassLoader2) {
        super(new URL[0], baseClassLoader2);
        this.world = world;
        this.id = id;
        this.foreignImports = new TreeSet<Entry>();
        this.strategy = StrategyFactory.getStrategy(this);
        ConcurrentHashMap concurrentHashMap = this.lockMap = isParallelCapable ? new ConcurrentHashMap() : null;
        if (isParallelCapable) {
            super.getClassLoadingLock(this.getClass().getName());
        }
    }

    public String getId() {
        return this.id;
    }

    public ClassWorld getWorld() {
        return this.world;
    }

    boolean isImportedFromParent(String name2) {
        if (this.parentImports != null && !this.parentImports.isEmpty()) {
            for (Entry entry : this.parentImports) {
                if (!entry.matches(name2)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public ClassLoader getImportClassLoader(String name2) {
        for (Entry entry : this.foreignImports) {
            if (!entry.matches(name2)) continue;
            return entry.getClassLoader();
        }
        return null;
    }

    public Collection<ClassRealm> getImportRealms() {
        HashSet<ClassRealm> importRealms = new HashSet<ClassRealm>();
        for (Entry entry : this.foreignImports) {
            if (!(entry.getClassLoader() instanceof ClassRealm)) continue;
            importRealms.add((ClassRealm)entry.getClassLoader());
        }
        return importRealms;
    }

    public ClassLoader getParentClassLoader() {
        return this.parentClassLoader;
    }

    public void setParentRealm(ClassRealm realm) {
        this.parentClassLoader = realm;
    }

    public ClassRealm getParentRealm() {
        return this.parentClassLoader instanceof ClassRealm ? (ClassRealm)this.parentClassLoader : null;
    }

    @Override
    public void addURL(URL url) {
        String urlStr = url.toExternalForm();
        if (urlStr.startsWith("jar:") && urlStr.endsWith("!/")) {
            urlStr = urlStr.substring(4, urlStr.length() - 2);
            try {
                url = new URL(urlStr);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        super.addURL(url);
    }

    @Override
    public Class<?> loadClass(String name2) throws ClassNotFoundException {
        return this.loadClass(name2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name2, boolean resolve2) throws ClassNotFoundException {
        if (isParallelCapable) {
            return this.unsynchronizedLoadClass(name2, resolve2);
        }
        ClassRealm classRealm = this;
        synchronized (classRealm) {
            return this.unsynchronizedLoadClass(name2, resolve2);
        }
    }

    private Class<?> unsynchronizedLoadClass(String name2, boolean resolve2) throws ClassNotFoundException {
        try {
            return super.loadClass(name2, resolve2);
        }
        catch (ClassNotFoundException e) {
            return this.strategy.loadClass(name2);
        }
    }

    @Override
    protected Class<?> findClass(String name2) throws ClassNotFoundException {
        throw new ClassNotFoundException(name2);
    }

    @Override
    public URL getResource(String name2) {
        URL resource = super.getResource(name2);
        return resource != null ? resource : this.strategy.getResource(name2);
    }

    @Override
    public URL findResource(String name2) {
        return super.findResource(name2);
    }

    @Override
    public Enumeration<URL> getResources(String name2) throws IOException {
        LinkedHashSet<URL> resources = new LinkedHashSet<URL>(Collections.list(super.getResources(name2)));
        resources.addAll(Collections.list(this.strategy.getResources(name2)));
        return Collections.enumeration(resources);
    }

    @Override
    public Enumeration<URL> findResources(String name2) throws IOException {
        return super.findResources(name2);
    }

    public String toString() {
        return "ClassRealm[" + this.getId() + ", parent: " + this.getParentClassLoader() + "]";
    }

    public Class<?> loadClassFromImport(String name2) {
        ClassLoader importClassLoader = this.getImportClassLoader(name2);
        if (importClassLoader != null) {
            try {
                return importClassLoader.loadClass(name2);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> loadClassFromSelf(String name2) {
        Object object = this.getClassRealmLoadingLock(name2);
        synchronized (object) {
            try {
                Class<?> clazz = this.findLoadedClass(name2);
                if (clazz == null) {
                    clazz = super.findClass(name2);
                }
                return clazz;
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
    }

    private Object getClassRealmLoadingLock(String name2) {
        if (isParallelCapable) {
            return this.getClassLoadingLock(name2);
        }
        return this;
    }

    @Override
    protected Object getClassLoadingLock(String name2) {
        if (isParallelCapable) {
            Object newLock = new Object();
            Object lock = this.lockMap.putIfAbsent(name2, newLock);
            return lock == null ? newLock : lock;
        }
        return this;
    }

    public Class<?> loadClassFromParent(String name2) {
        ClassLoader parent2 = this.getParentClassLoader();
        if (parent2 != null && this.isImportedFromParent(name2)) {
            try {
                return parent2.loadClass(name2);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    public URL loadResourceFromImport(String name2) {
        ClassLoader importClassLoader = this.getImportClassLoader(name2);
        if (importClassLoader != null) {
            return importClassLoader.getResource(name2);
        }
        return null;
    }

    public URL loadResourceFromSelf(String name2) {
        return super.findResource(name2);
    }

    public URL loadResourceFromParent(String name2) {
        ClassLoader parent2 = this.getParentClassLoader();
        if (parent2 != null && this.isImportedFromParent(name2)) {
            return parent2.getResource(name2);
        }
        return null;
    }

    public Enumeration<URL> loadResourcesFromImport(String name2) {
        ClassLoader importClassLoader = this.getImportClassLoader(name2);
        if (importClassLoader != null) {
            try {
                return importClassLoader.getResources(name2);
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    public Enumeration<URL> loadResourcesFromSelf(String name2) {
        try {
            return super.findResources(name2);
        }
        catch (IOException e) {
            return null;
        }
    }

    public Enumeration<URL> loadResourcesFromParent(String name2) {
        ClassLoader parent2 = this.getParentClassLoader();
        if (parent2 != null && this.isImportedFromParent(name2)) {
            try {
                return parent2.getResources(name2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        if (isParallelCapable) {
            ClassRealm.registerAsParallelCapable();
        }
    }
}

