/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.wagon.shared.http;

import java.util.Objects;
import org.jetbrains.kotlin.org.apache.maven.wagon.proxy.ProxyInfo;
import org.jetbrains.kotlin.org.codehaus.plexus.util.StringUtils;

public class HttpMessageUtils {
    public static String formatTransferDebugMessage(String url, int statusCode, String reasonPhrase, ProxyInfo proxyInfo) {
        Objects.requireNonNull(url, "url cannot be null");
        String msg2 = url;
        if (statusCode != -1) {
            msg2 = msg2 + " -- status code: " + statusCode;
            if (StringUtils.isNotEmpty(reasonPhrase)) {
                msg2 = msg2 + ", reason phrase: " + reasonPhrase;
            }
        }
        if (proxyInfo != null) {
            msg2 = msg2 + " -- proxy: " + proxyInfo;
        }
        return msg2;
    }

    public static String formatTransferFailedMessage(String url, ProxyInfo proxyInfo) {
        return HttpMessageUtils.formatTransferFailedMessage(url, -1, null, proxyInfo);
    }

    public static String formatTransferFailedMessage(String url, int statusCode, String reasonPhrase, ProxyInfo proxyInfo) {
        return HttpMessageUtils.formatMessage("transfer failed for ", url, statusCode, reasonPhrase, proxyInfo);
    }

    public static String formatAuthorizationMessage(String url, int statusCode, String reasonPhrase, ProxyInfo proxyInfo) {
        switch (statusCode) {
            case 401: {
                return HttpMessageUtils.formatMessage("authentication failed for ", url, statusCode, reasonPhrase, null);
            }
            case 403: {
                return HttpMessageUtils.formatMessage("authorization failed for ", url, statusCode, reasonPhrase, null);
            }
            case 407: {
                return HttpMessageUtils.formatMessage("proxy authentication failed for ", url, statusCode, reasonPhrase, null);
            }
        }
        return HttpMessageUtils.formatMessage("authorization failed for ", url, statusCode, reasonPhrase, proxyInfo);
    }

    public static String formatResourceDoesNotExistMessage(String url, int statusCode, String reasonPhrase, ProxyInfo proxyInfo) {
        return HttpMessageUtils.formatMessage("resource missing at ", url, statusCode, reasonPhrase, proxyInfo);
    }

    private static String formatMessage(String message, String url, int statusCode, String reasonPhrase, ProxyInfo proxyInfo) {
        Objects.requireNonNull(message, "message cannot be null");
        Objects.requireNonNull(url, "url cannot be null");
        String msg2 = message + url;
        if (statusCode != -1) {
            msg2 = msg2 + ", status: " + statusCode;
            if (StringUtils.isNotEmpty(reasonPhrase)) {
                msg2 = msg2 + " " + reasonPhrase;
            } else {
                switch (statusCode) {
                    case 401: {
                        msg2 = msg2 + " Unauthorized";
                        break;
                    }
                    case 403: {
                        msg2 = msg2 + " Forbidden";
                        break;
                    }
                    case 404: {
                        msg2 = msg2 + " Not Found";
                        break;
                    }
                    case 407: {
                        msg2 = msg2 + " Proxy Authentication Required";
                        break;
                    }
                    case 410: {
                        msg2 = msg2 + " Gone";
                        break;
                    }
                }
            }
        }
        if (proxyInfo != null) {
            msg2 = msg2 + ", proxy: " + proxyInfo;
        }
        return msg2;
    }
}

