/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.settings;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.kotlin.org.apache.maven.settings.Mirror;
import org.jetbrains.kotlin.org.apache.maven.settings.Profile;
import org.jetbrains.kotlin.org.apache.maven.settings.Proxy;
import org.jetbrains.kotlin.org.apache.maven.settings.Server;
import org.jetbrains.kotlin.org.apache.maven.settings.TrackableBase;

public class Settings
extends TrackableBase
implements Serializable,
Cloneable {
    private String localRepository;
    private boolean interactiveMode = true;
    private boolean usePluginRegistry = false;
    private boolean offline = false;
    private List<Proxy> proxies;
    private List<Server> servers;
    private List<Mirror> mirrors;
    private List<Profile> profiles;
    private List<String> activeProfiles;
    private List<String> pluginGroups;
    private String modelEncoding = "UTF-8";
    private Proxy activeProxy;

    @Override
    public Settings clone() {
        try {
            Settings copy2 = (Settings)super.clone();
            if (this.proxies != null) {
                copy2.proxies = new ArrayList<Proxy>();
                for (Proxy proxy : this.proxies) {
                    copy2.proxies.add(proxy.clone());
                }
            }
            if (this.servers != null) {
                copy2.servers = new ArrayList<Server>();
                for (Server server : this.servers) {
                    copy2.servers.add(server.clone());
                }
            }
            if (this.mirrors != null) {
                copy2.mirrors = new ArrayList<Mirror>();
                for (Mirror mirror : this.mirrors) {
                    copy2.mirrors.add(mirror.clone());
                }
            }
            if (this.profiles != null) {
                copy2.profiles = new ArrayList<Profile>();
                for (Profile profile : this.profiles) {
                    copy2.profiles.add(profile.clone());
                }
            }
            if (this.activeProfiles != null) {
                copy2.activeProfiles = new ArrayList<String>();
                copy2.activeProfiles.addAll(this.activeProfiles);
            }
            if (this.pluginGroups != null) {
                copy2.pluginGroups = new ArrayList<String>();
                copy2.pluginGroups.addAll(this.pluginGroups);
            }
            return copy2;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public List<String> getActiveProfiles() {
        if (this.activeProfiles == null) {
            this.activeProfiles = new ArrayList<String>();
        }
        return this.activeProfiles;
    }

    public String getLocalRepository() {
        return this.localRepository;
    }

    public List<Mirror> getMirrors() {
        if (this.mirrors == null) {
            this.mirrors = new ArrayList<Mirror>();
        }
        return this.mirrors;
    }

    public String getModelEncoding() {
        return this.modelEncoding;
    }

    public List<String> getPluginGroups() {
        if (this.pluginGroups == null) {
            this.pluginGroups = new ArrayList<String>();
        }
        return this.pluginGroups;
    }

    public List<Profile> getProfiles() {
        if (this.profiles == null) {
            this.profiles = new ArrayList<Profile>();
        }
        return this.profiles;
    }

    public List<Proxy> getProxies() {
        if (this.proxies == null) {
            this.proxies = new ArrayList<Proxy>();
        }
        return this.proxies;
    }

    public List<Server> getServers() {
        if (this.servers == null) {
            this.servers = new ArrayList<Server>();
        }
        return this.servers;
    }

    public boolean isInteractiveMode() {
        return this.interactiveMode;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public boolean isUsePluginRegistry() {
        return this.usePluginRegistry;
    }

    public void setActiveProfiles(List<String> activeProfiles) {
        this.activeProfiles = activeProfiles;
    }

    public void setInteractiveMode(boolean interactiveMode) {
        this.interactiveMode = interactiveMode;
    }

    public void setLocalRepository(String localRepository) {
        this.localRepository = localRepository;
    }

    public void setMirrors(List<Mirror> mirrors) {
        this.mirrors = mirrors;
    }

    public void setModelEncoding(String modelEncoding) {
        this.modelEncoding = modelEncoding;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    public void setPluginGroups(List<String> pluginGroups) {
        this.pluginGroups = pluginGroups;
    }

    public void setProfiles(List<Profile> profiles) {
        this.profiles = profiles;
    }

    public void setProxies(List<Proxy> proxies) {
        this.proxies = proxies;
    }

    public void setServers(List<Server> servers) {
        this.servers = servers;
    }

    public void setUsePluginRegistry(boolean usePluginRegistry) {
        this.usePluginRegistry = usePluginRegistry;
    }

    public synchronized Proxy getActiveProxy() {
        List<Proxy> proxies;
        if (this.activeProxy == null && (proxies = this.getProxies()) != null && !proxies.isEmpty()) {
            for (Proxy proxy : proxies) {
                if (!proxy.isActive()) continue;
                this.activeProxy = proxy;
                break;
            }
        }
        return this.activeProxy;
    }
}

