/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.artifact.versioning;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import org.jetbrains.kotlin.org.apache.maven.artifact.versioning.ArtifactVersion;
import org.jetbrains.kotlin.org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.jetbrains.kotlin.org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.jetbrains.kotlin.org.apache.maven.artifact.versioning.Restriction;

public class VersionRange {
    private static final Map<String, VersionRange> CACHE_SPEC = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<String, VersionRange> CACHE_VERSION = Collections.synchronizedMap(new WeakHashMap());
    private final ArtifactVersion recommendedVersion;
    private final List<Restriction> restrictions;

    private VersionRange(ArtifactVersion recommendedVersion, List<Restriction> restrictions) {
        this.recommendedVersion = recommendedVersion;
        this.restrictions = restrictions;
    }

    public static VersionRange createFromVersionSpec(String spec) throws InvalidVersionSpecificationException {
        if (spec == null) {
            return null;
        }
        VersionRange cached2 = CACHE_SPEC.get(spec);
        if (cached2 != null) {
            return cached2;
        }
        ArrayList<Restriction> restrictions = new ArrayList<Restriction>();
        String process2 = spec;
        DefaultArtifactVersion version = null;
        ArtifactVersion upperBound = null;
        ArtifactVersion lowerBound = null;
        while (process2.startsWith("[") || process2.startsWith("(")) {
            int index2;
            int index1 = process2.indexOf(41);
            int index3 = index2 = process2.indexOf(93);
            if ((index2 < 0 || index1 < index2) && index1 >= 0) {
                index3 = index1;
            }
            if (index3 < 0) {
                throw new InvalidVersionSpecificationException("Unbounded range: " + spec);
            }
            Restriction restriction = VersionRange.parseRestriction(process2.substring(0, index3 + 1));
            if (lowerBound == null) {
                lowerBound = restriction.getLowerBound();
            }
            if (upperBound != null && (restriction.getLowerBound() == null || restriction.getLowerBound().compareTo(upperBound) < 0)) {
                throw new InvalidVersionSpecificationException("Ranges overlap: " + spec);
            }
            restrictions.add(restriction);
            upperBound = restriction.getUpperBound();
            if ((process2 = process2.substring(index3 + 1).trim()).length() <= 0 || !process2.startsWith(",")) continue;
            process2 = process2.substring(1).trim();
        }
        if (process2.length() > 0) {
            if (restrictions.size() > 0) {
                throw new InvalidVersionSpecificationException("Only fully-qualified sets allowed in multiple set scenario: " + spec);
            }
            version = new DefaultArtifactVersion(process2);
            restrictions.add(Restriction.EVERYTHING);
        }
        cached2 = new VersionRange(version, restrictions);
        CACHE_SPEC.put(spec, cached2);
        return cached2;
    }

    private static Restriction parseRestriction(String spec) throws InvalidVersionSpecificationException {
        Restriction restriction;
        boolean lowerBoundInclusive = spec.startsWith("[");
        boolean upperBoundInclusive = spec.endsWith("]");
        String process2 = spec.substring(1, spec.length() - 1).trim();
        int index2 = process2.indexOf(44);
        if (index2 < 0) {
            if (!lowerBoundInclusive || !upperBoundInclusive) {
                throw new InvalidVersionSpecificationException("Single version must be surrounded by []: " + spec);
            }
            DefaultArtifactVersion version = new DefaultArtifactVersion(process2);
            restriction = new Restriction(version, lowerBoundInclusive, version, upperBoundInclusive);
        } else {
            String upperBound;
            String lowerBound = process2.substring(0, index2).trim();
            if (lowerBound.equals(upperBound = process2.substring(index2 + 1).trim())) {
                throw new InvalidVersionSpecificationException("Range cannot have identical boundaries: " + spec);
            }
            DefaultArtifactVersion lowerVersion = null;
            if (lowerBound.length() > 0) {
                lowerVersion = new DefaultArtifactVersion(lowerBound);
            }
            DefaultArtifactVersion upperVersion = null;
            if (upperBound.length() > 0) {
                upperVersion = new DefaultArtifactVersion(upperBound);
            }
            if (upperVersion != null && lowerVersion != null && upperVersion.compareTo(lowerVersion) < 0) {
                throw new InvalidVersionSpecificationException("Range defies version ordering: " + spec);
            }
            restriction = new Restriction(lowerVersion, lowerBoundInclusive, upperVersion, upperBoundInclusive);
        }
        return restriction;
    }

    public String toString() {
        if (this.recommendedVersion != null) {
            return this.recommendedVersion.toString();
        }
        StringBuilder buf = new StringBuilder();
        Iterator<Restriction> i = this.restrictions.iterator();
        while (i.hasNext()) {
            Restriction r = i.next();
            buf.append(r.toString());
            if (!i.hasNext()) continue;
            buf.append(',');
        }
        return buf.toString();
    }

    public boolean containsVersion(ArtifactVersion version) {
        for (Restriction restriction : this.restrictions) {
            if (!restriction.containsVersion(version)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRestrictions() {
        return !this.restrictions.isEmpty() && this.recommendedVersion == null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VersionRange)) {
            return false;
        }
        VersionRange other = (VersionRange)obj;
        return Objects.equals(this.recommendedVersion, other.recommendedVersion) && Objects.equals(this.restrictions, other.restrictions);
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (this.recommendedVersion == null ? 0 : this.recommendedVersion.hashCode());
        hash = 31 * hash + (this.restrictions == null ? 0 : this.restrictions.hashCode());
        return hash;
    }
}

