/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineOnlyKt;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J$\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u0011H\u0002J$\u0010\u0012\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u0011H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsExportDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "isExportable", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "currentlyProcessed", "", "isExportableReturn", "js.frontend"})
public final class JsExportDeclarationChecker
implements DeclarationChecker {
    @NotNull
    public static final JsExportDeclarationChecker INSTANCE = new JsExportDeclarationChecker();

    private JsExportDeclarationChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        block28: {
            DeclarationDescriptor declarationDescriptor;
            BindingContext bindingContext;
            BindingTrace trace;
            block27: {
                boolean hasJsName;
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
                Intrinsics.checkNotNullParameter(context, "context");
                trace = context.getTrace();
                BindingContext bindingContext2 = trace.getBindingContext();
                Intrinsics.checkNotNullExpressionValue(bindingContext2, "trace.bindingContext");
                bindingContext = bindingContext2;
                if (!AnnotationsUtils.isExportedObject(descriptor2, bindingContext)) {
                    return;
                }
                if (!(descriptor2 instanceof MemberDescriptor)) {
                    return;
                }
                boolean bl = hasJsName = AnnotationsUtils.getJsNameAnnotation(descriptor2) != null;
                if (((MemberDescriptor)descriptor2).isExpect()) {
                    JsExportDeclarationChecker.check$reportWrongExportedDeclaration(trace, declaration, "expect");
                }
                if (!((declarationDescriptor = descriptor2) instanceof FunctionDescriptor)) break block27;
                for (TypeParameterDescriptor typeParameter : ((FunctionDescriptor)descriptor2).getTypeParameters()) {
                    Intrinsics.checkNotNullExpressionValue(typeParameter, "typeParameter");
                    JsExportDeclarationChecker.check$checkTypeParameter(bindingContext, trace, typeParameter);
                }
                if (InlineOnlyKt.isInlineWithReified((MemberDescriptor)descriptor2)) {
                    JsExportDeclarationChecker.check$reportWrongExportedDeclaration(trace, declaration, "inline function with reified type parameters");
                    return;
                }
                if (((FunctionDescriptor)descriptor2).isSuspend()) {
                    JsExportDeclarationChecker.check$reportWrongExportedDeclaration(trace, declaration, "suspend function");
                    return;
                }
                if (descriptor2 instanceof ConstructorDescriptor && !((ConstructorDescriptor)descriptor2).isPrimary() && !hasJsName) {
                    JsExportDeclarationChecker.check$reportWrongExportedDeclaration(trace, declaration, "secondary constructor without @JsName");
                }
                if (descriptor2 instanceof PropertyAccessorDescriptor) break block28;
                for (ValueParameterDescriptor parameter : ((FunctionDescriptor)descriptor2).getValueParameters()) {
                    Intrinsics.checkNotNullExpressionValue(parameter, "parameter");
                    JsExportDeclarationChecker.check$checkValueParameter(bindingContext, trace, parameter);
                }
                KotlinType kotlinType = ((FunctionDescriptor)descriptor2).getReturnType();
                if (kotlinType == null) break block28;
                KotlinType returnType2 = kotlinType;
                boolean bl2 = false;
                if (JsExportDeclarationChecker.isExportableReturn$default(INSTANCE, returnType2, bindingContext, null, 2, null)) break block28;
                trace.report(ErrorsJs.NON_EXPORTABLE_TYPE.on(declaration, "return", returnType2));
                break block28;
            }
            if (declarationDescriptor instanceof PropertyDescriptor) {
                if (DescriptorUtilsKt.isExtensionProperty(descriptor2)) {
                    JsExportDeclarationChecker.check$reportWrongExportedDeclaration(trace, declaration, "extension property");
                    return;
                }
                KotlinType kotlinType = ((PropertyDescriptor)descriptor2).getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType, "descriptor.type");
                if (!JsExportDeclarationChecker.isExportable$default(this, kotlinType, bindingContext, null, 2, null)) {
                    trace.report(ErrorsJs.NON_EXPORTABLE_TYPE.on(declaration, "property", ((PropertyDescriptor)descriptor2).getType()));
                }
            } else if (declarationDescriptor instanceof ClassDescriptor) {
                boolean bl;
                Collection<KotlinType> supertypes2;
                block26: {
                    String wrongDeclaration;
                    for (TypeParameterDescriptor typeParameter : ((ClassDescriptor)descriptor2).getDeclaredTypeParameters()) {
                        Intrinsics.checkNotNullExpressionValue(typeParameter, "typeParameter");
                        JsExportDeclarationChecker.check$checkTypeParameter(bindingContext, trace, typeParameter);
                    }
                    switch (WhenMappings.$EnumSwitchMapping$0[((ClassDescriptor)descriptor2).getKind().ordinal()]) {
                        case 1: {
                            String string2 = "annotation class";
                            break;
                        }
                        case 2: {
                            String string2;
                            if (DescriptorUtilsKt.isInsideInterface(descriptor2)) {
                                string2 = "nested class inside exported interface";
                                break;
                            }
                            if (InlineClassesUtilsKt.isInlineClass(descriptor2)) {
                                string2 = (((ClassDescriptor)descriptor2).isInline() ? "inline " : "") + (((ClassDescriptor)descriptor2).isValue() ? "value " : "") + "class";
                                break;
                            }
                            string2 = null;
                            break;
                        }
                        default: {
                            String string2 = DescriptorUtilsKt.isInsideInterface(descriptor2) ? (((ClassDescriptor)descriptor2).isCompanionObject() ? "companion object" : "nested/inner declaration") + " inside exported interface" : (wrongDeclaration = null);
                        }
                    }
                    if (wrongDeclaration != null) {
                        JsExportDeclarationChecker.check$reportWrongExportedDeclaration(trace, declaration, wrongDeclaration);
                        return;
                    }
                    if (((ClassDescriptor)descriptor2).getKind() == ClassKind.ENUM_ENTRY) {
                        return;
                    }
                    SimpleType simpleType2 = ((ClassDescriptor)descriptor2).getDefaultType();
                    Intrinsics.checkNotNullExpressionValue(simpleType2, "descriptor.defaultType");
                    supertypes2 = TypeUtilsKt.supertypes(simpleType2);
                    Iterable $this$any$iv = supertypes2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            KotlinType it = (KotlinType)element$iv;
                            boolean bl3 = false;
                            if (!KotlinBuiltIns.isEnum(it)) continue;
                            bl = true;
                            break block26;
                        }
                        bl = false;
                    }
                }
                boolean isEnum = bl;
                for (KotlinType superType2 : supertypes2) {
                    if (JsExportDeclarationChecker.isExportable$default(this, superType2, bindingContext, null, 2, null) || KotlinBuiltIns.isComparable(superType2) && isEnum) continue;
                    trace.report(ErrorsJs.NON_EXPORTABLE_TYPE.on(declaration, "super", superType2));
                }
            }
        }
    }

    private final boolean isExportableReturn(KotlinType $this$isExportableReturn, BindingContext bindingContext, Set<KotlinType> currentlyProcessed) {
        return TypeUtilsKt.isUnit($this$isExportableReturn) || this.isExportable($this$isExportableReturn, bindingContext, currentlyProcessed);
    }

    static /* synthetic */ boolean isExportableReturn$default(JsExportDeclarationChecker jsExportDeclarationChecker, KotlinType kotlinType, BindingContext bindingContext, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = new LinkedHashSet();
        }
        return jsExportDeclarationChecker.isExportableReturn(kotlinType, bindingContext, set);
    }

    private final boolean isExportable(KotlinType $this$isExportable, BindingContext bindingContext, Set<KotlinType> currentlyProcessed) {
        boolean isPrimitiveExportableType;
        if (!currentlyProcessed.add($this$isExportable)) {
            return true;
        }
        currentlyProcessed.add($this$isExportable);
        if (FunctionTypesKt.isFunctionType($this$isExportable)) {
            int n = CollectionsKt.getLastIndex($this$isExportable.getArguments());
            for (int i = 0; i < n; ++i) {
                KotlinType kotlinType = $this$isExportable.getArguments().get(i).getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType, "arguments[i].type");
                if (this.isExportable(kotlinType, bindingContext, currentlyProcessed)) continue;
                currentlyProcessed.remove($this$isExportable);
                return false;
            }
            currentlyProcessed.remove($this$isExportable);
            KotlinType kotlinType = CollectionsKt.last($this$isExportable.getArguments()).getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "arguments.last().type");
            return this.isExportableReturn(kotlinType, bindingContext, currentlyProcessed);
        }
        for (TypeProjection argument2 : $this$isExportable.getArguments()) {
            KotlinType kotlinType = argument2.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "argument.type");
            if (this.isExportable(kotlinType, bindingContext, currentlyProcessed)) continue;
            currentlyProcessed.remove($this$isExportable);
            return false;
        }
        currentlyProcessed.remove($this$isExportable);
        KotlinType nonNullable = TypeUtilsKt.makeNotNullable($this$isExportable);
        boolean bl = isPrimitiveExportableType = TypeUtilsKt.isAnyOrNullableAny(nonNullable) || DynamicTypesKt.isDynamic(nonNullable) || TypeUtilsKt.isBoolean(nonNullable) || KotlinBuiltIns.isThrowableOrNullableThrowable(nonNullable) || KotlinBuiltIns.isString(nonNullable) || TypeUtilsKt.isPrimitiveNumberOrNullableType(nonNullable) && !TypeUtilsKt.isLong(nonNullable) || TypeUtilsKt.isNothingOrNullableNothing(nonNullable) || KotlinBuiltIns.isArray($this$isExportable) || KotlinBuiltIns.isPrimitiveArray($this$isExportable);
        if (isPrimitiveExportableType) {
            return true;
        }
        ClassifierDescriptor descriptor2 = $this$isExportable.getConstructor().getDeclarationDescriptor();
        if (!(descriptor2 instanceof MemberDescriptor)) {
            return false;
        }
        if (KotlinBuiltIns.isEnum($this$isExportable)) {
            return true;
        }
        return DescriptorUtilsKt.isEffectivelyExternal((MemberDescriptor)((Object)descriptor2)) || AnnotationsUtils.isExportedObject(descriptor2, bindingContext);
    }

    static /* synthetic */ boolean isExportable$default(JsExportDeclarationChecker jsExportDeclarationChecker, KotlinType kotlinType, BindingContext bindingContext, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = new LinkedHashSet();
        }
        return jsExportDeclarationChecker.isExportable(kotlinType, bindingContext, set);
    }

    private static final void check$checkTypeParameter(BindingContext bindingContext, BindingTrace trace, TypeParameterDescriptor descriptor2) {
        for (KotlinType upperBound : descriptor2.getUpperBounds()) {
            PsiElement typeParameterDeclaration;
            Intrinsics.checkNotNullExpressionValue(upperBound, "upperBound");
            if (JsExportDeclarationChecker.isExportable$default(INSTANCE, upperBound, bindingContext, null, 2, null)) continue;
            Intrinsics.checkNotNull(DescriptorToSourceUtils.descriptorToDeclaration(descriptor2));
            trace.report(ErrorsJs.NON_EXPORTABLE_TYPE.on(typeParameterDeclaration, "upper bound", upperBound));
        }
    }

    private static final void check$checkValueParameter(BindingContext bindingContext, BindingTrace trace, ValueParameterDescriptor descriptor2) {
        KotlinType kotlinType = descriptor2.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "descriptor.type");
        if (!JsExportDeclarationChecker.isExportable$default(INSTANCE, kotlinType, bindingContext, null, 2, null)) {
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
            Intrinsics.checkNotNull(psiElement);
            PsiElement valueParameterDeclaration = psiElement;
            trace.report(ErrorsJs.NON_EXPORTABLE_TYPE.on(valueParameterDeclaration, "parameter", descriptor2.getType()));
        }
    }

    private static final void check$reportWrongExportedDeclaration(BindingTrace trace, KtDeclaration $declaration, String kind) {
        trace.report(ErrorsJs.WRONG_EXPORTED_DECLARATION.on((KtExpression)((PsiElement)$declaration), kind));
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClassKind.values().length];
            nArray[ClassKind.ANNOTATION_CLASS.ordinal()] = 1;
            nArray[ClassKind.CLASS.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

