/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.backend.js.JsIntrinsics;
import org.jetbrains.kotlin.ir.backend.js.export.ExportModelGeneratorKt;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrDeclarationToJsTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrFunctionToJsTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsAstUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsClassGenerator;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsClassGeneratorKt;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsIrClassModel;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrResolveUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContext;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContextKt;
import org.jetbrains.kotlin.ir.backend.js.utils.Namer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsClass;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsGlobalBlock;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.common.IdentifierPolicyKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u001b\u001a\u00020\u001cJ\n\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\n\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J\b\u0010!\u001a\u00020\u001cH\u0002J\n\u0010\"\u001a\u0004\u0018\u00010\nH\u0002J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001c0$H\u0002J\u001e\u0010%\u001a\u0010\u0012\u0004\u0012\u00020'\u0012\u0006\u0012\u0004\u0018\u00010(0&2\u0006\u0010)\u001a\u00020*H\u0002J\n\u0010+\u001a\u0004\u0018\u00010,H\u0002J\n\u0010-\u001a\u0004\u0018\u00010,H\u0002J\b\u0010.\u001a\u00020\u001aH\u0002J\b\u0010/\u001a\u000200H\u0002J\u000e\u00101\u001a\u0004\u0018\u00010\n*\u00020*H\u0002J\u0014\u00102\u001a\u000200*\u00020*2\u0006\u00103\u001a\u00020'H\u0002J,\u00104\u001a\u0004\u0018\u00010'*\u0004\u0018\u00010*2\u0019\u00105\u001a\u0015\u0012\u0004\u0012\u00020*\u0012\u0006\u0012\u0004\u0018\u00010(06\u00a2\u0006\u0002\b7H\u0082\bJ\f\u00108\u001a\u00020\u001a*\u00020*H\u0002J\f\u00109\u001a\u00020\u001a*\u00020*H\u0002J\f\u0010:\u001a\u00020\u001a*\u00020\bH\u0002J\f\u0010;\u001a\u00020'*\u00020*H\u0002J\f\u0010<\u001a\u00020\u001a*\u00020\u0003H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\t\u001a\u0004\u0018\u00010\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsClassGenerator;", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;)V", "baseClass", "Lorg/jetbrains/kotlin/ir/types/IrType;", "baseClassRef", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "getBaseClassRef", "()Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "baseClassRef$delegate", "Lkotlin/Lazy;", "classBlock", "Lorg/jetbrains/kotlin/js/backend/ast/JsGlobalBlock;", "classModel", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIrClassModel;", "className", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "classNameRef", "classPrototypeRef", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;", "es6mode", "", "generate", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "generateAssociatedObjectKey", "Lorg/jetbrains/kotlin/js/backend/ast/JsIntLiteral;", "generateAssociatedObjects", "Lorg/jetbrains/kotlin/js/backend/ast/JsObjectLiteral;", "generateClassMetadata", "generateFastPrototype", "generateInheritanceCode", "", "generateMemberFunction", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "generateSuperClasses", "Lorg/jetbrains/kotlin/js/backend/ast/JsArrayLiteral;", "generateSuspendArity", "isCoroutineClass", "maybeGeneratePrimaryConstructor", "", "accessorRef", "generateAssignmentIfMangled", "memberRef", "getOrGenerateIfFinal", "generateFunc", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "hasMangledName", "isDefinedInsideExportedInterface", "isFunctionType", "prototypeAccessRef", "shouldCopyFrom", "backend.js"})
public final class JsClassGenerator {
    @NotNull
    private final IrClass irClass;
    @NotNull
    private final JsGenerationContext context;
    @NotNull
    private final JsName className;
    @NotNull
    private final JsNameRef classNameRef;
    @Nullable
    private final IrType baseClass;
    @NotNull
    private final Lazy baseClassRef$delegate;
    @NotNull
    private final JsNameRef classPrototypeRef;
    @NotNull
    private final JsGlobalBlock classBlock;
    @NotNull
    private final JsIrClassModel classModel;
    private final boolean es6mode;

    /*
     * WARNING - void declaration
     */
    public JsClassGenerator(@NotNull IrClass irClass2, @NotNull JsGenerationContext context) {
        Object v1;
        block1: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter(irClass2, "irClass");
            Intrinsics.checkNotNullParameter(context, "context");
            this.irClass = irClass2;
            this.context = context;
            this.className = this.context.getNameForClass(this.irClass);
            JsNameRef jsNameRef = this.className.makeRef();
            Intrinsics.checkNotNullExpressionValue(jsNameRef, "className.makeRef()");
            this.classNameRef = jsNameRef;
            Iterable iterable = this.irClass.getSuperTypes();
            JsClassGenerator jsClassGenerator = this;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IrType it = (IrType)element$iv;
                boolean bl = false;
                if (!(!JsClassGeneratorKt.access$isInterface(IrTypesKt.getClassifierOrFail(it)))) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        jsClassGenerator.baseClass = v1;
        this.baseClassRef$delegate = LazyKt.lazy((Function0)new Function0<JsNameRef>(this){
            final /* synthetic */ JsClassGenerator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final JsNameRef invoke() {
                return JsClassGenerator.access$getBaseClass$p(this.this$0) != null && !IrTypePredicatesKt.isAny(JsClassGenerator.access$getBaseClass$p(this.this$0)) ? IrTypeUtilsKt.getClassRef(JsClassGenerator.access$getBaseClass$p(this.this$0), this.this$0.getContext()) : null;
            }
        });
        this.classPrototypeRef = JsAstUtilsKt.prototypeOf(this.classNameRef);
        this.classBlock = new JsGlobalBlock();
        this.classModel = new JsIrClassModel(this.irClass);
        this.es6mode = this.context.getStaticContext().getBackendContext().getEs6mode();
    }

    @NotNull
    public final JsGenerationContext getContext() {
        return this.context;
    }

    private final JsNameRef getBaseClassRef() {
        Lazy lazy = this.baseClassRef$delegate;
        return (JsNameRef)lazy.getValue();
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @NotNull
    public final JsStatement generate() {
        block42: {
            v0 = var1_1 = this.irClass.isExpect() == false;
            if (_Assertions.ENABLED && !var1_1) {
                var2_3 = "Assertion failed";
                throw new AssertionError((Object)var2_3);
            }
            if (!this.es6mode) {
                this.maybeGeneratePrimaryConstructor();
            }
            transformer = new IrDeclarationToJsTransformer();
            properties = new LinkedHashSet<E>();
            jsClass = new JsClass(this.className, this.getBaseClassRef(), null, null, 12, null);
            if (this.baseClass != null && !IrTypePredicatesKt.isAny(this.baseClass)) {
                jsClass.setBaseClass(this.getBaseClassRef());
            }
            if (this.es6mode) {
                v1 = this.classModel.getPreDeclarationBlock().getStatements();
                Intrinsics.checkNotNullExpressionValue(v1, "classModel.preDeclarationBlock.statements");
                var5_6 = v1;
                var5_6.add(jsClass.makeStmt());
            }
            for (Object declaration : this.irClass.getDeclarations()) {
                var6_8 = declaration;
                if (var6_8 instanceof IrConstructor) {
                    if (this.es6mode) {
                        block39: {
                            it = (JsFunction)declaration.accept(new IrFunctionToJsTransformer(), this.context);
                            $i$a$-let-JsClassGenerator$generate$1 = false;
                            v2 = this.baseClass;
                            var10_18 = v2 != null && (v2 = IrTypesKt.getClassifierOrNull((IrType)v2)) != null ? v2.getOwner() : null;
                            v3 = var10_18 instanceof IrClass != false ? (IrClass)var10_18 : null;
                            if ((v3 != null ? v3.getSymbol() : null) == this.context.getStaticContext().getBackendContext().getThrowableClass()) {
                                it.getBody().getStatements().add(0, new JsInvocation((JsExpression)new JsNameRef("super"), new JsExpression[0]).makeStmt());
                            }
                            v4 = it.getBody().getStatements();
                            Intrinsics.checkNotNullExpressionValue(v4, "it.body.statements");
                            $this$any$iv = v4;
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                v5 = false;
                            } else {
                                for (Collection<Object> element$iv : $this$any$iv) {
                                    it /* !! */  = (JsStatement)element$iv;
                                    $i$a$-any-JsClassGenerator$generate$1$1 = false;
                                    if (!(it /* !! */  instanceof JsEmpty == false)) continue;
                                    v5 = true;
                                    break block39;
                                }
                                v5 = false;
                            }
                        }
                        if (!v5) continue;
                        jsClass.setConstructor((JsFunction)it);
                        continue;
                    }
                    v6 = this.classBlock.getStatements();
                    Intrinsics.checkNotNullExpressionValue(v6, "classBlock.statements");
                    it = v6;
                    it.add(declaration.accept(transformer, this.context));
                    v7 = this.classModel.getPreDeclarationBlock().getStatements();
                    Intrinsics.checkNotNullExpressionValue(v7, "classModel.preDeclarationBlock.statements");
                    it = v7;
                    kotlin.collections.CollectionsKt.addAll(it, (Iterable)this.generateInheritanceCode());
                    continue;
                }
                if (var6_8 instanceof IrSimpleFunction) {
                    v8 = ((IrSimpleFunction)declaration).getCorrespondingPropertySymbol();
                    CollectionsKt.addIfNotNull(properties, v8 != null ? (IrProperty)v8.getOwner() : null);
                    if (this.es6mode) {
                        var7_9 = this.generateMemberFunction((IrSimpleFunction)declaration);
                        memberRef = var7_9.component1();
                        function = var7_9.component2();
                        if (function != null) {
                            $i$a$-let-JsClassGenerator$generate$2 = false;
                            ((Collection)jsClass.getMembers()).add(it);
                            v9 = Unit.INSTANCE;
                        } else {
                            v9 = null;
                        }
                        this.generateAssignmentIfMangled((IrSimpleFunction)declaration, memberRef);
                        continue;
                    }
                    var7_9 = this.generateMemberFunction((IrSimpleFunction)declaration);
                    memberRef = var7_9.component1();
                    function = var7_9.component2();
                    if (function != null) {
                        $i$a$-let-JsClassGenerator$generate$3 = false;
                        v10 = this.classBlock.getStatements();
                        Intrinsics.checkNotNullExpressionValue(v10, "classBlock.statements");
                        element$iv = v10;
                        $i$a$-any-JsClassGenerator$generate$1$1 = it /* !! */  = it;
                        var16_40 = memberRef;
                        $i$a$-apply-JsClassGenerator$generate$3$1 = false;
                        $this$generate_u24lambda_u2d5_u24lambda_u2d4.setName(null);
                        element$iv.add(JsAstUtilsKt.jsAssignment((JsExpression)var16_40, it /* !! */ ).makeStmt());
                        v11 = Unit.INSTANCE;
                    } else {
                        v11 = null;
                    }
                    this.generateAssignmentIfMangled((IrSimpleFunction)declaration, memberRef);
                    continue;
                }
                if (var6_8 instanceof IrClass || var6_8 instanceof IrField) continue;
                CompilationExceptionKt.compilationException("Unexpected declaration in class", (IrDeclaration)declaration);
                throw null;
            }
            v12 = this.classBlock.getStatements();
            Intrinsics.checkNotNullExpressionValue(v12, "classBlock.statements");
            declaration = v12;
            declaration.add(this.generateClassMetadata());
            if (IrUtilsKt.isInterface(this.irClass)) break block42;
            for (IrProperty property : properties) {
                block41: {
                    block40: {
                        v13 = property.getGetter();
                        if ((v13 != null ? v13.getExtensionReceiverParameter() : null) != null) continue;
                        v14 = property.getSetter();
                        if ((v14 != null ? v14.getExtensionReceiverParameter() : null) != null || !property.getVisibility().isPublicAPI() || property.isFakeOverride() && !ExportModelGeneratorKt.isAllowedFakeOverriddenDeclaration(property, this.context.getStaticContext().getBackendContext())) continue;
                        v15 = property.getGetter();
                        v16 /* !! */  = v15 != null ? v15.getOverriddenSymbols() : null;
                        if (v16 /* !! */  == null) {
                            v16 /* !! */  = kotlin.collections.CollectionsKt.emptyList();
                        }
                        overriddenSymbols = v16 /* !! */ ;
                        backendContext = this.context.getStaticContext().getBackendContext();
                        $this$any$iv = overriddenSymbols;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            v17 = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                it = (IrSimpleFunctionSymbol)element$iv;
                                $i$a$-any-JsClassGenerator$generate$hasOverriddenExportedInterfaceProperties$1 = false;
                                if (!this.isDefinedInsideExportedInterface((IrSimpleFunction)it.getOwner())) continue;
                                v17 = true;
                                break block40;
                            }
                            v17 = false;
                        }
                    }
                    if (!v17) ** GOTO lbl-1000
                    $this$any$iv = overriddenSymbols;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v18 = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            it = (IrSimpleFunctionSymbol)element$iv;
                            $i$a$-any-JsClassGenerator$generate$hasOverriddenExportedInterfaceProperties$2 = false;
                            if (!IrJsUtilsKt.isExportedClass(IrUtilsKt.getParentClassOrNull((IrDeclaration)it.getOwner()), backendContext)) continue;
                            v18 = true;
                            break block41;
                        }
                        v18 = false;
                    }
                }
                if (!v18) {
                    v19 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v19 = false;
                }
                hasOverriddenExportedInterfaceProperties = v19;
                v20 = property.getGetter();
                getterOverridesExternal = v20 != null ? JsClassGeneratorKt.access$overridesExternal(v20) : false;
                v21 = property.getGetter();
                it = v21 != null ? v21.getOverriddenSymbols() : null;
                if (it == null || it.isEmpty() != false) ** GOTO lbl-1000
                v22 = property.getGetter();
                v23 = v22 != null ? ExportModelGeneratorKt.isOverriddenExported(v22, this.context.getStaticContext().getBackendContext()) : false;
                if (v23) {
                    v24 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v24 = false;
                }
                overriddenExportedGetter = v24;
                v25 = property.getSetter();
                noOverriddenExportedSetter = v25 != null ? !ExportModelGeneratorKt.isOverriddenExported(v25, this.context.getStaticContext().getBackendContext()) : false;
                v26 = needsOverride = overriddenExportedGetter != false && noOverriddenExportedSetter != false || ExportModelGeneratorKt.isAllowedFakeOverriddenDeclaration(property, this.context.getStaticContext().getBackendContext()) != false;
                if ((!ExportModelGeneratorKt.isExported(this.irClass, this.context.getStaticContext().getBackendContext()) || !overriddenSymbols.isEmpty() && !needsOverride) && !hasOverriddenExportedInterfaceProperties && !getterOverridesExternal && AnnotationUtilsKt.getJsName(property) == null) continue;
                $i$a$-any-JsClassGenerator$generate$hasOverriddenExportedInterfaceProperties$2 = this;
                it = $this$generate_u24lambda_u2d5_u24lambda_u2d4 = property.getGetter();
                $i$a$-takeIf-JsClassGenerator$generate$getterForwarder$1 = false;
                $this$generate_u24lambda_u2d5_u24lambda_u2d4 = JsClassGeneratorKt.shouldExportAccessor(it, this.context.getStaticContext().getBackendContext()) != false ? $this$generate_u24lambda_u2d5_u24lambda_u2d4 : null;
                $i$f$getOrGenerateIfFinal = false;
                if ($this$getOrGenerateIfFinal$iv == null) {
                    v27 = null;
                } else if ($this$getOrGenerateIfFinal$iv.getModality() == Modality.FINAL) {
                    v27 = super.accessorRef((IrSimpleFunction)$this$getOrGenerateIfFinal$iv);
                } else {
                    $this$generate_u24lambda_u2d9 = $this$getOrGenerateIfFinal$iv;
                    $i$a$-getOrGenerateIfFinal-JsClassGenerator$generate$getterForwarder$2 = false;
                    v27 = JsClassGenerator.generate$propertyAccessorForwarder((IrSimpleFunction)$this$generate_u24lambda_u2d9, this, "getter forwarder", generate.getterForwarder.2.1.INSTANCE);
                }
                getterForwarder = v27;
                $this$getOrGenerateIfFinal$iv = this;
                it = $i$f$getOrGenerateIfFinal = property.getSetter();
                $i$a$-takeIf-JsClassGenerator$generate$setterForwarder$1 = false;
                $i$f$getOrGenerateIfFinal = JsClassGeneratorKt.shouldExportAccessor(it, this.context.getStaticContext().getBackendContext()) != false ? $i$f$getOrGenerateIfFinal : null;
                $i$f$getOrGenerateIfFinal = false;
                if ($this$getOrGenerateIfFinal$iv == null) {
                    v28 = null;
                } else if ($this$getOrGenerateIfFinal$iv.getModality() == Modality.FINAL) {
                    v28 = super.accessorRef((IrSimpleFunction)$this$getOrGenerateIfFinal$iv);
                } else {
                    $this$generate_u24lambda_u2d12 = $this$getOrGenerateIfFinal$iv;
                    $i$a$-getOrGenerateIfFinal-JsClassGenerator$generate$setterForwarder$2 = false;
                    setterArgName = new JsName("value", false);
                    var21_49 = JsClassGenerator.generate$propertyAccessorForwarder((IrSimpleFunction)$this$generate_u24lambda_u2d12, this, "setter forwarder", (Function1<? super JsNameRef, ? extends JsStatement>)new Function1<JsNameRef, JsStatement>(setterArgName){
                        final /* synthetic */ JsName $setterArgName;
                        {
                            this.$setterArgName = $setterArgName;
                            super(1);
                        }

                        @NotNull
                        public final JsStatement invoke(@NotNull JsNameRef it) {
                            Intrinsics.checkNotNullParameter(it, "it");
                            JsExpression[] jsExpressionArray = new JsExpression[]{new JsNameRef(this.$setterArgName)};
                            JsStatement jsStatement = new JsInvocation((JsExpression)it, jsExpressionArray).makeStmt();
                            Intrinsics.checkNotNullExpressionValue(jsStatement, "JsInvocation(it, JsNameR\u2026etterArgName)).makeStmt()");
                            return jsStatement;
                        }
                    });
                    if (var21_49 != null) {
                        $this$generate_u24lambda_u2d12_u24lambda_u2d11 = var22_50 = var21_49;
                        $i$a$-apply-JsClassGenerator$generate$setterForwarder$2$2 = false;
                        $this$generate_u24lambda_u2d12_u24lambda_u2d11.getParameters().add(new JsParameter(setterArgName));
                        v29 = var22_50;
                    } else {
                        v29 = null;
                    }
                    v28 = v29;
                }
                setterForwarder = v28;
                v30 = this.classBlock.getStatements();
                Intrinsics.checkNotNullExpressionValue(v30, "classBlock.statements");
                var16_40 = v30;
                v31 = this.classPrototypeRef;
                v32 = this.context.getNameForProperty(property).getIdent();
                Intrinsics.checkNotNullExpressionValue(v32, "context.getNameForProperty(property).ident");
                var16_40.add(new JsExpressionStatement(JsAstUtilsKt.defineProperty(v31, v32, getterForwarder, setterForwarder)));
            }
        }
        this.context.getStaticContext().getClassModels().put(this.irClass.getSymbol(), this.classModel);
        return this.classBlock;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isDefinedInsideExportedInterface(IrSimpleFunction $this$isDefinedInsideExportedInterface) {
        IrSimpleFunctionSymbol it;
        if (!$this$isDefinedInsideExportedInterface.isFakeOverride()) {
            if (IrJsUtilsKt.isExportedInterface(IrUtilsKt.getParentClassOrNull($this$isDefinedInsideExportedInterface), this.context.getStaticContext().getBackendContext())) return true;
        }
        Iterable $this$any$iv = $this$isDefinedInsideExportedInterface.getOverriddenSymbols();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (IrSimpleFunctionSymbol)element$iv;
            boolean bl = false;
        } while (!this.isDefinedInsideExportedInterface((IrSimpleFunction)it.getOwner()));
        return true;
    }

    private final JsNameRef accessorRef(IrSimpleFunction $this$accessorRef) {
        return Intrinsics.areEqual($this$accessorRef.getVisibility(), DescriptorVisibilities.PRIVATE) ? null : new JsNameRef(this.context.getNameForMemberFunction($this$accessorRef), (JsExpression)this.classPrototypeRef);
    }

    private final void generateAssignmentIfMangled(IrSimpleFunction $this$generateAssignmentIfMangled, JsExpression memberRef) {
        if (ExportModelGeneratorKt.isExported(this.irClass, this.context.getStaticContext().getBackendContext()) && $this$generateAssignmentIfMangled.getVisibility().isPublicAPI() && this.hasMangledName($this$generateAssignmentIfMangled) && $this$generateAssignmentIfMangled.getCorrespondingPropertySymbol() == null) {
            List<JsStatement> list2 = this.classBlock.getStatements();
            Intrinsics.checkNotNullExpressionValue(list2, "classBlock.statements");
            Collection collection = list2;
            collection.add(JsAstUtilsKt.jsAssignment(this.prototypeAccessRef($this$generateAssignmentIfMangled), memberRef).makeStmt());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasMangledName(IrSimpleFunction $this$hasMangledName) {
        if (AnnotationUtilsKt.getJsName($this$hasMangledName) != null) return false;
        String string2 = $this$hasMangledName.getName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "name.asString()");
        if (IdentifierPolicyKt.isValidES5Identifier(string2)) return false;
        return true;
    }

    private final JsExpression prototypeAccessRef(IrSimpleFunction $this$prototypeAccessRef) {
        String string2 = $this$prototypeAccessRef.getName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "name.asString()");
        return JsAstUtilsKt.jsElementAccess(string2, this.classPrototypeRef);
    }

    private final boolean shouldCopyFrom(IrClass $this$shouldCopyFrom) {
        return IrUtilsKt.isInterface($this$shouldCopyFrom) && !IrUtilsKt.isEffectivelyExternal($this$shouldCopyFrom);
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<JsExpression, JsFunction> generateMemberFunction(IrSimpleFunction declaration) {
        JsExpression memberRef;
        block10: {
            Object v3;
            List missedOverrides;
            boolean isFakeOverride;
            block9: {
                void $this$onEach$iv;
                JsName memberName = this.context.getNameForMemberFunction(IrResolveUtilsKt.getRealOverrideTarget(declaration));
                String string2 = memberName.getIdent();
                Intrinsics.checkNotNullExpressionValue(string2, "memberName.ident");
                memberRef = JsAstUtilsKt.jsElementAccess(string2, this.classPrototypeRef);
                if (AdditionalIrUtilsKt.isReal(declaration) && declaration.getBody() != null) {
                    boolean bl;
                    JsFunction translatedFunction = (JsFunction)declaration.accept(new IrFunctionToJsTransformer(), this.context);
                    boolean bl2 = bl = !IrDeclarationsKt.isStaticMethodOfClass(declaration);
                    if (_Assertions.ENABLED && !bl) {
                        String string3 = "Assertion failed";
                        throw new AssertionError((Object)string3);
                    }
                    if (IrUtilsKt.isInterface(this.irClass)) {
                        List<JsStatement> list2 = this.classModel.getPreDeclarationBlock().getStatements();
                        Intrinsics.checkNotNullExpressionValue(list2, "classModel.preDeclarationBlock.statements");
                        Collection collection = list2;
                        collection.add(translatedFunction.makeStmt());
                        return new Pair<JsExpression, Object>(memberRef, null);
                    }
                    return new Pair<JsExpression, JsFunction>(memberRef, translatedFunction);
                }
                if (IrUtilsKt.isInterface(this.irClass)) break block10;
                isFakeOverride = declaration.isFakeOverride();
                missedOverrides = new ArrayList();
                Iterable iterable = IrFakeOverrideUtilsKt.collectRealOverrides$default(declaration, null, null, 3, null);
                boolean $i$f$onEach22 = false;
                Iterator iterator2 = $this$onEach$iv;
                Object $this$onEach_u24lambda_u2d16$iv2 = iterator2;
                boolean bl = false;
                for (Object element$iv : $this$onEach_u24lambda_u2d16$iv2) {
                    IrSimpleFunction it = (IrSimpleFunction)element$iv;
                    boolean bl3 = false;
                    if (!isFakeOverride || it.getModality() != Modality.ABSTRACT) continue;
                    missedOverrides.add(it);
                }
                void $i$f$onEach22 = iterator2;
                for (Object $this$onEach_u24lambda_u2d16$iv2 : $i$f$onEach22) {
                    IrSimpleFunction it = (IrSimpleFunction)$this$onEach_u24lambda_u2d16$iv2;
                    boolean bl4 = false;
                    if (!(it.getModality() != Modality.ABSTRACT)) continue;
                    v3 = $this$onEach_u24lambda_u2d16$iv2;
                    break block9;
                }
                v3 = null;
            }
            IrSimpleFunction irSimpleFunction = v3;
            if (irSimpleFunction != null) {
                IrSimpleFunction it = irSimpleFunction;
                boolean bl = false;
                IrDeclarationParent irDeclarationParent = it.getParent();
                Intrinsics.checkNotNull(irDeclarationParent, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
                IrClass implClassDeclaration = (IrClass)irDeclarationParent;
                if (this.shouldCopyFrom(implClassDeclaration)) {
                    JsNameRef jsNameRef = this.context.getNameForStaticDeclaration(it).makeRef();
                    Intrinsics.checkNotNullExpressionValue(jsNameRef, "context.getNameForStaticDeclaration(it).makeRef()");
                    JsNameRef reference = jsNameRef;
                    List<JsStatement> list3 = this.classModel.getPostDeclarationBlock().getStatements();
                    Intrinsics.checkNotNullExpressionValue(list3, "classModel.postDeclarationBlock.statements");
                    Collection collection = list3;
                    collection.add(JsAstUtilsKt.jsAssignment(memberRef, reference).makeStmt());
                    if (isFakeOverride) {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Object element$iv;
                        List<JsStatement> list4 = this.classModel.getPostDeclarationBlock().getStatements();
                        Intrinsics.checkNotNullExpressionValue(list4, "classModel.postDeclarationBlock.statements");
                        collection = list4;
                        element$iv = missedOverrides;
                        boolean $i$f$map = false;
                        void bl3 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void missedOverride;
                            IrSimpleFunction irSimpleFunction2 = (IrSimpleFunction)item$iv$iv;
                            Collection collection2 = destination$iv$iv;
                            boolean bl5 = false;
                            JsName name2 = this.context.getNameForMemberFunction((IrSimpleFunction)missedOverride);
                            String string4 = name2.getIdent();
                            Intrinsics.checkNotNullExpressionValue(string4, "name.ident");
                            JsExpression ref = JsAstUtilsKt.jsElementAccess(string4, this.classPrototypeRef);
                            collection2.add(JsAstUtilsKt.jsAssignment(ref, reference).makeStmt());
                        }
                        Iterable iterable = (List)destination$iv$iv;
                        kotlin.collections.CollectionsKt.addAll(collection, iterable);
                    }
                }
            }
        }
        return new Pair<JsExpression, Object>(memberRef, null);
    }

    private final void maybeGeneratePrimaryConstructor() {
        boolean bl;
        block4: {
            Iterable $this$any$iv = this.irClass.getDeclarations();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrDeclaration it = (IrDeclaration)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof IrConstructor)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (!bl) {
            JsFunction func = new JsFunction(JsGenerationContextKt.getEmptyScope(), new JsBlock(), "Ctor for " + this.irClass.getName());
            func.setName(this.className);
            List<JsStatement> list2 = this.classBlock.getStatements();
            Intrinsics.checkNotNullExpressionValue(list2, "classBlock.statements");
            Object object = list2;
            object.add(func.makeStmt());
            List<JsStatement> list3 = this.classModel.getPreDeclarationBlock().getStatements();
            Intrinsics.checkNotNullExpressionValue(list3, "classModel.preDeclarationBlock.statements");
            object = list3;
            kotlin.collections.CollectionsKt.addAll(object, (Iterable)this.generateInheritanceCode());
        }
    }

    private final List<JsStatement> generateInheritanceCode() {
        JsNameRef jsNameRef = this.getBaseClassRef();
        if (jsNameRef == null) {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        JsNameRef baseClassPrototype = jsNameRef;
        JsNode[] jsNodeArray = new JsExpression[]{JsAstUtilsKt.prototypeOf(baseClassPrototype)};
        JsStatement jsStatement = JsAstUtilsKt.jsAssignment(this.classPrototypeRef, new JsInvocation((JsExpression)Namer.INSTANCE.getJS_OBJECT_CREATE_FUNCTION(), (JsExpression[])jsNodeArray)).makeStmt();
        Intrinsics.checkNotNullExpressionValue(jsStatement, "jsAssignment(\n          \u2026pe))\n        ).makeStmt()");
        JsStatement createCall = jsStatement;
        JsStatement jsStatement2 = JsAstUtilsKt.jsAssignment(new JsNameRef(Namer.INSTANCE.getCONSTRUCTOR_NAME(), (JsExpression)this.classPrototypeRef), this.classNameRef).makeStmt();
        Intrinsics.checkNotNullExpressionValue(jsStatement2, "jsAssignment(JsNameRef(N\u2026 classNameRef).makeStmt()");
        JsStatement ctorAssign = jsStatement2;
        jsNodeArray = new JsStatement[]{createCall, ctorAssign};
        return kotlin.collections.CollectionsKt.listOf(jsNodeArray);
    }

    /*
     * WARNING - void declaration
     */
    private final JsStatement generateClassMetadata() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List list2;
        ListIterator iterator$iv;
        Iterable $this$dropLastWhile$iv;
        JsStringLiteral jsStringLiteral;
        Object $this$generateClassMetadata_u24lambda_u2d19 = this.context.getStaticContext().getBackendContext().getIntrinsics();
        boolean $i$a$-with-JsClassGenerator$generateClassMetadata$metadataConstructor$22 = false;
        IrSimpleFunctionSymbol metadataConstructor = IrUtilsKt.isInterface(this.irClass) ? ((JsIntrinsics)$this$generateClassMetadata_u24lambda_u2d19).getMetadataInterfaceConstructorSymbol() : (IrUtilsKt.isObject(this.irClass) ? ((JsIntrinsics)$this$generateClassMetadata_u24lambda_u2d19).getMetadataObjectConstructorSymbol() : ((JsIntrinsics)$this$generateClassMetadata_u24lambda_u2d19).getMetadataClassConstructorSymbol());
        Name $i$a$-with-JsClassGenerator$generateClassMetadata$metadataConstructor$22 = this.irClass.getName();
        Object it = $i$a$-with-JsClassGenerator$generateClassMetadata$metadataConstructor$22;
        boolean bl = false;
        Object object = $this$generateClassMetadata_u24lambda_u2d19 = !((Name)it).isSpecial() ? $i$a$-with-JsClassGenerator$generateClassMetadata$metadataConstructor$22 : null;
        if ($this$generateClassMetadata_u24lambda_u2d19 != null) {
            it = $this$generateClassMetadata_u24lambda_u2d19;
            boolean bl2 = false;
            jsStringLiteral = new JsStringLiteral(((Name)it).getIdentifier());
        } else {
            jsStringLiteral = null;
        }
        JsStringLiteral simpleName2 = jsStringLiteral;
        JsArrayLiteral interfaces = this.generateSuperClasses();
        JsIntLiteral associatedObjectKey = this.generateAssociatedObjectKey();
        JsObjectLiteral associatedObjects = this.generateAssociatedObjects();
        JsNameRef fastPrototype = this.generateFastPrototype();
        JsArrayLiteral suspendArity = this.generateSuspendArity();
        Object object2 = new JsExpression[]{simpleName2, interfaces, associatedObjectKey, associatedObjects, suspendArity, fastPrototype};
        object2 = kotlin.collections.CollectionsKt.listOf(object2);
        JsExpression jsExpression = new JsNameRef(this.context.getNameForStaticFunction((IrSimpleFunction)metadataConstructor.getOwner()));
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                JsExpression it2 = (JsExpression)iterator$iv.previous();
                boolean bl3 = false;
                if (it2 == null) continue;
                list2 = kotlin.collections.CollectionsKt.take($this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                break;
            }
        } else {
            list2 = kotlin.collections.CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list2;
        boolean $i$f$map = false;
        iterator$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            JsExpression jsExpression2 = (JsExpression)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl4 = false;
            JsExpression jsExpression3 = it3;
            if (jsExpression3 == null) {
                jsExpression3 = Namer.INSTANCE.getJS_UNDEFINED();
            }
            collection.add(jsExpression3);
        }
        List list3 = (List)destination$iv$iv;
        JsExpression jsExpression4 = jsExpression;
        JsInvocation constructorCall = new JsInvocation(jsExpression4, list3);
        JsStatement jsStatement = JsAstUtilsKt.jsAssignment(new JsNameRef(Namer.INSTANCE.getMETADATA(), (JsExpression)this.classNameRef), constructorCall).makeStmt();
        Intrinsics.checkNotNullExpressionValue(jsStatement, "jsAssignment(JsNameRef(N\u2026nstructorCall).makeStmt()");
        return jsStatement;
    }

    private final boolean isCoroutineClass() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.irClass.getSuperTypes();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrType it = (IrType)element$iv;
                    boolean bl2 = false;
                    if (!org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.isSuspendFunctionTypeOrSubtype(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final JsArrayLiteral generateSuspendArity() {
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        if (!this.isCoroutineClass()) {
            return null;
        }
        Collection<IrSimpleFunction> collection2 = this.context.getStaticContext().getBackendContext().getMapping().getSuspendArityStore().get((IrClass)((IrDeclaration)this.irClass));
        Intrinsics.checkNotNull(collection2);
        Iterable $this$map$iv = collection2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrSimpleFunction irSimpleFunction = (IrSimpleFunction)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getValueParameters().size());
        }
        $this$map$iv = kotlin.collections.CollectionsKt.distinct((List)destination$iv$iv);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            int it = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new JsIntLiteral(it));
        }
        List arity = (List)destination$iv$iv;
        return new JsArrayLiteral(arity);
    }

    /*
     * WARNING - void declaration
     */
    private final JsArrayLiteral generateSuperClasses() {
        JsArrayLiteral jsArrayLiteral;
        List list2;
        List parentSymbols;
        List list3;
        IrClassSymbol symbol2;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.irClass.getSuperTypes();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            IrClassSymbol it$iv$iv;
            boolean requireInMetadata;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrType it = (IrType)element$iv$iv;
            boolean bl2 = false;
            IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrFail(it);
            Intrinsics.checkNotNull(irClassifierSymbol, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrClassSymbol");
            symbol2 = (IrClassSymbol)irClassifierSymbol;
            boolean isFunctionType = this.isFunctionType(it);
            boolean bl3 = this.context.getStaticContext().getBackendContext().getBaseClassIntoMetadata() ? !IrTypePredicatesKt.isAny(it) : (requireInMetadata = JsClassGeneratorKt.access$isInterface(symbol2));
            if ((requireInMetadata && !isFunctionType && !JsClassGeneratorKt.access$isEffectivelyExternal(symbol2) ? symbol2 : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List it = list3 = (parentSymbols = (List)destination$iv$iv);
        boolean bl = false;
        List list4 = list2 = !((Collection)it).isEmpty() ? list3 : null;
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            List $this$generateSuperClasses_u24lambda_u2d30 = list2;
            boolean bl5 = false;
            Iterable $this$map$iv = $this$generateSuperClasses_u24lambda_u2d30;
            boolean $i$f$map = false;
            element$iv$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                symbol2 = (IrClassSymbol)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl6 = false;
                collection.add(new JsNameRef(this.context.getNameForClass((IrClass)it2.getOwner())));
            }
            List list5 = (List)destination$iv$iv2;
            jsArrayLiteral = new JsArrayLiteral(list5);
        } else {
            jsArrayLiteral = null;
        }
        return jsArrayLiteral;
    }

    private final JsNameRef generateFastPrototype() {
        JsNameRef jsNameRef;
        JsNameRef jsNameRef2 = this.getBaseClassRef();
        if (jsNameRef2 != null) {
            JsNameRef it = jsNameRef2;
            boolean bl = false;
            jsNameRef = JsAstUtilsKt.prototypeOf(it);
        } else {
            jsNameRef = null;
        }
        return jsNameRef;
    }

    private final boolean isFunctionType(IrType $this$isFunctionType) {
        return org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.isFunctionOrKFunction($this$isFunctionType) || org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.isSuspendFunctionOrKFunction($this$isFunctionType);
    }

    private final JsIntLiteral generateAssociatedObjectKey() {
        JsIntLiteral jsIntLiteral;
        Integer n = this.context.getAssociatedObjectKey(this.irClass);
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            jsIntLiteral = new JsIntLiteral(it);
        } else {
            jsIntLiteral = null;
        }
        return jsIntLiteral;
    }

    /*
     * WARNING - void declaration
     */
    private final JsObjectLiteral generateAssociatedObjects() {
        JsObjectLiteral jsObjectLiteral;
        List list2;
        List associatedObjects;
        List list3;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.irClass.getAnnotations();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            JsPropertyInitializer jsPropertyInitializer;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrConstructorCall annotation2 = (IrConstructorCall)element$iv$iv;
            boolean bl2 = false;
            IrClass annotationClass = AdditionalIrUtilsKt.getConstructedClass((IrConstructor)annotation2.getSymbol().getOwner());
            Integer n = this.context.getAssociatedObjectKey(annotationClass);
            if (n != null) {
                int key = ((Number)n).intValue();
                boolean bl3 = false;
                if (AnnotationUtilsKt.associatedObject(annotation2) != null) {
                    IrClass obj;
                    boolean bl4 = false;
                    if (this.context.getStaticContext().getBackendContext().getMapping().getObjectToGetInstanceFunction().get((IrClass)((IrDeclaration)obj)) != null) {
                        IrSimpleFunction factory2;
                        boolean bl5 = false;
                        jsPropertyInitializer = new JsPropertyInitializer(new JsIntLiteral(key), this.context.getStaticContext().getNameForStaticFunction(factory2).makeRef());
                    } else {
                        jsPropertyInitializer = null;
                    }
                } else {
                    jsPropertyInitializer = null;
                }
            } else {
                jsPropertyInitializer = null;
            }
            if (jsPropertyInitializer == null) continue;
            JsPropertyInitializer it$iv$iv = jsPropertyInitializer;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List it = list3 = (associatedObjects = (List)destination$iv$iv);
        boolean bl = false;
        List list4 = list2 = !((Collection)it).isEmpty() ? list3 : null;
        if (list2 != null) {
            it = list2;
            boolean bl7 = false;
            jsObjectLiteral = new JsObjectLiteral(it);
        } else {
            jsObjectLiteral = null;
        }
        return jsObjectLiteral;
    }

    private static final JsFunction generate$propertyAccessorForwarder(IrSimpleFunction $this$generate_u24propertyAccessorForwarder, JsClassGenerator this$0, String description2, Function1<? super JsNameRef, ? extends JsStatement> callActualAccessor) {
        return Intrinsics.areEqual($this$generate_u24propertyAccessorForwarder.getVisibility(), DescriptorVisibilities.PRIVATE) ? null : new JsFunction(JsGenerationContextKt.getEmptyScope(), new JsBlock(callActualAccessor.invoke(new JsNameRef(this$0.context.getNameForMemberFunction($this$generate_u24propertyAccessorForwarder), (JsExpression)new JsThisRef()))), description2);
    }

    public static final /* synthetic */ IrType access$getBaseClass$p(JsClassGenerator $this) {
        return $this.baseClass;
    }
}

