/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrElementBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrDeclarationBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionExpressionImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrLocalDelegatedPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0002\u0010\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/PropertyReferenceLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "jsClassSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "localDelegateBuilderSymbol", "referenceBuilderSymbol", "throwISE", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "Companion", "PropertyReferenceTransformer", "backend.js"})
public final class PropertyReferenceLowering
implements BodyLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsIrBackendContext context;
    @NotNull
    private final IrSimpleFunctionSymbol referenceBuilderSymbol;
    @NotNull
    private final IrSimpleFunctionSymbol localDelegateBuilderSymbol;
    @NotNull
    private final IrSimpleFunctionSymbol jsClassSymbol;
    @NotNull
    private final IrSimpleFunctionSymbol throwISE;

    public PropertyReferenceLowering(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.context = context;
        this.referenceBuilderSymbol = this.context.getKpropertyBuilder();
        this.localDelegateBuilderSymbol = this.context.getKlocalDelegateBuilder();
        this.jsClassSymbol = this.context.getIntrinsics().getJsClass();
        this.throwISE = this.context.getThrowISEsymbol();
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        IrDeclarationParent currentParent;
        List<IrDeclaration> newDeclarations;
        Intrinsics.checkNotNullParameter(irBody, "irBody");
        Intrinsics.checkNotNullParameter(container, "container");
        IrDeclarationParent irDeclarationParent = container instanceof IrDeclarationParent ? (IrDeclarationParent)((Object)container) : null;
        if (irDeclarationParent == null) {
            irDeclarationParent = container.getParent();
        }
        if (!(newDeclarations = new PropertyReferenceTransformer(currentParent = irDeclarationParent).process(irBody)).isEmpty()) {
            IrFile file2 = IrUtilsKt.getFile(container);
            Iterable $this$forEach$iv = newDeclarations;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrDeclaration it = (IrDeclaration)element$iv;
                boolean bl = false;
                it.setParent(file2);
            }
            file2.getDeclarations().addAll((Collection<IrDeclaration>)newDeclarations);
        }
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        BodyLoweringPass.DefaultImpls.lower(this, irFile);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J&\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J&\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00162\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010!\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\"\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u0014H\u0016J\f\u0010#\u001a\u00020\u000f*\u00020\u000fH\u0002J\f\u0010$\u001a\u00020\u000f*\u00020\u0014H\u0002R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/PropertyReferenceLowering$PropertyReferenceTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "currentParent", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/PropertyReferenceLowering;Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;)V", "getCurrentParent", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "setCurrentParent", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;)V", "newDeclarations", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "getNewDeclarations", "()Ljava/util/List;", "buildAccessorLambda", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "factory", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "accessor", "reference", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "boundValueParameters", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "buildFactoryFunction", "buildGetterLambda", "buildLocalDelegateLambda", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrLocalDelegatedPropertyReference;", "buildSetterLambda", "process", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "visitLocalDelegatedPropertyReference", "visitPropertyReference", "getJsTypeConstructor", "nameExpression", "backend.js"})
    private final class PropertyReferenceTransformer
    extends IrElementTransformerVoid {
        @NotNull
        private IrDeclarationParent currentParent;
        @NotNull
        private final List<IrDeclaration> newDeclarations;

        public PropertyReferenceTransformer(IrDeclarationParent currentParent) {
            Intrinsics.checkNotNullParameter(currentParent, "currentParent");
            this.currentParent = currentParent;
            this.newDeclarations = new ArrayList();
        }

        @NotNull
        public final IrDeclarationParent getCurrentParent() {
            return this.currentParent;
        }

        public final void setCurrentParent(@NotNull IrDeclarationParent irDeclarationParent) {
            Intrinsics.checkNotNullParameter(irDeclarationParent, "<set-?>");
            this.currentParent = irDeclarationParent;
        }

        @NotNull
        public final List<IrDeclaration> getNewDeclarations() {
            return this.newDeclarations;
        }

        @NotNull
        public final List<IrDeclaration> process(@NotNull IrBody irBody) {
            Intrinsics.checkNotNullParameter(irBody, "irBody");
            IrElementTransformerVoidKt.transformChildrenVoid(irBody, this);
            return this.newDeclarations;
        }

        /*
         * WARNING - void declaration
         */
        private final IrSimpleFunction buildFactoryFunction(IrPropertyReference reference) {
            void $this$buildFactoryFunction_u24lambda_u2d4_u24lambda_u2d3;
            void $this$buildFactoryFunction_u24lambda_u2d4;
            IrCall irCall;
            void this_$iv$iv;
            void $this$irBlockBody_u24default$iv;
            void arg;
            Object object;
            Object item$iv$iv;
            IrBuilderWithScope $this$mapIndexedTo$iv$iv;
            IrProperty property2 = (IrProperty)((IrPropertySymbol)reference.getSymbol()).getOwner();
            IrFactory $this$buildFun$iv = PropertyReferenceLowering.this.context.getIrFactory();
            boolean $i$f$buildFun22 = false;
            IrFunctionBuilder $this$buildFun_u24lambda_u2d16$iv = new IrFunctionBuilder();
            boolean bl = false;
            Object $this$buildFactoryFunction_u24lambda_u2d0 = $this$buildFun_u24lambda_u2d16$iv;
            boolean bl2 = false;
            ((IrElementBuilder)$this$buildFactoryFunction_u24lambda_u2d0).setStartOffset(reference.getStartOffset());
            ((IrElementBuilder)$this$buildFactoryFunction_u24lambda_u2d0).setEndOffset(reference.getEndOffset());
            ((IrFunctionBuilder)$this$buildFactoryFunction_u24lambda_u2d0).setReturnType(reference.getType());
            Name name2 = Name.identifier(property2.getName().asString() + "$factory");
            Intrinsics.checkNotNullExpressionValue(name2, "identifier(\"${property.name.asString()}\\$factory\")");
            ((IrDeclarationBuilder)$this$buildFactoryFunction_u24lambda_u2d0).setName(name2);
            ((IrDeclarationBuilder)$this$buildFactoryFunction_u24lambda_u2d0).setOrigin(Companion.PROPERTY_REFERENCE_FACTORY.INSTANCE);
            IrSimpleFunction factoryDeclaration2 = DeclarationBuildersKt.buildFunction($this$buildFun$iv, $this$buildFun_u24lambda_u2d16$iv);
            IrExpression[] $i$f$buildFun22 = new IrExpression[]{reference.getDispatchReceiver(), reference.getExtensionReceiver()};
            List<IrExpression> boundArguments = CollectionsKt.listOfNotNull($i$f$buildFun22);
            Iterable $this$mapIndexed$iv = boundArguments;
            boolean $i$f$mapIndexed = false;
            $this$buildFactoryFunction_u24lambda_u2d0 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            Iterator iterator2 = $this$mapIndexedTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void i;
                int n;
                item$iv$iv = iterator2.next();
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IrExpression irExpression = (IrExpression)item$iv$iv;
                int n2 = n;
                object = destination$iv$iv;
                boolean bl3 = false;
                boolean $i$f$buildValueParameter = false;
                IrValueParameterBuilder $this$buildValueParameter_u24lambda_u2d26$iv = new IrValueParameterBuilder();
                boolean bl4 = false;
                IrValueParameterBuilder $this$buildFactoryFunction_u24lambda_u2d2_u24lambda_u2d1 = $this$buildValueParameter_u24lambda_u2d26$iv;
                boolean bl5 = false;
                $this$buildFactoryFunction_u24lambda_u2d2_u24lambda_u2d1.setType(arg.getType());
                $this$buildFactoryFunction_u24lambda_u2d2_u24lambda_u2d1.setIndex((int)i);
                Name name3 = Name.identifier("$b" + (int)i);
                Intrinsics.checkNotNullExpressionValue(name3, "identifier(\"\\$b$i\")");
                $this$buildFactoryFunction_u24lambda_u2d2_u24lambda_u2d1.setName(name3);
                object.add(DeclarationBuildersKt.buildValueParameter(((IrDeclaration)factoryDeclaration2).getFactory(), $this$buildValueParameter_u24lambda_u2d26$iv, (IrDeclarationParent)((Object)((IrDeclaration)factoryDeclaration2))));
            }
            List valueParameters2 = (List)destination$iv$iv;
            factoryDeclaration2.setValueParameters(valueParameters2);
            IrType irType = reference.getType();
            Intrinsics.checkNotNull(irType, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
            int arity = ((IrSimpleType)irType).getArguments().size() - 1;
            DeclarationIrBuilder irBuilder = LowerUtilsKt.createIrBuilder$default(PropertyReferenceLowering.this.context, (IrSymbol)factoryDeclaration2.getSymbol(), 0, 0, 6, null);
            $this$mapIndexedTo$iv$iv = irBuilder;
            PropertyReferenceLowering propertyReferenceLowering2 = PropertyReferenceLowering.this;
            int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
            boolean $i$f$irBlockBody = false;
            item$iv$iv = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
            boolean $i$f$blockBody = false;
            arg = this_$iv$iv;
            object = factoryDeclaration2;
            boolean bl6 = false;
            IrCall $i$f$buildValueParameter = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$buildFactoryFunction_u24lambda_u2d4, propertyReferenceLowering2.referenceBuilderSymbol);
            IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$buildFactoryFunction_u24lambda_u2d4;
            void var20_30 = $this$buildFactoryFunction_u24lambda_u2d4;
            boolean bl7 = false;
            $this$buildFactoryFunction_u24lambda_u2d4_u24lambda_u2d3.putValueArgument(0, this.nameExpression(reference));
            $this$buildFactoryFunction_u24lambda_u2d4_u24lambda_u2d3.putValueArgument(1, ExpressionHelpersKt.irInt$default((IrBuilderWithScope)$this$buildFactoryFunction_u24lambda_u2d4, arity, null, 2, null));
            $this$buildFactoryFunction_u24lambda_u2d4_u24lambda_u2d3.putValueArgument(2, this.getJsTypeConstructor(reference));
            $this$buildFactoryFunction_u24lambda_u2d4_u24lambda_u2d3.putValueArgument(3, this.buildGetterLambda(factoryDeclaration2, reference, valueParameters2));
            $this$buildFactoryFunction_u24lambda_u2d4_u24lambda_u2d3.putValueArgument(4, this.buildSetterLambda(factoryDeclaration2, reference, valueParameters2));
            Unit unit2 = Unit.INSTANCE;
            var20_30.unaryPlus(ExpressionHelpersKt.irReturn(irBuilderWithScope, irCall));
            ((IrFunction)object).setBody(this_$iv$iv.doBuild());
            this.newDeclarations.add(factoryDeclaration2);
            return factoryDeclaration2;
        }

        private final IrExpression buildGetterLambda(IrSimpleFunction factory2, IrPropertyReference reference, List<? extends IrValueParameter> boundValueParameters) {
            Object object = reference.getGetter();
            if (object == null || (object = (IrSimpleFunction)object.getOwner()) == null) {
                CompilationExceptionKt.compilationException("Getter expected", reference);
                throw null;
            }
            Object getter2 = object;
            return this.buildAccessorLambda(factory2, (IrSimpleFunction)getter2, reference, boundValueParameters);
        }

        private final IrExpression buildSetterLambda(IrSimpleFunction factory2, IrPropertyReference reference, List<? extends IrValueParameter> boundValueParameters) {
            IrPropertyReference irPropertyReference = reference;
            PropertyReferenceLowering propertyReferenceLowering2 = PropertyReferenceLowering.this;
            IrPropertyReference $this$buildSetterLambda_u24lambda_u2d5 = irPropertyReference;
            boolean bl = false;
            Object object = $this$buildSetterLambda_u24lambda_u2d5.getSetter();
            if (object == null || (object = (IrSimpleFunction)object.getOwner()) == null) {
                return IrConstImpl.Companion.constNull($this$buildSetterLambda_u24lambda_u2d5.getStartOffset(), $this$buildSetterLambda_u24lambda_u2d5.getEndOffset(), propertyReferenceLowering2.context.getIrBuiltIns().getNothingNType());
            }
            Object setter2 = object;
            return this.buildAccessorLambda(factory2, (IrSimpleFunction)setter2, reference, boundValueParameters);
        }

        /*
         * WARNING - void declaration
         */
        private final IrExpression buildAccessorLambda(IrSimpleFunction factory2, IrSimpleFunction accessor, IrPropertyReference reference, List<? extends IrValueParameter> boundValueParameters) {
            int n;
            void $this$buildAccessorLambda_u24lambda_u2d9;
            void this_$iv$iv;
            Object object;
            void $this$mapTo$iv$iv;
            void $this$single$iv;
            void $this$filterIsInstanceTo$iv$iv;
            String string2;
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = accessor.getSymbol();
            if (Intrinsics.areEqual(irSimpleFunctionSymbol, reference.getGetter())) {
                string2 = "get";
            } else if (Intrinsics.areEqual(irSimpleFunctionSymbol, reference.getSetter())) {
                string2 = "set";
            } else {
                CompilationExceptionKt.compilationException("Unexpected accessor", accessor);
                throw null;
            }
            String superName = string2;
            IrType irType = reference.getType();
            Intrinsics.checkNotNull(irType, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull((IrSimpleType)irType);
            if (irClassSymbol == null) {
                CompilationExceptionKt.compilationException("Simple type expected", reference);
                throw null;
            }
            IrClassSymbol classifier2 = irClassSymbol;
            Iterable $this$filterIsInstance$iv = ((IrClass)classifier2.getOwner()).getDeclarations();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrSimpleFunction)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                IrSimpleFunction it = (IrSimpleFunction)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getName().asString(), superName)) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            IrSimpleFunction supperAccessor = single$iv;
            IrFactory $this$buildFun$iv = PropertyReferenceLowering.this.context.getIrFactory();
            boolean $i$f$buildFun = false;
            IrFunctionBuilder $this$buildFun_u24lambda_u2d16$iv = new IrFunctionBuilder();
            boolean $i$a$-run-DeclarationBuildersKt$buildFun$1$iv22 = false;
            IrFunctionBuilder $this$buildAccessorLambda_u24lambda_u2d7 = $this$buildFun_u24lambda_u2d16$iv;
            boolean bl = false;
            $this$buildAccessorLambda_u24lambda_u2d7.setStartOffset(reference.getStartOffset());
            $this$buildAccessorLambda_u24lambda_u2d7.setEndOffset(reference.getEndOffset());
            $this$buildAccessorLambda_u24lambda_u2d7.setReturnType(supperAccessor.getReturnType());
            $this$buildAccessorLambda_u24lambda_u2d7.setName(supperAccessor.getName());
            IrSimpleFunction function2 = DeclarationBuildersKt.buildFunction($this$buildFun$iv, $this$buildFun_u24lambda_u2d16$iv);
            function2.setParent(factory2);
            Iterable $this$map$iv = supperAccessor.getValueParameters();
            boolean $i$f$map = false;
            Iterable $i$a$-run-DeclarationBuildersKt$buildFun$1$iv22 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl2 = false;
                object.add(org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default((IrValueParameter)it, function2, null, 0, 0, 0, null, null, null, null, null, false, false, false, 8190, null));
            }
            List unboundValueParameters = (List)destination$iv$iv2;
            function2.setValueParameters(unboundValueParameters);
            int arity = unboundValueParameters.size();
            int total = arity + boundValueParameters.size();
            int b = 0;
            int u = 0;
            DeclarationIrBuilder irBuilder = LowerUtilsKt.createIrBuilder$default(PropertyReferenceLowering.this.context, (IrSymbol)function2.getSymbol(), 0, 0, 6, null);
            IrBuilderWithScope $this$irBlockBody_u24default$iv = irBuilder;
            int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
            boolean $i$f$irBlockBody = false;
            IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
            boolean $i$f$blockBody = false;
            void var21_39 = this_$iv$iv;
            object = function2;
            boolean bl3 = false;
            IrCall irAccessorCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$buildAccessorLambda_u24lambda_u2d9, accessor.getSymbol());
            if (accessor.getDispatchReceiverParameter() != null) {
                IrExpression irExpression;
                if (reference.getDispatchReceiver() != null) {
                    n = b;
                    b = n + 1;
                    irExpression = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildAccessorLambda_u24lambda_u2d9, boundValueParameters.get(n));
                } else {
                    n = u;
                    u = n + 1;
                    irExpression = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildAccessorLambda_u24lambda_u2d9, (IrValueDeclaration)unboundValueParameters.get(n));
                }
                irAccessorCall.setDispatchReceiver(irExpression);
            }
            if (accessor.getExtensionReceiverParameter() != null) {
                IrExpression irExpression;
                if (reference.getExtensionReceiver() != null) {
                    n = b;
                    b = n + 1;
                    irExpression = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildAccessorLambda_u24lambda_u2d9, boundValueParameters.get(n));
                } else {
                    n = u;
                    u = n + 1;
                    irExpression = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildAccessorLambda_u24lambda_u2d9, (IrValueDeclaration)unboundValueParameters.get(n));
                }
                irAccessorCall.setExtensionReceiver(irExpression);
            }
            if (u < unboundValueParameters.size()) {
                n = u;
                u = n + 1;
                irAccessorCall.putValueArgument(0, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildAccessorLambda_u24lambda_u2d9, (IrValueDeclaration)unboundValueParameters.get(n)));
            }
            int n2 = n = u == arity ? 1 : 0;
            if (_Assertions.ENABLED && n == 0) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            int n3 = n = u + b == total ? 1 : 0;
            if (_Assertions.ENABLED && n == 0) {
                String string4 = "Assertion failed";
                throw new AssertionError((Object)string4);
            }
            $this$buildAccessorLambda_u24lambda_u2d9.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$buildAccessorLambda_u24lambda_u2d9, irAccessorCall));
            ((IrFunction)object).setBody(this_$iv$iv.doBuild());
            return new IrFunctionExpressionImpl(reference.getStartOffset(), reference.getEndOffset(), PropertyReferenceLowering.this.context.getIrBuiltIns().getAnyType(), function2, IrStatementOrigin.LAMBDA.INSTANCE);
        }

        private final IrExpression nameExpression(IrPropertyReference $this$nameExpression) {
            String string2 = ((IrProperty)((IrPropertySymbol)$this$nameExpression.getSymbol()).getOwner()).getName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "symbol.owner.name.asString()");
            String propertyName = string2;
            return IrConstImpl.Companion.string($this$nameExpression.getStartOffset(), $this$nameExpression.getEndOffset(), PropertyReferenceLowering.this.context.getIrBuiltIns().getStringType(), propertyName);
        }

        private final IrExpression getJsTypeConstructor(IrExpression $this$getJsTypeConstructor) {
            IrCallImpl irCall = new IrCallImpl($this$getJsTypeConstructor.getStartOffset(), $this$getJsTypeConstructor.getEndOffset(), ((IrSimpleFunction)PropertyReferenceLowering.this.jsClassSymbol.getOwner()).getReturnType(), PropertyReferenceLowering.this.jsClassSymbol, 1, 0, null, null, 192, null);
            irCall.putTypeArgument(0, $this$getJsTypeConstructor.getType());
            return irCall;
        }

        @Override
        @NotNull
        public IrExpression visitPropertyReference(@NotNull IrPropertyReference expression2) {
            IrCallImpl irCallImpl;
            block3: {
                int n;
                IrExpression it;
                boolean bl;
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrSimpleFunction factoryFunction = this.buildFactoryFunction(expression2);
                boolean bl2 = bl = expression2.getValueArgumentsCount() == 0;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                IrCallImpl $this$visitPropertyReference_u24lambda_u2d12 = irCallImpl = new IrCallImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), factoryFunction.getSymbol(), expression2.getTypeArgumentsCount(), factoryFunction.getValueParameters().size(), null, null, 192, null);
                boolean bl3 = false;
                int n2 = $this$visitPropertyReference_u24lambda_u2d12.getTypeArgumentsCount();
                for (int ti = 0; ti < n2; ++ti) {
                    $this$visitPropertyReference_u24lambda_u2d12.putTypeArgument(ti, expression2.getTypeArgument(ti));
                }
                int vi = 0;
                IrExpression irExpression = expression2.getDispatchReceiver();
                if (irExpression != null) {
                    it = irExpression;
                    boolean bl4 = false;
                    n = vi;
                    vi = n + 1;
                    $this$visitPropertyReference_u24lambda_u2d12.putValueArgument(n, it);
                }
                IrExpression irExpression2 = expression2.getExtensionReceiver();
                if (irExpression2 == null) break block3;
                it = irExpression2;
                boolean bl5 = false;
                n = vi;
                vi = n + 1;
                $this$visitPropertyReference_u24lambda_u2d12.putValueArgument(n, it);
            }
            return irCallImpl;
        }

        @Override
        @NotNull
        public IrExpression visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
            IrLocalDelegatedPropertyReference irLocalDelegatedPropertyReference = expression2;
            PropertyReferenceLowering propertyReferenceLowering2 = PropertyReferenceLowering.this;
            IrLocalDelegatedPropertyReference $this$visitLocalDelegatedPropertyReference_u24lambda_u2d13 = irLocalDelegatedPropertyReference;
            boolean bl = false;
            IrCallImpl builderCall = new IrCallImpl($this$visitLocalDelegatedPropertyReference_u24lambda_u2d13.getStartOffset(), $this$visitLocalDelegatedPropertyReference_u24lambda_u2d13.getEndOffset(), $this$visitLocalDelegatedPropertyReference_u24lambda_u2d13.getType(), propertyReferenceLowering2.localDelegateBuilderSymbol, $this$visitLocalDelegatedPropertyReference_u24lambda_u2d13.getTypeArgumentsCount(), 4, null, null, 192, null);
            String string2 = ((IrLocalDelegatedProperty)((IrLocalDelegatedPropertySymbol)expression2.getSymbol()).getOwner()).getName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "expression.symbol.owner.name.asString()");
            String localName = string2;
            boolean isMutable = expression2.getSetter() != null;
            IrLocalDelegatedPropertyReference irLocalDelegatedPropertyReference2 = expression2;
            PropertyReferenceLowering propertyReferenceLowering3 = PropertyReferenceLowering.this;
            IrLocalDelegatedPropertyReference $this$visitLocalDelegatedPropertyReference_u24lambda_u2d14 = irLocalDelegatedPropertyReference2;
            boolean bl2 = false;
            builderCall.putValueArgument(0, IrConstImpl.Companion.string($this$visitLocalDelegatedPropertyReference_u24lambda_u2d14.getStartOffset(), $this$visitLocalDelegatedPropertyReference_u24lambda_u2d14.getEndOffset(), propertyReferenceLowering3.context.getIrBuiltIns().getStringType(), localName));
            builderCall.putValueArgument(1, this.getJsTypeConstructor(expression2));
            builderCall.putValueArgument(2, IrConstImpl.Companion.boolean($this$visitLocalDelegatedPropertyReference_u24lambda_u2d14.getStartOffset(), $this$visitLocalDelegatedPropertyReference_u24lambda_u2d14.getEndOffset(), propertyReferenceLowering3.context.getIrBuiltIns().getBooleanType(), isMutable));
            builderCall.putValueArgument(3, this.buildLocalDelegateLambda(expression2));
            return builderCall;
        }

        /*
         * WARNING - void declaration
         */
        private final IrExpression buildLocalDelegateLambda(IrLocalDelegatedPropertyReference expression2) {
            void this_$iv$iv;
            void $this$buildLocalDelegateLambda_u24lambda_u2d17;
            void $this$buildFun$iv;
            IrVariable delegatedVar = (IrVariable)expression2.getDelegate().getOwner();
            Object object = PropertyReferenceLowering.this.context.getIrFactory();
            PropertyReferenceLowering propertyReferenceLowering2 = PropertyReferenceLowering.this;
            boolean $i$f$buildFun22 = false;
            IrFunctionBuilder $this$buildFun_u24lambda_u2d16$iv = new IrFunctionBuilder();
            boolean bl = false;
            IrFunctionBuilder $this$buildLocalDelegateLambda_u24lambda_u2d15 = $this$buildFun_u24lambda_u2d16$iv;
            boolean bl2 = false;
            $this$buildLocalDelegateLambda_u24lambda_u2d15.setStartOffset(expression2.getStartOffset());
            $this$buildLocalDelegateLambda_u24lambda_u2d15.setEndOffset(expression2.getEndOffset());
            $this$buildLocalDelegateLambda_u24lambda_u2d15.setReturnType(propertyReferenceLowering2.context.getIrBuiltIns().getNothingType());
            Name name2 = Name.identifier(delegatedVar.getName() + "$stub");
            Intrinsics.checkNotNullExpressionValue(name2, "identifier(\"${delegatedVar.name}\\$stub\")");
            $this$buildLocalDelegateLambda_u24lambda_u2d15.setName(name2);
            IrSimpleFunction function2 = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv, $this$buildFun_u24lambda_u2d16$iv);
            function2.setParent(this.currentParent);
            object = LowerUtilsKt.createIrBuilder$default(PropertyReferenceLowering.this.context, (IrSymbol)function2.getSymbol(), 0, 0, 6, null);
            propertyReferenceLowering2 = PropertyReferenceLowering.this;
            Object $i$f$buildFun22 = object;
            IrSimpleFunction irSimpleFunction = function2;
            boolean bl3 = false;
            IrBuilderWithScope $this$irBlockBody_u24default$iv = (IrBuilderWithScope)$this$buildLocalDelegateLambda_u24lambda_u2d17;
            int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
            boolean $i$f$irBlockBody = false;
            IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
            boolean $i$f$blockBody = false;
            void $this$buildLocalDelegateLambda_u24lambda_u2d17_u24lambda_u2d16 = this_$iv$iv;
            boolean bl4 = false;
            $this$buildLocalDelegateLambda_u24lambda_u2d17_u24lambda_u2d16.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$buildLocalDelegateLambda_u24lambda_u2d17_u24lambda_u2d16, ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$buildLocalDelegateLambda_u24lambda_u2d17_u24lambda_u2d16, propertyReferenceLowering2.throwISE)));
            irSimpleFunction.setBody(this_$iv$iv.doBuild());
            object = expression2;
            propertyReferenceLowering2 = PropertyReferenceLowering.this;
            Object $this$buildLocalDelegateLambda_u24lambda_u2d18 = object;
            boolean bl5 = false;
            return new IrFunctionExpressionImpl($this$buildLocalDelegateLambda_u24lambda_u2d18.getStartOffset(), $this$buildLocalDelegateLambda_u24lambda_u2d18.getEndOffset(), propertyReferenceLowering2.context.getIrBuiltIns().getAnyType(), function2, IrStatementOrigin.LAMBDA.INSTANCE);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/PropertyReferenceLowering$Companion;", "", "()V", "PROPERTY_REFERENCE_FACTORY", "backend.js"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/PropertyReferenceLowering$Companion$PROPERTY_REFERENCE_FACTORY;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "()V", "backend.js"})
        public static final class PROPERTY_REFERENCE_FACTORY
        extends IrDeclarationOriginImpl {
            @NotNull
            public static final PROPERTY_REFERENCE_FACTORY INSTANCE = new PROPERTY_REFERENCE_FACTORY();

            private PROPERTY_REFERENCE_FACTORY() {
                super("PROPERTY_REFERNCE_FACTORY", false, 2, null);
            }
        }
    }
}

