/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirContextReceiver;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerConstantOperatorType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralConstantType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeConflictingProjection;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeStubType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0007H\u0016J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\bH\u0016J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\tH\u0016J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f*\u00060\rj\u0002`\u000e2\u0006\u0010\u0004\u001a\u00020\bH\u0016J\u0018\u0010\u000f\u001a\u00020\f*\u00060\rj\u0002`\u000e2\u0006\u0010\u0004\u001a\u00020\u0010H\u0016J\u0018\u0010\u000f\u001a\u00020\f*\u00060\rj\u0002`\u000e2\u0006\u0010\u0004\u001a\u00020\u0011H\u0016J\u0018\u0010\u000f\u001a\u00020\f*\u00060\rj\u0002`\u000e2\u0006\u0010\u0004\u001a\u00020\u0012H\u0016J\u0018\u0010\u000f\u001a\u00020\f*\u00060\rj\u0002`\u000e2\u0006\u0010\u0004\u001a\u00020\u0013H\u0016J\u0018\u0010\u000f\u001a\u00020\f*\u00060\rj\u0002`\u000e2\u0006\u0010\u0004\u001a\u00020\u0014H\u0016J\u0018\u0010\u000f\u001a\u00020\f*\u00060\rj\u0002`\u000e2\u0006\u0010\u0004\u001a\u00020\u0015H\u0016J\u0018\u0010\u000f\u001a\u00020\f*\u00060\rj\u0002`\u000e2\u0006\u0010\u0004\u001a\u00020\u0016H\u0016J\u0018\u0010\u000f\u001a\u00020\f*\u00060\rj\u0002`\u000e2\u0006\u0010\u0004\u001a\u00020\u0017H\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/FirDeclarationPresenter;", "", "represent", "", "it", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "owner", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "appendOperatorTag", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "appendRepresentation", "Lorg/jetbrains/kotlin/fir/FirElement;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "Lorg/jetbrains/kotlin/name/CallableId;", "Lorg/jetbrains/kotlin/name/ClassId;", "checkers"})
public interface FirDeclarationPresenter {
    public void appendRepresentation(@NotNull StringBuilder var1, @NotNull FirElement var2);

    public void appendRepresentation(@NotNull StringBuilder var1, @NotNull ClassId var2);

    public void appendRepresentation(@NotNull StringBuilder var1, @NotNull CallableId var2);

    public void appendRepresentation(@NotNull StringBuilder var1, @NotNull ConeTypeProjection var2);

    public void appendRepresentation(@NotNull StringBuilder var1, @NotNull ConeKotlinType var2);

    public void appendRepresentation(@NotNull StringBuilder var1, @NotNull FirTypeRef var2);

    public void appendRepresentation(@NotNull StringBuilder var1, @NotNull FirTypeParameter var2);

    public void appendRepresentation(@NotNull StringBuilder var1, @NotNull FirValueParameter var2);

    @NotNull
    public String represent(@NotNull FirVariable var1);

    public void appendOperatorTag(@NotNull StringBuilder var1, @NotNull FirSimpleFunction var2);

    @NotNull
    public String represent(@NotNull FirSimpleFunction var1);

    @NotNull
    public String represent(@NotNull FirTypeAlias var1);

    @NotNull
    public String represent(@NotNull FirRegularClass var1);

    @NotNull
    public String represent(@NotNull FirConstructor var1, @NotNull FirRegularClass var2);

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void appendRepresentation(@NotNull FirDeclarationPresenter $this, @NotNull StringBuilder $receiver, @NotNull FirElement it) {
            Intrinsics.checkNotNullParameter($receiver, "$receiver");
            Intrinsics.checkNotNullParameter(it, "it");
            $receiver.append("NO_REPRESENTATION");
        }

        public static void appendRepresentation(@NotNull FirDeclarationPresenter $this, @NotNull StringBuilder $receiver, @NotNull ClassId it) {
            Intrinsics.checkNotNullParameter($receiver, "$receiver");
            Intrinsics.checkNotNullParameter(it, "it");
            $receiver.append(it.getPackageFqName().asString());
            $receiver.append('/');
            $receiver.append(it.getRelativeClassName().asString());
        }

        public static void appendRepresentation(@NotNull FirDeclarationPresenter $this, @NotNull StringBuilder $receiver, @NotNull CallableId it) {
            Intrinsics.checkNotNullParameter($receiver, "$receiver");
            Intrinsics.checkNotNullParameter(it, "it");
            if (it.getClassName() != null) {
                $receiver.append(it.getPackageName().asString());
                $receiver.append('/');
                $receiver.append(it.getClassName());
                $receiver.append('.');
                $receiver.append(it.getCallableName());
            } else {
                $receiver.append(it.getPackageName().asString());
                $receiver.append('/');
                $receiver.append(it.getCallableName());
            }
        }

        public static void appendRepresentation(@NotNull FirDeclarationPresenter $this, @NotNull StringBuilder $receiver, @NotNull ConeTypeProjection it) {
            Intrinsics.checkNotNullParameter($receiver, "$receiver");
            Intrinsics.checkNotNullParameter(it, "it");
            ConeTypeProjection coneTypeProjection = it;
            if (Intrinsics.areEqual(coneTypeProjection, ConeStarProjection.INSTANCE)) {
                $receiver.append('*');
            } else if (coneTypeProjection instanceof ConeKotlinTypeProjectionIn) {
                $receiver.append("in ");
                $this.appendRepresentation($receiver, ((ConeKotlinTypeProjectionIn)it).getType());
            } else if (coneTypeProjection instanceof ConeKotlinTypeProjectionOut) {
                $receiver.append("out ");
                $this.appendRepresentation($receiver, ((ConeKotlinTypeProjectionOut)it).getType());
            } else if (coneTypeProjection instanceof ConeKotlinType) {
                $this.appendRepresentation($receiver, (ConeKotlinType)it);
            } else if (coneTypeProjection instanceof ConeKotlinTypeConflictingProjection) {
                // empty if block
            }
        }

        public static void appendRepresentation(@NotNull FirDeclarationPresenter $this, @NotNull StringBuilder $receiver, @NotNull ConeKotlinType it) {
            Intrinsics.checkNotNullParameter($receiver, "$receiver");
            Intrinsics.checkNotNullParameter(it, "it");
            ConeKotlinType coneKotlinType = it;
            if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
                $this.appendRepresentation($receiver, ((ConeDefinitelyNotNullType)it).getOriginal());
                $receiver.append(it.getNullability().getSuffix());
            } else if (coneKotlinType instanceof ConeErrorType) {
                $receiver.append("ERROR(");
                $receiver.append(((ConeErrorType)it).getDiagnostic().getReason());
                $receiver.append(')');
            } else if (coneKotlinType instanceof ConeCapturedType) {
                $receiver.append(((ConeCapturedType)it).getConstructor().getProjection());
                $receiver.append(it.getNullability().getSuffix());
            } else if (coneKotlinType instanceof ConeClassLikeType) {
                $this.appendRepresentation($receiver, ((ConeClassLikeType)it).getLookupTag().getClassId());
                if (!(it.getTypeArguments().length == 0)) {
                    $receiver.append('<');
                    ConeTypeProjection[] $this$forEach$iv = it.getTypeArguments();
                    boolean $i$f$forEach = false;
                    int n = $this$forEach$iv.length;
                    for (int i = 0; i < n; ++i) {
                        ConeTypeProjection element$iv;
                        ConeTypeProjection that = element$iv = $this$forEach$iv[i];
                        boolean bl = false;
                        $this.appendRepresentation($receiver, that);
                        $receiver.append(',');
                    }
                    $receiver.append('>');
                }
                $receiver.append(it.getNullability().getSuffix());
            } else if (coneKotlinType instanceof ConeLookupTagBasedType) {
                $receiver.append(((ConeLookupTagBasedType)it).getLookupTag().getName());
                $receiver.append(it.getNullability().getSuffix());
            } else if (coneKotlinType instanceof ConeIntegerLiteralConstantType) {
                $receiver.append(((ConeIntegerLiteralConstantType)it).getValue());
                $receiver.append(it.getNullability().getSuffix());
            } else if (coneKotlinType instanceof ConeIntegerConstantOperatorType) {
                $receiver.append("IOT");
                $receiver.append(it.getNullability().getSuffix());
            } else if ((coneKotlinType instanceof ConeFlexibleType ? true : coneKotlinType instanceof ConeIntersectionType) ? true : coneKotlinType instanceof ConeStubType) {
                $receiver.append("ERROR");
            }
        }

        public static void appendRepresentation(@NotNull FirDeclarationPresenter $this, @NotNull StringBuilder $receiver, @NotNull FirTypeRef it) {
            Intrinsics.checkNotNullParameter($receiver, "$receiver");
            Intrinsics.checkNotNullParameter(it, "it");
            if (it instanceof FirResolvedTypeRef) {
                $this.appendRepresentation($receiver, ((FirResolvedTypeRef)it).getType());
            } else {
                $receiver.append("?");
            }
        }

        /*
         * WARNING - void declaration
         */
        public static void appendRepresentation(@NotNull FirDeclarationPresenter $this, @NotNull StringBuilder $receiver, @NotNull FirTypeParameter it) {
            Intrinsics.checkNotNullParameter($receiver, "$receiver");
            Intrinsics.checkNotNullParameter(it, "it");
            $receiver.append(it.getName().asString());
            $receiver.append(':');
            switch (it.getBounds().size()) {
                case 0: {
                    break;
                }
                case 1: {
                    $this.appendRepresentation($receiver, it.getBounds().get(0));
                    break;
                }
                default: {
                    Object that;
                    TreeSet<String> set = SetsKt.sortedSetOf(new String[0]);
                    Iterable $this$forEach$iv = it.getBounds();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        void $this$appendRepresentation_u24lambda_u2d2_u24lambda_u2d1;
                        StringBuilder stringBuilder2;
                        that = (FirTypeRef)element$iv;
                        boolean bl = false;
                        StringBuilder stringBuilder3 = stringBuilder2 = new StringBuilder();
                        TreeSet<String> treeSet = set;
                        boolean bl2 = false;
                        $this.appendRepresentation((StringBuilder)$this$appendRepresentation_u24lambda_u2d2_u24lambda_u2d1, (FirTypeRef)that);
                        String string2 = stringBuilder2.toString();
                        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
                        treeSet.add(string2);
                    }
                    $this$forEach$iv = set;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        that = (String)element$iv;
                        boolean bl = false;
                        $receiver.append((String)that);
                        $receiver.append(',');
                    }
                }
            }
        }

        public static void appendRepresentation(@NotNull FirDeclarationPresenter $this, @NotNull StringBuilder $receiver, @NotNull FirValueParameter it) {
            Intrinsics.checkNotNullParameter($receiver, "$receiver");
            Intrinsics.checkNotNullParameter(it, "it");
            if (it.isVararg()) {
                $receiver.append("vararg ");
            }
            $this.appendRepresentation($receiver, it.getReturnTypeRef());
        }

        @NotNull
        public static String represent(@NotNull FirDeclarationPresenter $this, @NotNull FirVariable it) {
            StringBuilder stringBuilder2;
            Intrinsics.checkNotNullParameter(it, "it");
            StringBuilder $this$represent_u24lambda_u2d5 = stringBuilder2 = new StringBuilder();
            boolean bl = false;
            $this$represent_u24lambda_u2d5.append('[');
            FirTypeRef firTypeRef = it.getReceiverTypeRef();
            if (firTypeRef != null) {
                FirTypeRef it2 = firTypeRef;
                boolean bl2 = false;
                $this.appendRepresentation($this$represent_u24lambda_u2d5, it2);
            }
            $this$represent_u24lambda_u2d5.append(']');
            $this.appendRepresentation($this$represent_u24lambda_u2d5, it.getSymbol().getCallableId());
            String string2 = stringBuilder2.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
            return string2;
        }

        public static void appendOperatorTag(@NotNull FirDeclarationPresenter $this, @NotNull StringBuilder $receiver, @NotNull FirSimpleFunction it) {
            Intrinsics.checkNotNullParameter($receiver, "$receiver");
            Intrinsics.checkNotNullParameter(it, "it");
            FirMemberDeclaration $this$isOperator$iv = it;
            boolean $i$f$isOperator = false;
            if ($this$isOperator$iv.getStatus().isOperator()) {
                $receiver.append("operator ");
            }
        }

        @NotNull
        public static String represent(@NotNull FirDeclarationPresenter $this, @NotNull FirSimpleFunction it) {
            FirPureAbstractElement it2;
            StringBuilder stringBuilder2;
            Intrinsics.checkNotNullParameter(it, "it");
            StringBuilder $this$represent_u24lambda_u2d10 = stringBuilder2 = new StringBuilder();
            boolean bl = false;
            Iterable $this$forEach$iv = it.getContextReceivers();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it2 = (FirContextReceiver)element$iv;
                boolean bl2 = false;
                $this.appendRepresentation($this$represent_u24lambda_u2d10, it2);
                $this$represent_u24lambda_u2d10.append(',');
            }
            $this$represent_u24lambda_u2d10.append('<');
            $this$forEach$iv = it.getTypeParameters();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it2 = (FirTypeParameter)element$iv;
                boolean bl3 = false;
                $this.appendRepresentation($this$represent_u24lambda_u2d10, (FirTypeParameter)it2);
                $this$represent_u24lambda_u2d10.append(',');
            }
            $this$represent_u24lambda_u2d10.append('>');
            $this$represent_u24lambda_u2d10.append('[');
            FirTypeRef firTypeRef = it.getReceiverTypeRef();
            if (firTypeRef != null) {
                FirTypeRef it3 = firTypeRef;
                boolean bl4 = false;
                $this.appendRepresentation($this$represent_u24lambda_u2d10, it3);
            }
            $this$represent_u24lambda_u2d10.append(']');
            $this.appendOperatorTag($this$represent_u24lambda_u2d10, it);
            $this.appendRepresentation($this$represent_u24lambda_u2d10, it.getSymbol().getCallableId());
            $this$represent_u24lambda_u2d10.append('(');
            $this$forEach$iv = it.getValueParameters();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it2 = (FirValueParameter)element$iv;
                boolean bl5 = false;
                $this.appendRepresentation($this$represent_u24lambda_u2d10, (FirValueParameter)it2);
                $this$represent_u24lambda_u2d10.append(',');
            }
            $this$represent_u24lambda_u2d10.append(')');
            String string2 = stringBuilder2.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
            return string2;
        }

        @NotNull
        public static String represent(@NotNull FirDeclarationPresenter $this, @NotNull FirTypeAlias it) {
            StringBuilder stringBuilder2;
            Intrinsics.checkNotNullParameter(it, "it");
            StringBuilder $this$represent_u24lambda_u2d11 = stringBuilder2 = new StringBuilder();
            boolean bl = false;
            $this$represent_u24lambda_u2d11.append('[');
            $this$represent_u24lambda_u2d11.append(']');
            $this.appendRepresentation($this$represent_u24lambda_u2d11, it.getSymbol().getClassId());
            String string2 = stringBuilder2.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
            return string2;
        }

        @NotNull
        public static String represent(@NotNull FirDeclarationPresenter $this, @NotNull FirRegularClass it) {
            StringBuilder stringBuilder2;
            Intrinsics.checkNotNullParameter(it, "it");
            StringBuilder $this$represent_u24lambda_u2d12 = stringBuilder2 = new StringBuilder();
            boolean bl = false;
            $this$represent_u24lambda_u2d12.append('[');
            $this$represent_u24lambda_u2d12.append(']');
            $this.appendRepresentation($this$represent_u24lambda_u2d12, it.getSymbol().getClassId());
            String string2 = stringBuilder2.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
            return string2;
        }

        @NotNull
        public static String represent(@NotNull FirDeclarationPresenter $this, @NotNull FirConstructor it, @NotNull FirRegularClass owner) {
            FirElement it2;
            StringBuilder stringBuilder2;
            Intrinsics.checkNotNullParameter(it, "it");
            Intrinsics.checkNotNullParameter(owner, "owner");
            StringBuilder $this$represent_u24lambda_u2d16 = stringBuilder2 = new StringBuilder();
            boolean bl = false;
            Iterable $this$forEach$iv = it.getContextReceivers();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it2 = (FirContextReceiver)element$iv;
                boolean bl2 = false;
                $this.appendRepresentation($this$represent_u24lambda_u2d16, it2);
                $this$represent_u24lambda_u2d16.append(',');
            }
            $this$represent_u24lambda_u2d16.append('<');
            $this$forEach$iv = it.getTypeParameters();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it2 = (FirTypeParameterRef)element$iv;
                boolean bl3 = false;
                $this.appendRepresentation($this$represent_u24lambda_u2d16, it2);
                $this$represent_u24lambda_u2d16.append(',');
            }
            $this$represent_u24lambda_u2d16.append('>');
            $this$represent_u24lambda_u2d16.append('[');
            $this$represent_u24lambda_u2d16.append(']');
            $this.appendRepresentation($this$represent_u24lambda_u2d16, owner.getSymbol().getClassId());
            $this$represent_u24lambda_u2d16.append('(');
            $this$forEach$iv = it.getValueParameters();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it2 = (FirValueParameter)element$iv;
                boolean bl4 = false;
                $this.appendRepresentation($this$represent_u24lambda_u2d16, (FirValueParameter)it2);
                $this$represent_u24lambda_u2d16.append(',');
            }
            $this$represent_u24lambda_u2d16.append(')');
            String string2 = stringBuilder2.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
            return string2;
        }
    }
}

