/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.common;

import java.io.IOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.daemon.common.LoopbackNetworkInterface;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\"#$B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001b\u0010\f\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000b\u001a\u0004\b\r\u0010\tR\u001b\u0010\u000f\u001a\u00020\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000b\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0014\u001a\u00020\u00158FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u000b\u001a\u0004\b\u0016\u0010\u0017R\u001b\u0010\u0019\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u000b\u001a\u0004\b\u001a\u0010\u001bR\u001b\u0010\u001d\u001a\u00020\u001e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u000b\u001a\u0004\b\u001f\u0010 \u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/daemon/common/LoopbackNetworkInterface;", "", "()V", "IPV4_LOOPBACK_INET_ADDRESS", "", "IPV6_LOOPBACK_INET_ADDRESS", "SERVER_SOCKET_BACKLOG_SIZE", "", "getSERVER_SOCKET_BACKLOG_SIZE", "()I", "SERVER_SOCKET_BACKLOG_SIZE$delegate", "Lkotlin/Lazy;", "SOCKET_CONNECT_ATTEMPTS", "getSOCKET_CONNECT_ATTEMPTS", "SOCKET_CONNECT_ATTEMPTS$delegate", "SOCKET_CONNECT_INTERVAL_MS", "", "getSOCKET_CONNECT_INTERVAL_MS", "()J", "SOCKET_CONNECT_INTERVAL_MS$delegate", "clientLoopbackSocketFactory", "Lorg/jetbrains/kotlin/daemon/common/LoopbackNetworkInterface$ClientLoopbackSocketFactory;", "getClientLoopbackSocketFactory", "()Lorg/jetbrains/kotlin/daemon/common/LoopbackNetworkInterface$ClientLoopbackSocketFactory;", "clientLoopbackSocketFactory$delegate", "loopbackInetAddressName", "getLoopbackInetAddressName", "()Ljava/lang/String;", "loopbackInetAddressName$delegate", "serverLoopbackSocketFactory", "Lorg/jetbrains/kotlin/daemon/common/LoopbackNetworkInterface$ServerLoopbackSocketFactory;", "getServerLoopbackSocketFactory", "()Lorg/jetbrains/kotlin/daemon/common/LoopbackNetworkInterface$ServerLoopbackSocketFactory;", "serverLoopbackSocketFactory$delegate", "AbstractClientLoopbackSocketFactory", "ClientLoopbackSocketFactory", "ServerLoopbackSocketFactory", "daemon-common"})
public final class LoopbackNetworkInterface {
    @NotNull
    public static final LoopbackNetworkInterface INSTANCE = new LoopbackNetworkInterface();
    @NotNull
    public static final String IPV4_LOOPBACK_INET_ADDRESS = "127.0.0.1";
    @NotNull
    public static final String IPV6_LOOPBACK_INET_ADDRESS = "::1";
    @NotNull
    private static final Lazy SERVER_SOCKET_BACKLOG_SIZE$delegate = LazyKt.lazy(SERVER_SOCKET_BACKLOG_SIZE.2.INSTANCE);
    @NotNull
    private static final Lazy SOCKET_CONNECT_ATTEMPTS$delegate = LazyKt.lazy(SOCKET_CONNECT_ATTEMPTS.2.INSTANCE);
    @NotNull
    private static final Lazy SOCKET_CONNECT_INTERVAL_MS$delegate = LazyKt.lazy(SOCKET_CONNECT_INTERVAL_MS.2.INSTANCE);
    @NotNull
    private static final Lazy serverLoopbackSocketFactory$delegate = LazyKt.lazy(serverLoopbackSocketFactory.2.INSTANCE);
    @NotNull
    private static final Lazy clientLoopbackSocketFactory$delegate = LazyKt.lazy(clientLoopbackSocketFactory.2.INSTANCE);
    @NotNull
    private static final Lazy loopbackInetAddressName$delegate = LazyKt.lazy(loopbackInetAddressName.2.INSTANCE);

    private LoopbackNetworkInterface() {
    }

    public final int getSERVER_SOCKET_BACKLOG_SIZE() {
        Lazy lazy = SERVER_SOCKET_BACKLOG_SIZE$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public final int getSOCKET_CONNECT_ATTEMPTS() {
        Lazy lazy = SOCKET_CONNECT_ATTEMPTS$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public final long getSOCKET_CONNECT_INTERVAL_MS() {
        Lazy lazy = SOCKET_CONNECT_INTERVAL_MS$delegate;
        return ((Number)lazy.getValue()).longValue();
    }

    @NotNull
    public final ServerLoopbackSocketFactory getServerLoopbackSocketFactory() {
        Lazy lazy = serverLoopbackSocketFactory$delegate;
        return (ServerLoopbackSocketFactory)lazy.getValue();
    }

    @NotNull
    public final ClientLoopbackSocketFactory getClientLoopbackSocketFactory() {
        Lazy lazy = clientLoopbackSocketFactory$delegate;
        return (ClientLoopbackSocketFactory)lazy.getValue();
    }

    @NotNull
    public final String getLoopbackInetAddressName() {
        Lazy lazy = loopbackInetAddressName$delegate;
        return (String)lazy.getValue();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\u0002J\b\u0010\f\u001a\u00020\u0007H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/daemon/common/LoopbackNetworkInterface$ServerLoopbackSocketFactory;", "Ljava/rmi/server/RMIServerSocketFactory;", "Ljava/io/Serializable;", "()V", "createServerSocket", "Ljava/net/ServerSocket;", "port", "", "equals", "", "other", "", "hashCode", "daemon-common"})
    public static final class ServerLoopbackSocketFactory
    implements RMIServerSocketFactory,
    Serializable {
        public boolean equals(@Nullable Object other) {
            return other == this || super.equals(other);
        }

        public int hashCode() {
            return super.hashCode();
        }

        @Override
        @NotNull
        public ServerSocket createServerSocket(int port) throws IOException {
            return new ServerSocket(port, INSTANCE.getSERVER_SOCKET_BACKLOG_SIZE(), InetAddress.getByName(null));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u00028\u00002\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0002J\b\u0010\u000e\u001a\u00020\bH\u0016J\u001d\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH$\u00a2\u0006\u0002\u0010\t\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/daemon/common/LoopbackNetworkInterface$AbstractClientLoopbackSocketFactory;", "SocketType", "Ljava/io/Serializable;", "()V", "createSocket", "host", "", "port", "", "(Ljava/lang/String;I)Ljava/lang/Object;", "equals", "", "other", "", "hashCode", "socketCreate", "daemon-common"})
    public static abstract class AbstractClientLoopbackSocketFactory<SocketType>
    implements Serializable {
        public boolean equals(@Nullable Object other) {
            return other == this || super.equals(other);
        }

        public int hashCode() {
            return super.hashCode();
        }

        protected abstract SocketType socketCreate(@NotNull String var1, int var2);

        public final SocketType createSocket(@NotNull String host, int port) throws IOException {
            Intrinsics.checkNotNullParameter(host, "host");
            int attemptsLeft = INSTANCE.getSOCKET_CONNECT_ATTEMPTS();
            while (true) {
                try {
                    return this.socketCreate(host, port);
                }
                catch (ConnectException e) {
                    if (--attemptsLeft <= 0) {
                        throw e;
                    }
                    Thread.sleep(INSTANCE.getSOCKET_CONNECT_INTERVAL_MS());
                    continue;
                }
                break;
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/daemon/common/LoopbackNetworkInterface$ClientLoopbackSocketFactory;", "Lorg/jetbrains/kotlin/daemon/common/LoopbackNetworkInterface$AbstractClientLoopbackSocketFactory;", "Ljava/net/Socket;", "Ljava/rmi/server/RMIClientSocketFactory;", "()V", "socketCreate", "host", "", "port", "", "daemon-common"})
    public static final class ClientLoopbackSocketFactory
    extends AbstractClientLoopbackSocketFactory<Socket>
    implements RMIClientSocketFactory {
        @Override
        @NotNull
        protected Socket socketCreate(@NotNull String host, int port) {
            Intrinsics.checkNotNullParameter(host, "host");
            return new Socket(InetAddress.getByName(null), port);
        }
    }
}

