/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.command.impl;

import java.util.List;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.application.Application;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.command.CommandEvent;
import org.jetbrains.kotlin.com.intellij.openapi.command.CommandListener;
import org.jetbrains.kotlin.com.intellij.openapi.command.CommandProcessorEx;
import org.jetbrains.kotlin.com.intellij.openapi.command.CommandToken;
import org.jetbrains.kotlin.com.intellij.openapi.command.UndoConfirmationPolicy;
import org.jetbrains.kotlin.com.intellij.openapi.command.impl.CommandLog;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageBus;

public class CoreCommandProcessor
extends CommandProcessorEx {
    protected CommandDescriptor myCurrentCommand;
    private final Stack<CommandDescriptor> myInterruptedCommands = new Stack();
    private final List<CommandListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private int myUndoTransparentCount;
    private final CommandListener eventPublisher;

    public CoreCommandProcessor() {
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        messageBus.simpleConnect().subscribe(CommandListener.TOPIC, new CommandListener(){

            @Override
            public void commandStarted(@NotNull CommandEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (CommandListener listener : CoreCommandProcessor.this.myListeners) {
                    try {
                        listener.commandStarted(event);
                    }
                    catch (Throwable e) {
                        CommandLog.LOG.error(e);
                    }
                }
            }

            @Override
            public void beforeCommandFinished(@NotNull CommandEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                for (CommandListener listener : CoreCommandProcessor.this.myListeners) {
                    try {
                        listener.beforeCommandFinished(event);
                    }
                    catch (Throwable e) {
                        CommandLog.LOG.error(e);
                    }
                }
            }

            @Override
            public void commandFinished(@NotNull CommandEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                for (CommandListener listener : CoreCommandProcessor.this.myListeners) {
                    try {
                        listener.commandFinished(event);
                    }
                    catch (Throwable e) {
                        CommandLog.LOG.error(e);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/command/impl/CoreCommandProcessor$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "commandStarted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeCommandFinished";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "commandFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.eventPublisher = messageBus.syncPublisher(CommandListener.TOPIC);
    }

    @Override
    public void executeCommand(Project project, @NotNull Runnable runnable, String name2, Object groupId) {
        if (runnable == null) {
            CoreCommandProcessor.$$$reportNull$$$0(1);
        }
        this.executeCommand(project, runnable, name2, groupId, UndoConfirmationPolicy.DEFAULT);
    }

    public void executeCommand(Project project, @NotNull Runnable command2, String name2, Object groupId, @NotNull UndoConfirmationPolicy confirmationPolicy) {
        if (command2 == null) {
            CoreCommandProcessor.$$$reportNull$$$0(3);
        }
        if (confirmationPolicy == null) {
            CoreCommandProcessor.$$$reportNull$$$0(4);
        }
        this.executeCommand(project, command2, name2, groupId, confirmationPolicy, null);
    }

    public void executeCommand(Project project, @NotNull Runnable command2, String name2, Object groupId, @NotNull UndoConfirmationPolicy confirmationPolicy, Document document2) {
        if (command2 == null) {
            CoreCommandProcessor.$$$reportNull$$$0(5);
        }
        if (confirmationPolicy == null) {
            CoreCommandProcessor.$$$reportNull$$$0(6);
        }
        this.executeCommand(project, command2, name2, groupId, confirmationPolicy, true, document2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCommand(@Nullable Project project, @NotNull Runnable command2, @Nullable String name2, @Nullable Object groupId, @NotNull UndoConfirmationPolicy confirmationPolicy, boolean shouldRecordCommandForActiveDocument, @Nullable Document document2) {
        if (command2 == null) {
            CoreCommandProcessor.$$$reportNull$$$0(9);
        }
        if (confirmationPolicy == null) {
            CoreCommandProcessor.$$$reportNull$$$0(10);
        }
        Application application = ApplicationManager.getApplication();
        application.assertIsWriteThread();
        if (project != null && project.isDisposed()) {
            CommandLog.LOG.error("Project " + project + " already disposed");
            return;
        }
        if (CommandLog.LOG.isDebugEnabled()) {
            CommandLog.LOG.debug("executeCommand: " + command2 + ", name = " + name2 + ", groupId = " + groupId + ", in command = " + (this.myCurrentCommand != null) + ", in transparent action = " + this.isUndoTransparentActionInProgress());
        }
        if (this.myCurrentCommand != null) {
            command2.run();
            return;
        }
        Throwable throwable = null;
        CommandDescriptor descriptor2 = new CommandDescriptor(command2, project, name2, groupId, confirmationPolicy, shouldRecordCommandForActiveDocument, document2);
        try {
            this.myCurrentCommand = descriptor2;
            this.fireCommandStarted();
            command2.run();
        }
        catch (Throwable th) {
            throwable = th;
        }
        finally {
            this.finishCommand(descriptor2, throwable);
        }
    }

    public void finishCommand(@NotNull CommandToken command2, @Nullable Throwable throwable) {
        if (command2 == null) {
            CoreCommandProcessor.$$$reportNull$$$0(12);
        }
        ApplicationManager.getApplication().assertIsWriteThread();
        CommandLog.LOG.assertTrue(this.myCurrentCommand != null, "no current command in progress");
        this.fireCommandFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCommandFinished() {
        ApplicationManager.getApplication().assertIsWriteThread();
        CommandDescriptor currentCommand = this.myCurrentCommand;
        CommandEvent event = new CommandEvent(this, currentCommand.myCommand, currentCommand.myName, currentCommand.myGroupId, currentCommand.myProject, currentCommand.myUndoConfirmationPolicy, currentCommand.myShouldRecordActionForActiveDocument, currentCommand.myDocument);
        CommandListener publisher = this.eventPublisher;
        try {
            publisher.beforeCommandFinished(event);
        }
        finally {
            this.myCurrentCommand = null;
            publisher.commandFinished(event);
        }
    }

    @Override
    @Nullable
    public Runnable getCurrentCommand() {
        CommandDescriptor currentCommand = this.myCurrentCommand;
        return currentCommand != null ? currentCommand.myCommand : null;
    }

    @Override
    public boolean isUndoTransparentActionInProgress() {
        return this.myUndoTransparentCount > 0;
    }

    private void fireCommandStarted() {
        ApplicationManager.getApplication().assertIsWriteThread();
        CommandDescriptor currentCommand = this.myCurrentCommand;
        CommandEvent event = new CommandEvent(this, currentCommand.myCommand, currentCommand.myName, currentCommand.myGroupId, currentCommand.myProject, currentCommand.myUndoConfirmationPolicy, currentCommand.myShouldRecordActionForActiveDocument, currentCommand.myDocument);
        this.eventPublisher.commandStarted(event);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "confirmationPolicy";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "undoConfirmationPolicy";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docs";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/command/impl/CoreCommandProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "executeCommand";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "startCommand";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "finishCommand";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "addCommandListener";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "removeCommandListener";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "runUndoTransparentAction";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "addAffectedDocuments";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "addAffectedFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CommandDescriptor
    implements CommandToken {
        @NotNull
        public final Runnable myCommand;
        public final Project myProject;
        public String myName;
        public Object myGroupId;
        public final Document myDocument;
        @NotNull
        final UndoConfirmationPolicy myUndoConfirmationPolicy;
        final boolean myShouldRecordActionForActiveDocument;

        CommandDescriptor(@NotNull Runnable command2, Project project, String name2, Object groupId, @NotNull UndoConfirmationPolicy undoConfirmationPolicy, boolean shouldRecordActionForActiveDocument, Document document2) {
            if (command2 == null) {
                CommandDescriptor.$$$reportNull$$$0(0);
            }
            if (undoConfirmationPolicy == null) {
                CommandDescriptor.$$$reportNull$$$0(1);
            }
            this.myCommand = command2;
            this.myProject = project;
            this.myName = name2;
            this.myGroupId = groupId;
            this.myUndoConfirmationPolicy = undoConfirmationPolicy;
            this.myShouldRecordActionForActiveDocument = shouldRecordActionForActiveDocument;
            this.myDocument = document2;
        }

        public String toString() {
            return "'" + this.myName + "', group: '" + this.myGroupId + "'";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "command";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "undoConfirmationPolicy";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/com/intellij/openapi/command/impl/CoreCommandProcessor$CommandDescriptor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

