/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.inject.spi;

import java.util.Set;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.inject.Binder;
import org.jetbrains.kotlin.com.google.inject.ConfigurationException;
import org.jetbrains.kotlin.com.google.inject.TypeLiteral;
import org.jetbrains.kotlin.com.google.inject.spi.Element;
import org.jetbrains.kotlin.com.google.inject.spi.ElementVisitor;
import org.jetbrains.kotlin.com.google.inject.spi.InjectionPoint;

public final class InjectionRequest<T>
implements Element {
    private final Object source;
    private final TypeLiteral<T> type;
    private final T instance;

    public InjectionRequest(Object source, TypeLiteral<T> type2, T instance) {
        this.source = Preconditions.checkNotNull(source, "source");
        this.type = Preconditions.checkNotNull(type2, "type");
        this.instance = Preconditions.checkNotNull(instance, "instance");
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public T getInstance() {
        return this.instance;
    }

    public TypeLiteral<T> getType() {
        return this.type;
    }

    public Set<InjectionPoint> getInjectionPoints() throws ConfigurationException {
        return InjectionPoint.forInstanceMethodsAndFields(this.instance.getClass());
    }

    public <R> R acceptVisitor(ElementVisitor<R> visitor2) {
        return visitor2.visit(this);
    }

    @Override
    public void applyTo(Binder binder) {
        binder.withSource(this.getSource()).requestInjection(this.type, this.instance);
    }
}

