/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.inject.spi;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.kotlin.com.google.common.collect.ComparisonChain;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableList;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableSet;
import org.jetbrains.kotlin.com.google.common.collect.Lists;
import org.jetbrains.kotlin.com.google.common.collect.Ordering;
import org.jetbrains.kotlin.com.google.inject.ConfigurationException;
import org.jetbrains.kotlin.com.google.inject.Inject;
import org.jetbrains.kotlin.com.google.inject.Key;
import org.jetbrains.kotlin.com.google.inject.TypeLiteral;
import org.jetbrains.kotlin.com.google.inject.internal.Annotations;
import org.jetbrains.kotlin.com.google.inject.internal.Errors;
import org.jetbrains.kotlin.com.google.inject.internal.ErrorsException;
import org.jetbrains.kotlin.com.google.inject.internal.MoreTypes;
import org.jetbrains.kotlin.com.google.inject.internal.Nullability;
import org.jetbrains.kotlin.com.google.inject.internal.util.Classes;
import org.jetbrains.kotlin.com.google.inject.spi.Dependency;
import org.jetbrains.kotlin.com.google.inject.spi.Toolable;

public final class InjectionPoint {
    private static final Logger logger = Logger.getLogger(InjectionPoint.class.getName());
    private final boolean optional;
    private final Member member;
    private final TypeLiteral<?> declaringType;
    private final ImmutableList<Dependency<?>> dependencies;
    private static final Ordering<Class<?>> CLASS_ORDERING = new Ordering<Class<?>>(){

        @Override
        public int compare(Class<?> o1, Class<?> o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private static final Ordering<Field> FIELD_ORDERING = new Ordering<Field>(){

        @Override
        public int compare(Field left, Field right) {
            return ComparisonChain.start().compare((Comparable<?>)((Object)left.getName()), (Comparable<?>)((Object)right.getName())).compare(left.getType(), right.getType(), CLASS_ORDERING).result();
        }
    };
    private static final Ordering<Method> METHOD_ORDERING = new Ordering<Method>(){

        @Override
        public int compare(Method left, Method right) {
            return ComparisonChain.start().compare((Comparable<?>)((Object)left.getName()), (Comparable<?>)((Object)right.getName())).compare(left.getReturnType(), right.getReturnType(), CLASS_ORDERING).compare(Arrays.asList(left.getParameterTypes()), Arrays.asList(right.getParameterTypes()), CLASS_ORDERING.lexicographical()).result();
        }
    };

    InjectionPoint(TypeLiteral<?> declaringType, Method method, boolean optional) {
        this.member = method;
        this.declaringType = declaringType;
        this.optional = optional;
        this.dependencies = this.forMember(method, declaringType, method.getParameterAnnotations());
    }

    InjectionPoint(TypeLiteral<?> declaringType, Constructor<?> constructor2) {
        this.member = constructor2;
        this.declaringType = declaringType;
        this.optional = false;
        this.dependencies = this.forMember(constructor2, declaringType, constructor2.getParameterAnnotations());
    }

    InjectionPoint(TypeLiteral<?> declaringType, Field field2, boolean optional) {
        this.member = field2;
        this.declaringType = declaringType;
        this.optional = optional;
        Annotation[] annotations2 = field2.getAnnotations();
        Errors errors = new Errors(field2);
        Key<?> key = null;
        try {
            key = Annotations.getKey(declaringType.getFieldType(field2), field2, annotations2, errors);
        }
        catch (ConfigurationException e) {
            errors.merge(e.getErrorMessages());
        }
        catch (ErrorsException e) {
            errors.merge(e.getErrors());
        }
        errors.throwConfigurationExceptionIfErrorsExist();
        this.dependencies = ImmutableList.of(this.newDependency(key, Nullability.allowsNull(annotations2), -1));
    }

    private ImmutableList<Dependency<?>> forMember(Member member2, TypeLiteral<?> type2, Annotation[][] paramterAnnotations) {
        Errors errors = new Errors(member2);
        ArrayList<Dependency<?>> dependencies2 = Lists.newArrayList();
        int index2 = 0;
        for (TypeLiteral<?> parameterType : type2.getParameterTypes(member2)) {
            try {
                Annotation[] parameterAnnotations = paramterAnnotations[index2];
                Key<?> key = Annotations.getKey(parameterType, member2, parameterAnnotations, errors);
                dependencies2.add(this.newDependency(key, Nullability.allowsNull(parameterAnnotations), index2));
                ++index2;
            }
            catch (ConfigurationException e) {
                errors.merge(e.getErrorMessages());
            }
            catch (ErrorsException e) {
                errors.merge(e.getErrors());
            }
        }
        errors.throwConfigurationExceptionIfErrorsExist();
        return ImmutableList.copyOf(dependencies2);
    }

    private <T> Dependency<T> newDependency(Key<T> key, boolean allowsNull, int parameterIndex) {
        return new Dependency<T>(this, key, allowsNull, parameterIndex);
    }

    public Member getMember() {
        return this.member;
    }

    public List<Dependency<?>> getDependencies() {
        return this.dependencies;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean isToolable() {
        return ((AnnotatedElement)((Object)this.member)).isAnnotationPresent(Toolable.class);
    }

    public TypeLiteral<?> getDeclaringType() {
        return this.declaringType;
    }

    public boolean equals(Object o) {
        return o instanceof InjectionPoint && this.member.equals(((InjectionPoint)o).member) && this.declaringType.equals(((InjectionPoint)o).declaringType);
    }

    public int hashCode() {
        return this.member.hashCode() ^ this.declaringType.hashCode();
    }

    public String toString() {
        return Classes.toString(this.member);
    }

    public static <T> InjectionPoint forConstructor(Constructor<T> constructor2) {
        return new InjectionPoint(TypeLiteral.get(constructor2.getDeclaringClass()), constructor2);
    }

    public static <T> InjectionPoint forConstructor(Constructor<T> constructor2, TypeLiteral<? extends T> type2) {
        if (type2.getRawType() != constructor2.getDeclaringClass()) {
            new Errors(type2).constructorNotDefinedByType(constructor2, type2).throwConfigurationExceptionIfErrorsExist();
        }
        return new InjectionPoint(type2, constructor2);
    }

    public static InjectionPoint forConstructorOf(TypeLiteral<?> type2) {
        Class<?> rawType = MoreTypes.getRawType(type2.getType());
        Errors errors = new Errors(rawType);
        Constructor<?> injectableConstructor = null;
        for (Constructor<?> constructor2 : rawType.getDeclaredConstructors()) {
            boolean optional;
            Inject guiceInject = constructor2.getAnnotation(Inject.class);
            if (guiceInject == null) {
                javax.inject.Inject javaxInject = constructor2.getAnnotation(javax.inject.Inject.class);
                if (javaxInject == null) continue;
                optional = false;
            } else {
                optional = guiceInject.optional();
            }
            if (optional) {
                errors.optionalConstructor(constructor2);
            }
            if (injectableConstructor != null) {
                errors.tooManyConstructors(rawType);
            }
            injectableConstructor = constructor2;
            InjectionPoint.checkForMisplacedBindingAnnotations(injectableConstructor, errors);
        }
        errors.throwConfigurationExceptionIfErrorsExist();
        if (injectableConstructor != null) {
            return new InjectionPoint(type2, injectableConstructor);
        }
        try {
            Constructor<?> noArgConstructor = rawType.getDeclaredConstructor(new Class[0]);
            if (Modifier.isPrivate(noArgConstructor.getModifiers()) && !Modifier.isPrivate(rawType.getModifiers())) {
                errors.missingConstructor(rawType);
                throw new ConfigurationException(errors.getMessages());
            }
            InjectionPoint.checkForMisplacedBindingAnnotations(noArgConstructor, errors);
            return new InjectionPoint(type2, noArgConstructor);
        }
        catch (NoSuchMethodException e) {
            errors.missingConstructor(rawType);
            throw new ConfigurationException(errors.getMessages());
        }
    }

    public static InjectionPoint forConstructorOf(Class<?> type2) {
        return InjectionPoint.forConstructorOf(TypeLiteral.get(type2));
    }

    public static <T> InjectionPoint forMethod(Method method, TypeLiteral<T> type2) {
        return new InjectionPoint(type2, method, false);
    }

    public static Set<InjectionPoint> forStaticMethodsAndFields(TypeLiteral<?> type2) {
        Set<InjectionPoint> result2;
        Errors errors = new Errors();
        if (type2.getRawType().isInterface()) {
            errors.staticInjectionOnInterface(type2.getRawType());
            result2 = null;
        } else {
            result2 = InjectionPoint.getInjectionPoints(type2, true, errors);
        }
        if (errors.hasErrors()) {
            throw new ConfigurationException(errors.getMessages()).withPartialValue(result2);
        }
        return result2;
    }

    public static Set<InjectionPoint> forStaticMethodsAndFields(Class<?> type2) {
        return InjectionPoint.forStaticMethodsAndFields(TypeLiteral.get(type2));
    }

    public static Set<InjectionPoint> forInstanceMethodsAndFields(TypeLiteral<?> type2) {
        Errors errors = new Errors();
        Set<InjectionPoint> result2 = InjectionPoint.getInjectionPoints(type2, false, errors);
        if (errors.hasErrors()) {
            throw new ConfigurationException(errors.getMessages()).withPartialValue(result2);
        }
        return result2;
    }

    public static Set<InjectionPoint> forInstanceMethodsAndFields(Class<?> type2) {
        return InjectionPoint.forInstanceMethodsAndFields(TypeLiteral.get(type2));
    }

    private static boolean checkForMisplacedBindingAnnotations(Member member2, Errors errors) {
        Annotation misplacedBindingAnnotation = Annotations.findBindingAnnotation(errors, member2, ((AnnotatedElement)((Object)member2)).getAnnotations());
        if (misplacedBindingAnnotation == null) {
            return false;
        }
        if (member2 instanceof Method) {
            try {
                if (member2.getDeclaringClass().getDeclaredField(member2.getName()) != null) {
                    return false;
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        errors.misplacedBindingAnnotation(member2, misplacedBindingAnnotation);
        return true;
    }

    static Annotation getAtInject(AnnotatedElement member2) {
        javax.inject.Inject a = member2.getAnnotation(javax.inject.Inject.class);
        return a == null ? member2.getAnnotation(Inject.class) : a;
    }

    private static Set<InjectionPoint> getInjectionPoints(TypeLiteral<?> type2, boolean statics, Errors errors) {
        int topIndex;
        InjectableMembers injectableMembers = new InjectableMembers();
        OverrideIndex overrideIndex = null;
        List<TypeLiteral<?>> hierarchy = InjectionPoint.hierarchyFor(type2);
        for (int i = topIndex = hierarchy.size() - 1; i >= 0; --i) {
            Annotation atInject;
            if (overrideIndex != null && i < topIndex) {
                overrideIndex.position = i == 0 ? Position.BOTTOM : Position.MIDDLE;
            }
            TypeLiteral<?> current = hierarchy.get(i);
            for (Field field2 : InjectionPoint.getDeclaredFields(current)) {
                if (Modifier.isStatic(field2.getModifiers()) != statics || (atInject = InjectionPoint.getAtInject(field2)) == null) continue;
                InjectableField injectableField = new InjectableField(current, field2, atInject);
                if (injectableField.jsr330 && Modifier.isFinal(field2.getModifiers())) {
                    errors.cannotInjectFinalField(field2);
                }
                injectableMembers.add(injectableField);
            }
            for (AccessibleObject accessibleObject : InjectionPoint.getDeclaredMethods(current)) {
                boolean removed2;
                if (!InjectionPoint.isEligibleForInjection((Method)accessibleObject, statics)) continue;
                atInject = InjectionPoint.getAtInject(accessibleObject);
                if (atInject != null) {
                    InjectableMethod injectableMethod = new InjectableMethod(current, (Method)accessibleObject, atInject);
                    if (InjectionPoint.checkForMisplacedBindingAnnotations((Member)((Object)accessibleObject), errors) || !InjectionPoint.isValidMethod(injectableMethod, errors)) {
                        boolean removed3;
                        if (overrideIndex == null || !(removed3 = overrideIndex.removeIfOverriddenBy((Method)accessibleObject, false, injectableMethod))) continue;
                        logger.log(Level.WARNING, "Method: {0} is not a valid injectable method (because it either has misplaced binding annotations or specifies type parameters) but is overriding a method that is valid. Because it is not valid, the method will not be injected. To fix this, make the method a valid injectable method.", accessibleObject);
                        continue;
                    }
                    if (statics) {
                        injectableMembers.add(injectableMethod);
                        continue;
                    }
                    if (overrideIndex == null) {
                        overrideIndex = new OverrideIndex(injectableMembers);
                    } else {
                        overrideIndex.removeIfOverriddenBy((Method)accessibleObject, true, injectableMethod);
                    }
                    overrideIndex.add(injectableMethod);
                    continue;
                }
                if (overrideIndex == null || !(removed2 = overrideIndex.removeIfOverriddenBy((Method)accessibleObject, false, null))) continue;
                logger.log(Level.WARNING, "Method: {0} is not annotated with @Inject but is overriding a method that is annotated with @javax.inject.Inject.Because it is not annotated with @Inject, the method will not be injected. To fix this, annotate the method with @Inject.", accessibleObject);
            }
        }
        if (injectableMembers.isEmpty()) {
            return Collections.emptySet();
        }
        ImmutableSet.Builder builder2 = ImmutableSet.builder();
        InjectableMember im = injectableMembers.head;
        while (im != null) {
            block14: {
                try {
                    builder2.add(im.toInjectionPoint());
                }
                catch (ConfigurationException ignorable) {
                    if (im.optional) break block14;
                    errors.merge(ignorable.getErrorMessages());
                }
            }
            im = im.next;
        }
        return builder2.build();
    }

    private static Field[] getDeclaredFields(TypeLiteral<?> type2) {
        Field[] fields2 = type2.getRawType().getDeclaredFields();
        Arrays.sort(fields2, FIELD_ORDERING);
        return fields2;
    }

    private static Method[] getDeclaredMethods(TypeLiteral<?> type2) {
        Method[] methods2 = type2.getRawType().getDeclaredMethods();
        Arrays.sort(methods2, METHOD_ORDERING);
        return methods2;
    }

    private static boolean isEligibleForInjection(Method method, boolean statics) {
        return Modifier.isStatic(method.getModifiers()) == statics && !method.isBridge() && !method.isSynthetic();
    }

    private static boolean isValidMethod(InjectableMethod injectableMethod, Errors errors) {
        boolean result2 = true;
        if (injectableMethod.jsr330) {
            Method method = injectableMethod.method;
            if (Modifier.isAbstract(method.getModifiers())) {
                errors.cannotInjectAbstractMethod(method);
                result2 = false;
            }
            if (method.getTypeParameters().length > 0) {
                errors.cannotInjectMethodWithTypeParameters(method);
                result2 = false;
            }
        }
        return result2;
    }

    private static List<TypeLiteral<?>> hierarchyFor(TypeLiteral<?> type2) {
        ArrayList hierarchy = new ArrayList();
        TypeLiteral<?> current = type2;
        while (current.getRawType() != Object.class) {
            hierarchy.add(current);
            current = current.getSupertype(current.getRawType().getSuperclass());
        }
        return hierarchy;
    }

    private static boolean overrides(Method a, Method b) {
        int modifiers2 = b.getModifiers();
        if (Modifier.isPublic(modifiers2) || Modifier.isProtected(modifiers2)) {
            return true;
        }
        if (Modifier.isPrivate(modifiers2)) {
            return false;
        }
        return a.getDeclaringClass().getPackage().equals(b.getDeclaringClass().getPackage());
    }

    static class Signature {
        final String name;
        final Class[] parameterTypes;
        final int hash;

        Signature(Method method) {
            this.name = method.getName();
            this.parameterTypes = method.getParameterTypes();
            int h = this.name.hashCode();
            h = h * 31 + this.parameterTypes.length;
            for (Class parameterType : this.parameterTypes) {
                h = h * 31 + parameterType.hashCode();
            }
            this.hash = h;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Signature)) {
                return false;
            }
            Signature other = (Signature)o;
            if (!this.name.equals(other.name)) {
                return false;
            }
            if (this.parameterTypes.length != other.parameterTypes.length) {
                return false;
            }
            for (int i = 0; i < this.parameterTypes.length; ++i) {
                if (this.parameterTypes[i] == other.parameterTypes[i]) continue;
                return false;
            }
            return true;
        }
    }

    static class OverrideIndex {
        final InjectableMembers injectableMembers;
        Map<Signature, List<InjectableMethod>> bySignature;
        Position position = Position.TOP;
        Method lastMethod;
        Signature lastSignature;

        OverrideIndex(InjectableMembers injectableMembers) {
            this.injectableMembers = injectableMembers;
        }

        boolean removeIfOverriddenBy(Method method, boolean alwaysRemove, InjectableMethod injectableMethod) {
            if (this.position == Position.TOP) {
                return false;
            }
            if (this.bySignature == null) {
                this.bySignature = new HashMap<Signature, List<InjectableMethod>>();
                InjectableMember member2 = this.injectableMembers.head;
                while (member2 != null) {
                    InjectableMethod im;
                    if (member2 instanceof InjectableMethod && !(im = (InjectableMethod)member2).isFinal()) {
                        ArrayList<InjectableMethod> methods2 = new ArrayList<InjectableMethod>();
                        methods2.add(im);
                        this.bySignature.put(new Signature(im.method), methods2);
                    }
                    member2 = member2.next;
                }
            }
            this.lastMethod = method;
            Signature signature2 = this.lastSignature = new Signature(method);
            List<InjectableMethod> methods3 = this.bySignature.get(signature2);
            boolean removed2 = false;
            if (methods3 != null) {
                Iterator<InjectableMethod> iterator2 = methods3.iterator();
                while (iterator2.hasNext()) {
                    boolean wasGuiceInject;
                    InjectableMethod possiblyOverridden = iterator2.next();
                    if (!InjectionPoint.overrides(method, possiblyOverridden.method)) continue;
                    boolean bl = wasGuiceInject = !possiblyOverridden.jsr330 || possiblyOverridden.overrodeGuiceInject;
                    if (injectableMethod != null) {
                        injectableMethod.overrodeGuiceInject = wasGuiceInject;
                    }
                    if (!alwaysRemove && wasGuiceInject) continue;
                    removed2 = true;
                    iterator2.remove();
                    this.injectableMembers.remove(possiblyOverridden);
                }
            }
            return removed2;
        }

        void add(InjectableMethod injectableMethod) {
            this.injectableMembers.add(injectableMethod);
            if (this.position == Position.BOTTOM || injectableMethod.isFinal()) {
                return;
            }
            if (this.bySignature != null) {
                Signature signature2 = injectableMethod.method == this.lastMethod ? this.lastSignature : new Signature(injectableMethod.method);
                List<InjectableMethod> methods2 = this.bySignature.get(signature2);
                if (methods2 == null) {
                    methods2 = new ArrayList<InjectableMethod>();
                    this.bySignature.put(signature2, methods2);
                }
                methods2.add(injectableMethod);
            }
        }
    }

    static enum Position {
        TOP,
        MIDDLE,
        BOTTOM;

    }

    static class InjectableMembers {
        InjectableMember head;
        InjectableMember tail;

        InjectableMembers() {
        }

        void add(InjectableMember member2) {
            if (this.head == null) {
                this.head = this.tail = member2;
            } else {
                member2.previous = this.tail;
                this.tail.next = member2;
                this.tail = member2;
            }
        }

        void remove(InjectableMember member2) {
            if (member2.previous != null) {
                member2.previous.next = member2.next;
            }
            if (member2.next != null) {
                member2.next.previous = member2.previous;
            }
            if (this.head == member2) {
                this.head = member2.next;
            }
            if (this.tail == member2) {
                this.tail = member2.previous;
            }
        }

        boolean isEmpty() {
            return this.head == null;
        }
    }

    static class InjectableMethod
    extends InjectableMember {
        final Method method;
        boolean overrodeGuiceInject;

        InjectableMethod(TypeLiteral<?> declaringType, Method method, Annotation atInject) {
            super(declaringType, atInject);
            this.method = method;
        }

        @Override
        InjectionPoint toInjectionPoint() {
            return new InjectionPoint(this.declaringType, this.method, this.optional);
        }

        public boolean isFinal() {
            return Modifier.isFinal(this.method.getModifiers());
        }
    }

    static class InjectableField
    extends InjectableMember {
        final Field field;

        InjectableField(TypeLiteral<?> declaringType, Field field2, Annotation atInject) {
            super(declaringType, atInject);
            this.field = field2;
        }

        @Override
        InjectionPoint toInjectionPoint() {
            return new InjectionPoint(this.declaringType, this.field, this.optional);
        }
    }

    static abstract class InjectableMember {
        final TypeLiteral<?> declaringType;
        final boolean optional;
        final boolean jsr330;
        InjectableMember previous;
        InjectableMember next;

        InjectableMember(TypeLiteral<?> declaringType, Annotation atInject) {
            this.declaringType = declaringType;
            if (atInject.annotationType() == javax.inject.Inject.class) {
                this.optional = false;
                this.jsr330 = true;
                return;
            }
            this.jsr330 = false;
            this.optional = ((Inject)atInject).optional();
        }

        abstract InjectionPoint toInjectionPoint();
    }
}

