/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.inject.internal;

import java.lang.annotation.Annotation;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.inject.Scope;
import org.jetbrains.kotlin.com.google.inject.internal.AbstractProcessor;
import org.jetbrains.kotlin.com.google.inject.internal.Annotations;
import org.jetbrains.kotlin.com.google.inject.internal.Errors;
import org.jetbrains.kotlin.com.google.inject.spi.ScopeBinding;

final class ScopeBindingProcessor
extends AbstractProcessor {
    ScopeBindingProcessor(Errors errors) {
        super(errors);
    }

    @Override
    public Boolean visit(ScopeBinding command2) {
        ScopeBinding existing;
        Scope scope2 = Preconditions.checkNotNull(command2.getScope(), "scope");
        Class<? extends Annotation> annotationType = Preconditions.checkNotNull(command2.getAnnotationType(), "annotation type");
        if (!Annotations.isScopeAnnotation(annotationType)) {
            this.errors.missingScopeAnnotation(annotationType);
        }
        if (!Annotations.isRetainedAtRuntime(annotationType)) {
            this.errors.missingRuntimeRetention(annotationType);
        }
        if ((existing = this.injector.state.getScopeBinding(annotationType)) != null) {
            if (!scope2.equals(existing.getScope())) {
                this.errors.duplicateScopes(existing, annotationType, scope2);
            }
        } else {
            this.injector.state.putScopeBinding(annotationType, command2);
        }
        return true;
    }
}

