/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.inject.internal;

import org.jetbrains.kotlin.com.google.inject.internal.ConstructorInjector;
import org.jetbrains.kotlin.com.google.inject.internal.DefaultConstructionProxyFactory;
import org.jetbrains.kotlin.com.google.inject.internal.Errors;
import org.jetbrains.kotlin.com.google.inject.internal.ErrorsException;
import org.jetbrains.kotlin.com.google.inject.internal.FailableCache;
import org.jetbrains.kotlin.com.google.inject.internal.InjectorImpl;
import org.jetbrains.kotlin.com.google.inject.internal.MembersInjectorImpl;
import org.jetbrains.kotlin.com.google.inject.internal.SingleParameterInjector;
import org.jetbrains.kotlin.com.google.inject.spi.InjectionPoint;

final class ConstructorInjectorStore {
    private final InjectorImpl injector;
    private final FailableCache<InjectionPoint, ConstructorInjector<?>> cache = new FailableCache<InjectionPoint, ConstructorInjector<?>>(){

        @Override
        protected ConstructorInjector<?> create(InjectionPoint constructorInjector, Errors errors) throws ErrorsException {
            return ConstructorInjectorStore.this.createConstructor(constructorInjector, errors);
        }
    };

    ConstructorInjectorStore(InjectorImpl injector) {
        this.injector = injector;
    }

    public ConstructorInjector<?> get(InjectionPoint constructorInjector, Errors errors) throws ErrorsException {
        return this.cache.get(constructorInjector, errors);
    }

    boolean remove(InjectionPoint ip) {
        return this.cache.remove(ip);
    }

    private <T> ConstructorInjector<T> createConstructor(InjectionPoint injectionPoint, Errors errors) throws ErrorsException {
        int numErrorsBefore = errors.size();
        SingleParameterInjector<?>[] constructorParameterInjectors = this.injector.getParametersInjectors(injectionPoint.getDependencies(), errors);
        MembersInjectorImpl<?> membersInjector = this.injector.membersInjectorStore.get(injectionPoint.getDeclaringType(), errors);
        DefaultConstructionProxyFactory factory2 = new DefaultConstructionProxyFactory(injectionPoint);
        errors.throwIfNewErrors(numErrorsBefore);
        return new ConstructorInjector(membersInjector.getInjectionPoints(), factory2.create(), constructorParameterInjectors, membersInjector);
    }
}

