/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.primitives;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import org.jetbrains.kotlin.com.google.common.annotations.Beta;
import org.jetbrains.kotlin.com.google.common.annotations.GwtCompatible;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.primitives.Longs;

@Beta
@GwtCompatible
public final class ImmutableLongArray
implements Serializable {
    private static final ImmutableLongArray EMPTY = new ImmutableLongArray(new long[0]);
    private final long[] array;
    private final transient int start;
    private final int end;

    public static ImmutableLongArray of() {
        return EMPTY;
    }

    public static ImmutableLongArray of(long e0) {
        return new ImmutableLongArray(new long[]{e0});
    }

    public static ImmutableLongArray of(long e0, long e1) {
        return new ImmutableLongArray(new long[]{e0, e1});
    }

    public static ImmutableLongArray of(long e0, long e1, long e2) {
        return new ImmutableLongArray(new long[]{e0, e1, e2});
    }

    public static ImmutableLongArray of(long e0, long e1, long e2, long e3) {
        return new ImmutableLongArray(new long[]{e0, e1, e2, e3});
    }

    public static ImmutableLongArray of(long e0, long e1, long e2, long e3, long e4) {
        return new ImmutableLongArray(new long[]{e0, e1, e2, e3, e4});
    }

    public static ImmutableLongArray of(long e0, long e1, long e2, long e3, long e4, long e5) {
        return new ImmutableLongArray(new long[]{e0, e1, e2, e3, e4, e5});
    }

    public static ImmutableLongArray of(long first2, long ... rest) {
        Preconditions.checkArgument(rest.length <= 0x7FFFFFFE, "the total number of elements must fit in an int");
        long[] array2 = new long[rest.length + 1];
        array2[0] = first2;
        System.arraycopy(rest, 0, array2, 1, rest.length);
        return new ImmutableLongArray(array2);
    }

    public static ImmutableLongArray copyOf(long[] values2) {
        return values2.length == 0 ? EMPTY : new ImmutableLongArray(Arrays.copyOf(values2, values2.length));
    }

    public static ImmutableLongArray copyOf(Collection<Long> values2) {
        return values2.isEmpty() ? EMPTY : new ImmutableLongArray(Longs.toArray(values2));
    }

    public static ImmutableLongArray copyOf(Iterable<Long> values2) {
        if (values2 instanceof Collection) {
            return ImmutableLongArray.copyOf((Collection)values2);
        }
        return ImmutableLongArray.builder().addAll(values2).build();
    }

    public static Builder builder(int initialCapacity) {
        Preconditions.checkArgument(initialCapacity >= 0, "Invalid initialCapacity: %s", initialCapacity);
        return new Builder(initialCapacity);
    }

    public static Builder builder() {
        return new Builder(10);
    }

    private ImmutableLongArray(long[] array2) {
        this(array2, 0, array2.length);
    }

    private ImmutableLongArray(long[] array2, int start, int end) {
        this.array = array2;
        this.start = start;
        this.end = end;
    }

    public int length() {
        return this.end - this.start;
    }

    public boolean isEmpty() {
        return this.end == this.start;
    }

    public long get(int index2) {
        Preconditions.checkElementIndex(index2, this.length());
        return this.array[this.start + index2];
    }

    public int indexOf(long target) {
        for (int i = this.start; i < this.end; ++i) {
            if (this.array[i] != target) continue;
            return i - this.start;
        }
        return -1;
    }

    public int lastIndexOf(long target) {
        for (int i = this.end - 1; i >= this.start; --i) {
            if (this.array[i] != target) continue;
            return i - this.start;
        }
        return -1;
    }

    public boolean contains(long target) {
        return this.indexOf(target) >= 0;
    }

    public long[] toArray() {
        return Arrays.copyOfRange(this.array, this.start, this.end);
    }

    public ImmutableLongArray subArray(int startIndex, int endIndex) {
        Preconditions.checkPositionIndexes(startIndex, endIndex, this.length());
        return startIndex == endIndex ? EMPTY : new ImmutableLongArray(this.array, this.start + startIndex, this.start + endIndex);
    }

    public List<Long> asList() {
        return new AsList(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ImmutableLongArray)) {
            return false;
        }
        ImmutableLongArray that = (ImmutableLongArray)object;
        if (this.length() != that.length()) {
            return false;
        }
        for (int i = 0; i < this.length(); ++i) {
            if (this.get(i) == that.get(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 1;
        for (int i = this.start; i < this.end; ++i) {
            hash *= 31;
            hash += Longs.hashCode(this.array[i]);
        }
        return hash;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder builder2 = new StringBuilder(this.length() * 5);
        builder2.append('[').append(this.array[this.start]);
        for (int i = this.start + 1; i < this.end; ++i) {
            builder2.append(", ").append(this.array[i]);
        }
        builder2.append(']');
        return builder2.toString();
    }

    public ImmutableLongArray trimmed() {
        return this.isPartialView() ? new ImmutableLongArray(this.toArray()) : this;
    }

    private boolean isPartialView() {
        return this.start > 0 || this.end < this.array.length;
    }

    Object writeReplace() {
        return this.trimmed();
    }

    Object readResolve() {
        return this.isEmpty() ? EMPTY : this;
    }

    static class AsList
    extends AbstractList<Long>
    implements Serializable,
    RandomAccess {
        private final ImmutableLongArray parent;

        private AsList(ImmutableLongArray parent2) {
            this.parent = parent2;
        }

        @Override
        public int size() {
            return this.parent.length();
        }

        @Override
        public Long get(int index2) {
            return this.parent.get(index2);
        }

        @Override
        public boolean contains(Object target) {
            return this.indexOf(target) >= 0;
        }

        @Override
        public int indexOf(Object target) {
            return target instanceof Long ? this.parent.indexOf((Long)target) : -1;
        }

        @Override
        public int lastIndexOf(Object target) {
            return target instanceof Long ? this.parent.lastIndexOf((Long)target) : -1;
        }

        @Override
        public List<Long> subList(int fromIndex, int toIndex) {
            return this.parent.subArray(fromIndex, toIndex).asList();
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof AsList) {
                AsList that = (AsList)object;
                return this.parent.equals(that.parent);
            }
            if (!(object instanceof List)) {
                return false;
            }
            List that = (List)object;
            if (this.size() != that.size()) {
                return false;
            }
            int i = this.parent.start;
            for (Object element : that) {
                if (element instanceof Long && this.parent.array[i++] == (Long)element) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            return this.parent.hashCode();
        }

        @Override
        public String toString() {
            return this.parent.toString();
        }
    }

    public static final class Builder {
        private long[] array;
        private int count = 0;

        Builder(int initialCapacity) {
            this.array = new long[initialCapacity];
        }

        public Builder add(long value2) {
            this.ensureRoomFor(1);
            this.array[this.count] = value2;
            ++this.count;
            return this;
        }

        public Builder addAll(long[] values2) {
            this.ensureRoomFor(values2.length);
            System.arraycopy(values2, 0, this.array, this.count, values2.length);
            this.count += values2.length;
            return this;
        }

        public Builder addAll(Iterable<Long> values2) {
            if (values2 instanceof Collection) {
                return this.addAll((Collection)values2);
            }
            for (Long value2 : values2) {
                this.add(value2);
            }
            return this;
        }

        public Builder addAll(Collection<Long> values2) {
            this.ensureRoomFor(values2.size());
            for (Long value2 : values2) {
                this.array[this.count++] = value2;
            }
            return this;
        }

        public Builder addAll(ImmutableLongArray values2) {
            this.ensureRoomFor(values2.length());
            System.arraycopy(values2.array, values2.start, this.array, this.count, values2.length());
            this.count += values2.length();
            return this;
        }

        private void ensureRoomFor(int numberToAdd) {
            int newCount = this.count + numberToAdd;
            if (newCount > this.array.length) {
                long[] newArray = new long[Builder.expandedCapacity(this.array.length, newCount)];
                System.arraycopy(this.array, 0, newArray, 0, this.count);
                this.array = newArray;
            }
        }

        private static int expandedCapacity(int oldCapacity, int minCapacity) {
            if (minCapacity < 0) {
                throw new AssertionError((Object)"cannot store more than MAX_VALUE elements");
            }
            int newCapacity = oldCapacity + (oldCapacity >> 1) + 1;
            if (newCapacity < minCapacity) {
                newCapacity = Integer.highestOneBit(minCapacity - 1) << 1;
            }
            if (newCapacity < 0) {
                newCapacity = Integer.MAX_VALUE;
            }
            return newCapacity;
        }

        public ImmutableLongArray build() {
            return this.count == 0 ? EMPTY : new ImmutableLongArray(this.array, 0, this.count);
        }
    }
}

