/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.graph;

import org.jetbrains.kotlin.com.google.common.annotations.Beta;
import org.jetbrains.kotlin.com.google.common.base.Function;
import org.jetbrains.kotlin.com.google.common.base.Functions;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableMap;
import org.jetbrains.kotlin.com.google.common.collect.Maps;
import org.jetbrains.kotlin.com.google.common.graph.BaseGraph;
import org.jetbrains.kotlin.com.google.common.graph.ConfigurableValueGraph;
import org.jetbrains.kotlin.com.google.common.graph.DirectedGraphConnections;
import org.jetbrains.kotlin.com.google.common.graph.ForwardingGraph;
import org.jetbrains.kotlin.com.google.common.graph.Graph;
import org.jetbrains.kotlin.com.google.common.graph.GraphBuilder;
import org.jetbrains.kotlin.com.google.common.graph.GraphConnections;
import org.jetbrains.kotlin.com.google.common.graph.GraphConstants;
import org.jetbrains.kotlin.com.google.common.graph.UndirectedGraphConnections;

@Beta
public class ImmutableGraph<N>
extends ForwardingGraph<N> {
    private final BaseGraph<N> backingGraph;

    ImmutableGraph(BaseGraph<N> backingGraph) {
        this.backingGraph = backingGraph;
    }

    public static <N> ImmutableGraph<N> copyOf(Graph<N> graph2) {
        return graph2 instanceof ImmutableGraph ? (ImmutableGraph<N>)graph2 : new ImmutableGraph<N>(new ConfigurableValueGraph<N, GraphConstants.Presence>(GraphBuilder.from(graph2), ImmutableGraph.getNodeConnections(graph2), graph2.edges().size()));
    }

    @Deprecated
    public static <N> ImmutableGraph<N> copyOf(ImmutableGraph<N> graph2) {
        return Preconditions.checkNotNull(graph2);
    }

    private static <N> ImmutableMap<N, GraphConnections<N, GraphConstants.Presence>> getNodeConnections(Graph<N> graph2) {
        ImmutableMap.Builder<N, GraphConnections<N, GraphConstants.Presence>> nodeConnections = ImmutableMap.builder();
        for (N node : graph2.nodes()) {
            nodeConnections.put(node, ImmutableGraph.connectionsOf(graph2, node));
        }
        return nodeConnections.build();
    }

    private static <N> GraphConnections<N, GraphConstants.Presence> connectionsOf(Graph<N> graph2, N node) {
        Function<Object, GraphConstants.Presence> edgeValueFn = Functions.constant(GraphConstants.Presence.EDGE_EXISTS);
        return graph2.isDirected() ? DirectedGraphConnections.ofImmutable(graph2.predecessors((Object)node), Maps.asMap(graph2.successors((Object)node), edgeValueFn)) : UndirectedGraphConnections.ofImmutable(Maps.asMap(graph2.adjacentNodes(node), edgeValueFn));
    }

    @Override
    protected BaseGraph<N> delegate() {
        return this.backingGraph;
    }
}

