/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.stub;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.stub.CallableClsStubBuilderKt;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClassClsStubBuilderKt;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClassIdWithTarget;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuilderComponents;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuilderContext;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuildingKt;
import org.jetbrains.kotlin.analysis.decompiler.stub.flags.FlagsToModifiers;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.util.io.StringRef;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.load.kotlin.JvmPackagePartSource;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.deserialization.TypeTable;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmNameResolver;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmProtoBufUtil;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.protobuf.MessageLite;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.stubs.KotlinUserTypeStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinAnnotationEntryStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinAnnotationUseSiteTargetStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFileStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinModifierListStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinNameReferenceExpressionStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinPlaceHolderStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinStubBaseImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinUserTypeStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.ModifierMaskUtils;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.serialization.deserialization.AnnotatedCallableKind;
import org.jetbrains.kotlin.serialization.deserialization.ProtoContainer;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u00bc\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b\u001a\u0012\u0010\f\u001a\u00020\r2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b\u001a\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u0016\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u0006\u0010\u001a\u001a\u00020\u000f\u001a&\u0010\u001b\u001a\u0004\u0018\u00010\r2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f\u001a>\u0010!\u001a\u00020\r2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001c2\u0006\u0010\"\u001a\u00020#2\u000e\b\u0002\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\b2\u000e\b\u0002\u0010&\u001a\b\u0012\u0004\u0012\u00020 0\b\u001a,\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010,\u001a\u00020-\u001a\u001e\u0010.\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u001c\u0010/\u001a\u00020\u00062\f\u00100\u001a\b\u0012\u0004\u0012\u000202012\u0006\u0010\u0017\u001a\u00020\u0013\u001a:\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001c2\u001a\b\u0002\u00106\u001a\u0014\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u000607\u001a \u00108\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002090\b2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b\u001a0\u0010:\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020\t2\u0006\u0010<\u001a\u00020=2\b\u0010>\u001a\u0004\u0018\u00010?2\u0006\u0010@\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u0018\u0010A\u001a\u00020\u00062\u0006\u0010B\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0013H\u0002\u001a\n\u0010C\u001a\u00020D*\u00020\u0013\u001a\n\u0010C\u001a\u00020D*\u00020E\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006F"}, d2={"annotatedCallableKind", "Lorg/jetbrains/kotlin/serialization/deserialization/AnnotatedCallableKind;", "Lorg/jetbrains/kotlin/protobuf/MessageLite;", "getAnnotatedCallableKind", "(Lorg/jetbrains/kotlin/protobuf/MessageLite;)Lorg/jetbrains/kotlin/serialization/deserialization/AnnotatedCallableKind;", "createAnnotationStubs", "", "annotationIds", "", "Lorg/jetbrains/kotlin/name/ClassId;", "parent", "Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinStubBaseImpl;", "createEmptyModifierListStub", "Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinModifierListStubImpl;", "createFileFacadeStub", "Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinFileStubImpl;", "packageProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Package;", "facadeFqName", "Lorg/jetbrains/kotlin/name/FqName;", "c", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/ClsStubBuilderContext;", "createFileStub", "packageFqName", "isScript", "", "createIncompatibleAbiVersionFileStub", "createModifierListStub", "Lorg/jetbrains/kotlin/com/intellij/psi/stubs/StubElement;", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "modifiers", "", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "createModifierListStubForDeclaration", "flags", "", "flagsToTranslate", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/flags/FlagsToModifiers;", "additionalModifiers", "createMultifileClassStub", "header", "Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader;", "partFiles", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;", "components", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/ClsStubBuilderComponents;", "createPackageFacadeStub", "createStubForPackageName", "packageDirectiveStub", "Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinPlaceHolderStubImpl;", "Lorg/jetbrains/kotlin/psi/KtPackageDirective;", "createStubForTypeName", "Lorg/jetbrains/kotlin/psi/stubs/KotlinUserTypeStub;", "typeClassId", "bindTypeArguments", "Lkotlin/Function2;", "createTargetedAnnotationStubs", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/ClassIdWithTarget;", "createTopLevelClassStub", "classId", "classProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class;", "source", "Lorg/jetbrains/kotlin/descriptors/SourceElement;", "context", "setupFileStub", "fileStub", "ref", "Lorg/jetbrains/kotlin/com/intellij/util/io/StringRef;", "Lorg/jetbrains/kotlin/name/Name;", "decompiler-to-stubs"})
public final class ClsStubBuildingKt {
    @NotNull
    public static final KotlinFileStubImpl createTopLevelClassStub(@NotNull ClassId classId, @NotNull ProtoBuf.Class classProto, @Nullable SourceElement source, @NotNull ClsStubBuilderContext context, boolean isScript) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        Intrinsics.checkNotNullParameter(classProto, "classProto");
        Intrinsics.checkNotNullParameter(context, "context");
        FqName fqName2 = classId.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue(fqName2, "classId.packageFqName");
        KotlinFileStubImpl fileStub = ClsStubBuildingKt.createFileStub(fqName2, isScript);
        ClassClsStubBuilderKt.createClassStub(fileStub, classProto, context.getNameResolver(), classId, source, context);
        return fileStub;
    }

    @NotNull
    public static final KotlinFileStubImpl createPackageFacadeStub(@NotNull ProtoBuf.Package packageProto, @NotNull FqName packageFqName, @NotNull ClsStubBuilderContext c) {
        Intrinsics.checkNotNullParameter(packageProto, "packageProto");
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(c, "c");
        KotlinFileStubImpl fileStub = KotlinFileStubImpl.Companion.forFile(packageFqName, false);
        ClsStubBuildingKt.setupFileStub(fileStub, packageFqName);
        CallableClsStubBuilderKt.createPackageDeclarationsStubs(fileStub, c, new ProtoContainer.Package(packageFqName, c.getNameResolver(), c.getTypeTable(), null), packageProto);
        return fileStub;
    }

    @NotNull
    public static final KotlinFileStubImpl createFileFacadeStub(@NotNull ProtoBuf.Package packageProto, @NotNull FqName facadeFqName, @NotNull ClsStubBuilderContext c) {
        Intrinsics.checkNotNullParameter(packageProto, "packageProto");
        Intrinsics.checkNotNullParameter(facadeFqName, "facadeFqName");
        Intrinsics.checkNotNullParameter(c, "c");
        FqName fqName2 = facadeFqName.parent();
        Intrinsics.checkNotNullExpressionValue(fqName2, "facadeFqName.parent()");
        FqName packageFqName = fqName2;
        KotlinFileStubImpl fileStub = KotlinFileStubImpl.Companion.forFileFacadeStub(facadeFqName);
        ClsStubBuildingKt.setupFileStub(fileStub, packageFqName);
        NameResolver nameResolver2 = c.getNameResolver();
        TypeTable typeTable = c.getTypeTable();
        JvmClassName jvmClassName = JvmClassName.byClassId(ClassId.topLevel(facadeFqName));
        Intrinsics.checkNotNullExpressionValue(jvmClassName, "byClassId(ClassId.topLevel(facadeFqName))");
        ProtoContainer.Package container = new ProtoContainer.Package(packageFqName, nameResolver2, typeTable, new JvmPackagePartSource(jvmClassName, null, packageProto, c.getNameResolver(), null, false, null, null, 240, null));
        CallableClsStubBuilderKt.createPackageDeclarationsStubs(fileStub, c, container, packageProto);
        return fileStub;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KotlinFileStubImpl createMultifileClassStub(@NotNull KotlinClassHeader header, @NotNull List<? extends KotlinJvmBinaryClass> partFiles, @NotNull FqName facadeFqName, @NotNull ClsStubBuilderComponents components2) {
        List list2;
        Object object;
        FqName fqName2;
        Intrinsics.checkNotNullParameter(header, "header");
        Intrinsics.checkNotNullParameter(partFiles, "partFiles");
        Intrinsics.checkNotNullParameter(facadeFqName, "facadeFqName");
        Intrinsics.checkNotNullParameter(components2, "components");
        String string2 = header.getPackageName();
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            fqName2 = new FqName(string3);
        } else {
            FqName fqName3 = facadeFqName.parent();
            fqName2 = fqName3;
            Intrinsics.checkNotNullExpressionValue(fqName3, "facadeFqName.parent()");
        }
        FqName packageFqName = fqName2;
        Object object2 = header.getData();
        if (object2 != null && (object2 = ArraysKt.asList(object2)) != null) {
            void $this$mapTo$iv$iv;
            Iterable iterable = (Iterable)object2;
            boolean $i$f$map = false;
            object = iterable;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string4 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(StringsKt.substringAfterLast$default((String)it, '/', null, 2, null));
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = null;
        }
        List partNames = list2;
        KotlinFileStubImpl fileStub = KotlinFileStubImpl.Companion.forMultifileClassStub(packageFqName, facadeFqName, partNames);
        ClsStubBuildingKt.setupFileStub(fileStub, packageFqName);
        for (KotlinJvmBinaryClass kotlinJvmBinaryClass2 : partFiles) {
            KotlinClassHeader partHeader = kotlinJvmBinaryClass2.getClassHeader();
            String[] stringArray = partHeader.getData();
            Intrinsics.checkNotNull(stringArray);
            String[] stringArray2 = partHeader.getStrings();
            Intrinsics.checkNotNull(stringArray2);
            object = JvmProtoBufUtil.readPackageDataFrom(stringArray, stringArray2);
            JvmNameResolver nameResolver2 = (JvmNameResolver)((Pair)object).component1();
            ProtoBuf.Package packageProto = (ProtoBuf.Package)((Pair)object).component2();
            NameResolver nameResolver3 = nameResolver2;
            ProtoBuf.TypeTable typeTable = packageProto.getTypeTable();
            Intrinsics.checkNotNullExpressionValue(typeTable, "packageProto.typeTable");
            ClsStubBuilderContext partContext = components2.createContext(nameResolver3, packageFqName, new TypeTable(typeTable));
            ProtoContainer.Package container = new ProtoContainer.Package(packageFqName, partContext.getNameResolver(), partContext.getTypeTable(), new JvmPackagePartSource(kotlinJvmBinaryClass2, packageProto, nameResolver2, null, false, null, 56, null));
            CallableClsStubBuilderKt.createPackageDeclarationsStubs(fileStub, partContext, container, packageProto);
        }
        return fileStub;
    }

    @NotNull
    public static final KotlinFileStubImpl createIncompatibleAbiVersionFileStub() {
        FqName fqName2 = FqName.ROOT;
        Intrinsics.checkNotNullExpressionValue(fqName2, "ROOT");
        return ClsStubBuildingKt.createFileStub(fqName2, false);
    }

    @NotNull
    public static final KotlinFileStubImpl createFileStub(@NotNull FqName packageFqName, boolean isScript) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        KotlinFileStubImpl fileStub = KotlinFileStubImpl.Companion.forFile(packageFqName, isScript);
        ClsStubBuildingKt.setupFileStub(fileStub, packageFqName);
        return fileStub;
    }

    private static final void setupFileStub(KotlinFileStubImpl fileStub, FqName packageFqName) {
        KotlinPlaceHolderStubImpl<KtPackageDirective> packageDirectiveStub = new KotlinPlaceHolderStubImpl<KtPackageDirective>((StubElement)fileStub, KtStubElementTypes.PACKAGE_DIRECTIVE);
        ClsStubBuildingKt.createStubForPackageName(packageDirectiveStub, packageFqName);
        new KotlinPlaceHolderStubImpl((StubElement)fileStub, KtStubElementTypes.IMPORT_LIST);
    }

    public static final void createStubForPackageName(@NotNull KotlinPlaceHolderStubImpl<KtPackageDirective> packageDirectiveStub, @NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter(packageDirectiveStub, "packageDirectiveStub");
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        List<Name> list2 = packageFqName.pathSegments();
        Intrinsics.checkNotNullExpressionValue(list2, "packageFqName.pathSegments()");
        List<Name> segments2 = list2;
        ListIterator<Name> iterator2 = segments2.listIterator(segments2.size());
        ClsStubBuildingKt.createStubForPackageName$recCreateStubForPackageName(iterator2, (StubElement<? extends PsiElement>)packageDirectiveStub);
    }

    @NotNull
    public static final KotlinUserTypeStub createStubForTypeName(@NotNull ClassId typeClassId, @NotNull StubElement<? extends PsiElement> parent2, @NotNull Function2<? super KotlinUserTypeStub, ? super Integer, Unit> bindTypeArguments) {
        boolean bl;
        FqNameUnsafe fqNameUnsafe;
        Intrinsics.checkNotNullParameter(typeClassId, "typeClassId");
        Intrinsics.checkNotNullParameter(parent2, "parent");
        Intrinsics.checkNotNullParameter(bindTypeArguments, "bindTypeArguments");
        boolean substituteWithAny = typeClassId.isLocal();
        if (substituteWithAny) {
            fqNameUnsafe = StandardNames.FqNames.any;
        } else {
            FqNameUnsafe fqNameUnsafe2 = typeClassId.asSingleFqName().toUnsafe();
            fqNameUnsafe = fqNameUnsafe2;
            Intrinsics.checkNotNullExpressionValue(fqNameUnsafe2, "typeClassId.asSingleFqName().toUnsafe()");
        }
        FqNameUnsafe fqName2 = fqNameUnsafe;
        List<Name> list2 = fqName2.pathSegments();
        Intrinsics.checkNotNullExpressionValue(list2, "fqName.pathSegments()");
        List<Name> segments2 = CollectionsKt.asReversedMutable(list2);
        boolean bl2 = bl = !((Collection)segments2).isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return ClsStubBuildingKt.createStubForTypeName$recCreateStubForType(segments2, substituteWithAny, bindTypeArguments, parent2, 0);
    }

    public static /* synthetic */ KotlinUserTypeStub createStubForTypeName$default(ClassId classId, StubElement stubElement, Function2 function2, int n, Object object) {
        if ((n & 4) != 0) {
            function2 = createStubForTypeName.1.INSTANCE;
        }
        return ClsStubBuildingKt.createStubForTypeName(classId, stubElement, function2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KotlinModifierListStubImpl createModifierListStubForDeclaration(@NotNull StubElement<? extends PsiElement> parent2, int flags, @NotNull List<? extends FlagsToModifiers> flagsToTranslate, @NotNull List<KtModifierKeywordToken> additionalModifiers) {
        void $this$mapNotNullTo$iv$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter(parent2, "parent");
        Intrinsics.checkNotNullParameter(flagsToTranslate, "flagsToTranslate");
        Intrinsics.checkNotNullParameter(additionalModifiers, "additionalModifiers");
        boolean bl2 = bl = !((Collection)flagsToTranslate).isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        Iterable $this$mapNotNull$iv = flagsToTranslate;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KtModifierKeywordToken it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl3 = false;
            FlagsToModifiers it = (FlagsToModifiers)element$iv$iv;
            boolean bl4 = false;
            if (it.getModifiers(flags) == null) continue;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List modifiers2 = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)additionalModifiers);
        KotlinModifierListStubImpl kotlinModifierListStubImpl = ClsStubBuildingKt.createModifierListStub(parent2, modifiers2);
        Intrinsics.checkNotNull(kotlinModifierListStubImpl);
        return kotlinModifierListStubImpl;
    }

    public static /* synthetic */ KotlinModifierListStubImpl createModifierListStubForDeclaration$default(StubElement stubElement, int n, List list2, List list3, int n2, Object object) {
        if ((n2 & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n2 & 8) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        return ClsStubBuildingKt.createModifierListStubForDeclaration(stubElement, n, list2, list3);
    }

    @Nullable
    public static final KotlinModifierListStubImpl createModifierListStub(@NotNull StubElement<? extends PsiElement> parent2, @NotNull Collection<KtModifierKeywordToken> modifiers2) {
        Intrinsics.checkNotNullParameter(parent2, "parent");
        Intrinsics.checkNotNullParameter(modifiers2, "modifiers");
        if (modifiers2.isEmpty()) {
            return null;
        }
        return new KotlinModifierListStubImpl(parent2, ModifierMaskUtils.computeMask((Function1<? super KtModifierKeywordToken, Boolean>)new Function1<KtModifierKeywordToken, Boolean>(modifiers2){
            final /* synthetic */ Collection<KtModifierKeywordToken> $modifiers;
            {
                this.$modifiers = $modifiers;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KtModifierKeywordToken it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.$modifiers.contains(it);
            }
        }), KtStubElementTypes.MODIFIER_LIST);
    }

    @NotNull
    public static final KotlinModifierListStubImpl createEmptyModifierListStub(@NotNull KotlinStubBaseImpl<?> parent2) {
        Intrinsics.checkNotNullParameter(parent2, "parent");
        return new KotlinModifierListStubImpl(parent2, ModifierMaskUtils.computeMask(createEmptyModifierListStub.1.INSTANCE), KtStubElementTypes.MODIFIER_LIST);
    }

    /*
     * WARNING - void declaration
     */
    public static final void createAnnotationStubs(@NotNull List<ClassId> annotationIds, @NotNull KotlinStubBaseImpl<?> parent2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(annotationIds, "annotationIds");
        Intrinsics.checkNotNullParameter(parent2, "parent");
        Iterable $this$map$iv = annotationIds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ClassId classId = (ClassId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ClassIdWithTarget((ClassId)it, null));
        }
        ClsStubBuildingKt.createTargetedAnnotationStubs((List)destination$iv$iv, parent2);
    }

    public static final void createTargetedAnnotationStubs(@NotNull List<ClassIdWithTarget> annotationIds, @NotNull KotlinStubBaseImpl<?> parent2) {
        Intrinsics.checkNotNullParameter(annotationIds, "annotationIds");
        Intrinsics.checkNotNullParameter(parent2, "parent");
        if (annotationIds.isEmpty()) {
            return;
        }
        Iterable $this$forEach$iv = annotationIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClassIdWithTarget annotation2 = (ClassIdWithTarget)element$iv;
            boolean bl = false;
            ClassId annotationClassId = annotation2.component1();
            AnnotationUseSiteTarget target = annotation2.component2();
            StubElement stubElement = parent2;
            Name name2 = annotationClassId.getShortClassName();
            Intrinsics.checkNotNullExpressionValue(name2, "annotationClassId.shortClassName");
            KotlinAnnotationEntryStubImpl annotationEntryStubImpl = new KotlinAnnotationEntryStubImpl(stubElement, ClsStubBuildingKt.ref(name2), false);
            if (target != null) {
                StubElement stubElement2 = annotationEntryStubImpl;
                StringRef stringRef = StringRef.fromString(target.name());
                Intrinsics.checkNotNull(stringRef);
                new KotlinAnnotationUseSiteTargetStubImpl((StubElement<? extends PsiElement>)stubElement2, stringRef);
            }
            KotlinPlaceHolderStubImpl constructorCallee = new KotlinPlaceHolderStubImpl((StubElement)annotationEntryStubImpl, KtStubElementTypes.CONSTRUCTOR_CALLEE);
            KotlinPlaceHolderStubImpl typeReference = new KotlinPlaceHolderStubImpl((StubElement)constructorCallee, KtStubElementTypes.TYPE_REFERENCE);
            ClsStubBuildingKt.createStubForTypeName$default(annotationClassId, typeReference, null, 4, null);
        }
    }

    @NotNull
    public static final AnnotatedCallableKind getAnnotatedCallableKind(@NotNull MessageLite $this$annotatedCallableKind) {
        AnnotatedCallableKind annotatedCallableKind;
        Intrinsics.checkNotNullParameter($this$annotatedCallableKind, "<this>");
        MessageLite messageLite = $this$annotatedCallableKind;
        if (messageLite instanceof ProtoBuf.Property) {
            annotatedCallableKind = AnnotatedCallableKind.PROPERTY;
        } else if (messageLite instanceof ProtoBuf.Function ? true : messageLite instanceof ProtoBuf.Constructor) {
            annotatedCallableKind = AnnotatedCallableKind.FUNCTION;
        } else {
            throw new IllegalStateException("Unsupported message: " + $this$annotatedCallableKind);
        }
        return annotatedCallableKind;
    }

    @NotNull
    public static final StringRef ref(@NotNull Name $this$ref) {
        Intrinsics.checkNotNullParameter($this$ref, "<this>");
        StringRef stringRef = StringRef.fromString($this$ref.asString());
        Intrinsics.checkNotNull(stringRef);
        return stringRef;
    }

    @NotNull
    public static final StringRef ref(@NotNull FqName $this$ref) {
        Intrinsics.checkNotNullParameter($this$ref, "<this>");
        StringRef stringRef = StringRef.fromString($this$ref.asString());
        Intrinsics.checkNotNull(stringRef);
        return stringRef;
    }

    private static final void createStubForPackageName$recCreateStubForPackageName(ListIterator<Name> iterator2, StubElement<? extends PsiElement> current) {
        switch (iterator2.previousIndex()) {
            case -1: {
                return;
            }
            case 0: {
                Name name2 = iterator2.previous();
                Intrinsics.checkNotNullExpressionValue(name2, "iterator.previous()");
                new KotlinNameReferenceExpressionStubImpl(current, ClsStubBuildingKt.ref(name2));
                return;
            }
        }
        Name lastSegment = iterator2.previous();
        KotlinPlaceHolderStubImpl receiver = new KotlinPlaceHolderStubImpl((StubElement)current, (IStubElementType)KtStubElementTypes.DOT_QUALIFIED_EXPRESSION);
        ClsStubBuildingKt.createStubForPackageName$recCreateStubForPackageName(iterator2, receiver);
        StubElement stubElement = receiver;
        Intrinsics.checkNotNullExpressionValue(lastSegment, "lastSegment");
        new KotlinNameReferenceExpressionStubImpl(stubElement, ClsStubBuildingKt.ref(lastSegment));
    }

    private static final KotlinUserTypeStub createStubForTypeName$recCreateStubForType(List<Name> segments2, boolean substituteWithAny, Function2<? super KotlinUserTypeStub, ? super Integer, Unit> $bindTypeArguments, StubElement<? extends PsiElement> current, int level) {
        Name lastSegment = segments2.get(level);
        KotlinUserTypeStubImpl userTypeStub = new KotlinUserTypeStubImpl(current);
        if (level + 1 < segments2.size()) {
            ClsStubBuildingKt.createStubForTypeName$recCreateStubForType(segments2, substituteWithAny, $bindTypeArguments, userTypeStub, level + 1);
        }
        StubElement stubElement = userTypeStub;
        Intrinsics.checkNotNullExpressionValue(lastSegment, "lastSegment");
        new KotlinNameReferenceExpressionStubImpl(stubElement, ClsStubBuildingKt.ref(lastSegment));
        if (!substituteWithAny) {
            $bindTypeArguments.invoke(userTypeStub, (Integer)level);
        }
        return userTypeStub;
    }
}

