/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.name;

import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CallableId {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final FqName packageName;
    @Nullable
    private final FqName className;
    @NotNull
    private final Name callableName;
    @Nullable
    private final FqName pathToLocal;
    @Deprecated
    @NotNull
    private static final Name LOCAL_NAME = SpecialNames.LOCAL;
    @Deprecated
    @NotNull
    private static final FqName PACKAGE_FQ_NAME_FOR_LOCAL;

    public CallableId(@NotNull FqName packageName, @Nullable FqName className2, @NotNull Name callableName, @Nullable FqName pathToLocal) {
        Intrinsics.checkNotNullParameter(packageName, "packageName");
        Intrinsics.checkNotNullParameter(callableName, "callableName");
        this.packageName = packageName;
        this.className = className2;
        this.callableName = callableName;
        this.pathToLocal = pathToLocal;
    }

    public /* synthetic */ CallableId(FqName fqName2, FqName fqName3, Name name2, FqName fqName4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            fqName4 = null;
        }
        this(fqName2, fqName3, name2, fqName4);
    }

    public CallableId(@NotNull FqName packageName, @NotNull Name callableName) {
        Intrinsics.checkNotNullParameter(packageName, "packageName");
        Intrinsics.checkNotNullParameter(callableName, "callableName");
        this(packageName, null, callableName, null, 8, null);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder2;
        StringBuilder $this$toString_u24lambda_u2d0 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        String string2 = this.packageName.asString();
        Intrinsics.checkNotNullExpressionValue(string2, "packageName.asString()");
        $this$toString_u24lambda_u2d0.append(StringsKt.replace$default(string2, '.', '/', false, 4, null));
        $this$toString_u24lambda_u2d0.append("/");
        if (this.className != null) {
            $this$toString_u24lambda_u2d0.append(this.className);
            $this$toString_u24lambda_u2d0.append(".");
        }
        $this$toString_u24lambda_u2d0.append(this.callableName);
        String string3 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "StringBuilder().apply(builderAction).toString()");
        return string3;
    }

    public int hashCode() {
        int result2 = this.packageName.hashCode();
        result2 = result2 * 31 + (this.className == null ? 0 : this.className.hashCode());
        result2 = result2 * 31 + this.callableName.hashCode();
        result2 = result2 * 31 + (this.pathToLocal == null ? 0 : this.pathToLocal.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CallableId)) {
            return false;
        }
        CallableId callableId = (CallableId)other;
        if (!Intrinsics.areEqual(this.packageName, callableId.packageName)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.className, callableId.className)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.callableName, callableId.callableName)) {
            return false;
        }
        return Intrinsics.areEqual(this.pathToLocal, callableId.pathToLocal);
    }

    static {
        FqName fqName2 = FqName.topLevel(LOCAL_NAME);
        Intrinsics.checkNotNullExpressionValue(fqName2, "topLevel(LOCAL_NAME)");
        PACKAGE_FQ_NAME_FOR_LOCAL = fqName2;
    }

    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

