/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.packagers;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.MacportsPackager;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.spi.packagers.PackagerProcessingException;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.Templates;
import org.jreleaser.packagers.AbstractRepositoryPackagerProcessor;
import org.jreleaser.templates.TemplateUtils;

public class MacportsPackagerProcessor
extends AbstractRepositoryPackagerProcessor<MacportsPackager> {
    private static final String LINE_SEPARATOR = " \\\n                 ";

    public MacportsPackagerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, Map<String, Object> props, Path packageDirectory) throws PackagerProcessingException {
        super.doPackageDistribution(distribution, props, packageDirectory);
        this.copyPreparedFiles(distribution, props);
    }

    @Override
    protected void fillPackagerProperties(Map<String, Object> props, Distribution distribution) throws PackagerProcessingException {
        String artifactFile;
        String distributionUrl;
        BaseReleaser releaser = this.context.getModel().getRelease().getReleaser();
        props.put("macportsRepositoryRepoUrl", releaser.getResolvedRepoUrl(this.context.getModel(), ((MacportsPackager)this.packager).getRepository().getOwner(), ((MacportsPackager)this.packager).getRepository().getResolvedName()));
        props.put("macportsRepositoryRepoCloneUrl", releaser.getResolvedRepoCloneUrl(this.context.getModel(), ((MacportsPackager)this.packager).getRepository().getOwner(), ((MacportsPackager)this.packager).getRepository().getResolvedName()));
        List<String> longDescription = Arrays.asList(this.context.getModel().getProject().getLongDescription().split("\\n"));
        props.put("macportsPackageName", ((MacportsPackager)this.packager).getPackageName());
        props.put("macportsRevision", ((MacportsPackager)this.packager).getRevision());
        props.put("macportsCategories", String.join((CharSequence)" ", ((MacportsPackager)this.packager).getCategories()));
        props.put("macportsMaintainers", MustacheUtils.passThrough((String)String.join((CharSequence)LINE_SEPARATOR, ((MacportsPackager)this.packager).getResolvedMaintainers(this.context))));
        props.put("projectLongDescription", MustacheUtils.passThrough((String)String.join((CharSequence)LINE_SEPARATOR, longDescription)));
        if (distribution.getType() == Distribution.DistributionType.JAVA_BINARY) {
            props.put("macportsJavaVersion", this.resolveJavaVersion(distribution));
        }
        if (((MacportsPackager)this.packager).getExtraProperties().containsKey("appName")) {
            props.put("macportsAppName", Templates.resolveTemplate((String)((MacportsPackager)this.packager).getExtraProperty("appName"), props));
        }
        if ((distributionUrl = (String)props.get("distributionUrl")).endsWith(artifactFile = (String)props.get("distributionArtifactFile"))) {
            distributionUrl = distributionUrl.substring(0, distributionUrl.length() - artifactFile.length() - 1);
        }
        distributionUrl = distributionUrl.replace(this.context.getModel().getProject().getEffectiveVersion(), "${version}");
        props.put("macportsDistributionUrl", distributionUrl);
        String artifactFileName = (String)props.get("distributionArtifactFileName");
        String artifactName = (String)props.get("distributionArtifactName");
        String artifactVersion = (String)props.get("distributionArtifactVersion");
        props.put("macportsDistname", artifactFileName.replace(artifactName, "${name}").replace(artifactVersion, "${version}"));
    }

    private String resolveJavaVersion(Distribution distribution) {
        String version = distribution.getJava().getVersion();
        if ("8".equals(version)) {
            return "1.8+";
        }
        try {
            Integer.parseInt(version);
            return version + "+";
        }
        catch (NumberFormatException numberFormatException) {
            return version;
        }
    }

    @Override
    protected void writeFile(Project project, Distribution distribution, String content, Map<String, Object> props, Path outputDirectory, String fileName) throws PackagerProcessingException {
        Path outputFile = "Portfile".equals(fileName = TemplateUtils.trimTplExtension((String)fileName)) ? outputDirectory.resolve("ports").resolve((String)((MacportsPackager)this.packager).getCategories().get(0)).resolve(((MacportsPackager)this.packager).getPackageName()).resolve(fileName) : outputDirectory.resolve(fileName);
        this.writeFile(content, outputFile);
    }
}

