/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.extensions.internal.mustache;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.text.StringEscapeUtils;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;
import org.jreleaser.bundle.RB;
import org.jreleaser.extensions.api.mustache.MustacheExtensionPoint;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.util.Algorithm;
import org.jreleaser.util.ChecksumUtils;
import org.jreleaser.util.StringUtils;

public final class DefaultMustacheExtensionPoint
implements MustacheExtensionPoint {
    public void apply(Map<String, Object> context) {
        ZonedDateTime now = (ZonedDateTime)context.get("__ZonedDateTime_now__");
        if (null == now) {
            now = ZonedDateTime.now();
        }
        context.put("f_now", new TimeFormatFunction(now));
        context.put("f_now_gmt", new TimeFormatFunction(now.withZoneSameInstant(ZoneId.of("GMT"))));
        context.put("f_trim", new TrimFunction());
        context.put("f_underscore", new UnderscoreFunction());
        context.put("f_dash", new DashFunction());
        context.put("f_slash", new SlashFunction());
        context.put("f_upper", new UpperFunction());
        context.put("f_lower", new LowerFunction());
        context.put("f_capitalize", new CapitalizeFunction());
        context.put("f_uncapitalize", new UncapitalizeFunction());
        context.put("f_md2html", new MarkdownToHtmlFunction());
        context.put("f_file_read", new FileReadFunction());
        context.put("f_file_size", new FileSizeFunction());
        EnumSet.allOf(Algorithm.class).forEach(algorithm -> context.put("f_checksum_" + algorithm.formatted(), new FileChecksumFunction((Algorithm)algorithm)));
        context.put("f_json", new JsonFunction());
        context.put("f_escape_csv", new DelegatingFunction(StringEscapeUtils::escapeCsv));
        context.put("f_escape_ecma_script", new DelegatingFunction(StringEscapeUtils::escapeEcmaScript));
        context.put("f_escape_html3", new DelegatingFunction(StringEscapeUtils::escapeHtml3));
        context.put("f_escape_html4", new DelegatingFunction(StringEscapeUtils::escapeHtml4));
        context.put("f_escape_java", new DelegatingFunction(StringEscapeUtils::escapeJava));
        context.put("f_escape_json", new DelegatingFunction(StringEscapeUtils::escapeJson));
        context.put("f_escape_xml10", new DelegatingFunction(StringEscapeUtils::escapeXml10));
        context.put("f_escape_xml11", new DelegatingFunction(StringEscapeUtils::escapeXml11));
        context.put("f_escape_xsi", new DelegatingFunction(StringEscapeUtils::escapeXSI));
        context.put("f_chop", new DelegatingFunction(org.apache.commons.lang3.StringUtils::chop));
        context.put("f_delete_whitespace", new DelegatingFunction(org.apache.commons.lang3.StringUtils::deleteWhitespace));
        context.put("f_normalize_whitespace", new DelegatingFunction(org.apache.commons.lang3.StringUtils::normalizeSpace));
        context.put("f_reverse", new DelegatingFunction(org.apache.commons.lang3.StringUtils::reverse));
        context.put("f_strip", new DelegatingFunction(org.apache.commons.lang3.StringUtils::strip));
        context.put("f_swapcase", new DelegatingFunction(org.apache.commons.lang3.StringUtils::swapCase));
        context.put("f_recursive_eval", new RecursiveEvalFunction(context));
    }

    private class RecursiveEvalFunction
    implements Function<String, String> {
        private final Map<String, Object> context;

        public RecursiveEvalFunction(Map<String, Object> context) {
            this.context = context;
        }

        @Override
        public String apply(String input) {
            return MustacheUtils.applyTemplate((String)input, this.context);
        }
    }

    private static class DelegatingFunction
    implements Function<String, String> {
        private final Function<String, String> delegate;

        private DelegatingFunction(Function<String, String> delegate) {
            this.delegate = delegate;
        }

        @Override
        public String apply(String input) {
            return this.delegate.apply(input);
        }
    }

    private static class JsonFunction
    implements Function<Object, String> {
        private JsonFunction() {
        }

        @Override
        public String apply(Object input) {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                return objectMapper.writeValueAsString(input);
            }
            catch (JsonProcessingException e) {
                throw new IllegalStateException(RB.$((String)"ERROR_invalid_json_input", (Object[])new Object[]{input}));
            }
        }
    }

    private static class FileChecksumFunction
    implements Function<Object, String> {
        private final Algorithm algorithm;

        public FileChecksumFunction(Algorithm algorithm) {
            this.algorithm = algorithm;
        }

        @Override
        public String apply(Object input) {
            try {
                if (input instanceof Path) {
                    return ChecksumUtils.checksum((Algorithm)this.algorithm, (byte[])Files.readAllBytes((Path)input));
                }
                if (input instanceof File) {
                    return ChecksumUtils.checksum((Algorithm)this.algorithm, (byte[])Files.readAllBytes(((File)input).toPath()));
                }
                if (input instanceof CharSequence) {
                    return ChecksumUtils.checksum((Algorithm)this.algorithm, (byte[])Files.readAllBytes(Paths.get(String.valueOf(input).trim(), new String[0])));
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(RB.$((String)"ERROR_unexpected_file_read", (Object[])new Object[]{input}), e);
            }
            throw new IllegalStateException(RB.$((String)"ERROR_invalid_file_input", (Object[])new Object[]{input}));
        }
    }

    private static class FileSizeFunction
    implements Function<Object, Long> {
        private FileSizeFunction() {
        }

        @Override
        public Long apply(Object input) {
            try {
                if (input instanceof Path) {
                    return Files.size((Path)input);
                }
                if (input instanceof File) {
                    return Files.size(((File)input).toPath());
                }
                if (input instanceof CharSequence) {
                    return Files.size(Paths.get(String.valueOf(input).trim(), new String[0]));
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(RB.$((String)"ERROR_unexpected_file_read", (Object[])new Object[]{input}), e);
            }
            throw new IllegalStateException(RB.$((String)"ERROR_invalid_file_input", (Object[])new Object[]{input}));
        }
    }

    private static class FileReadFunction
    implements Function<Object, String> {
        private FileReadFunction() {
        }

        @Override
        public String apply(Object input) {
            try {
                if (input instanceof Path) {
                    return new String(Files.readAllBytes((Path)input));
                }
                if (input instanceof File) {
                    return new String(Files.readAllBytes(((File)input).toPath()));
                }
                if (input instanceof CharSequence) {
                    return new String(Files.readAllBytes(Paths.get(String.valueOf(input).trim(), new String[0])));
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(RB.$((String)"ERROR_unexpected_file_read", (Object[])new Object[]{input}), e);
            }
            throw new IllegalStateException(RB.$((String)"ERROR_invalid_file_input", (Object[])new Object[]{input}));
        }
    }

    private static class MarkdownToHtmlFunction
    implements Function<String, String> {
        private MarkdownToHtmlFunction() {
        }

        @Override
        public String apply(String input) {
            Parser parser = Parser.builder().build();
            Node document = parser.parse(input);
            HtmlRenderer renderer = HtmlRenderer.builder().build();
            return renderer.render(document).trim();
        }
    }

    private static class UncapitalizeFunction
    implements Function<String, String> {
        private UncapitalizeFunction() {
        }

        @Override
        public String apply(String input) {
            return StringUtils.uncapitalize((String)input);
        }
    }

    private static class CapitalizeFunction
    implements Function<String, String> {
        private CapitalizeFunction() {
        }

        @Override
        public String apply(String input) {
            return StringUtils.capitalize((String)input);
        }
    }

    private static class LowerFunction
    implements Function<String, String> {
        private LowerFunction() {
        }

        @Override
        public String apply(String input) {
            return input.toLowerCase(Locale.ENGLISH);
        }
    }

    private static class UpperFunction
    implements Function<String, String> {
        private UpperFunction() {
        }

        @Override
        public String apply(String input) {
            return input.toUpperCase(Locale.ENGLISH);
        }
    }

    private static class SlashFunction
    implements Function<String, String> {
        private SlashFunction() {
        }

        @Override
        public String apply(String input) {
            return input.replace(".", "/").replace("-", "/").replace("+", "/");
        }
    }

    private static class DashFunction
    implements Function<String, String> {
        private DashFunction() {
        }

        @Override
        public String apply(String input) {
            return input.replace(".", "-").replace("_", "-").replace("+", "-");
        }
    }

    private static class UnderscoreFunction
    implements Function<String, String> {
        private UnderscoreFunction() {
        }

        @Override
        public String apply(String input) {
            return input.replace(".", "_").replace("-", "_").replace("+", "_");
        }
    }

    private static class TrimFunction
    implements Function<String, String> {
        private TrimFunction() {
        }

        @Override
        public String apply(String input) {
            return input.trim();
        }
    }

    private static class TimeFormatFunction
    implements Function<String, String> {
        private final ZonedDateTime now;

        private TimeFormatFunction(ZonedDateTime now) {
            this.now = now;
        }

        @Override
        public String apply(String input) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(input);
            return this.now.format(formatter);
        }
    }
}

