/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.context;

import java.nio.file.Path;
import java.util.List;
import org.jreleaser.bundle.RB;
import org.jreleaser.config.JReleaserConfigLoader;
import org.jreleaser.engine.context.ModelConfigurer;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.JReleaserModel;
import org.jreleaser.util.PlatformUtils;

public class ContextCreator {
    public static JReleaserContext create(JReleaserLogger logger, JReleaserContext.Configurer configurer, JReleaserContext.Mode mode, Path configFile, Path basedir, Path outputDirectory, boolean dryrun, boolean gitRootSearch, List<String> selectedPlatforms) {
        return ContextCreator.create(logger, configurer, mode, ContextCreator.resolveModel(logger, configFile), basedir, outputDirectory, dryrun, gitRootSearch, selectedPlatforms);
    }

    public static JReleaserContext create(JReleaserLogger logger, JReleaserContext.Configurer configurer, JReleaserContext.Mode mode, JReleaserModel model, Path basedir, Path outputDirectory, boolean dryrun, boolean gitRootSearch, List<String> selectedPlatforms) {
        JReleaserContext context = new JReleaserContext(logger, configurer, mode, model, basedir, outputDirectory, dryrun, gitRootSearch, selectedPlatforms);
        PlatformUtils.resolveCurrentPlatform((JReleaserLogger)logger);
        ModelConfigurer.configure(context);
        return context;
    }

    public static JReleaserModel resolveModel(JReleaserLogger logger, Path configFile) {
        try {
            logger.info(RB.$((String)"context.creator.reading_configuration", (Object[])new Object[0]));
            return JReleaserConfigLoader.loadConfig((Path)configFile);
        }
        catch (JReleaserException e) {
            logger.trace((Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.trace((Throwable)e);
            throw new JReleaserException(RB.$((String)"ERROR_context_creator_parse_configuration", (Object[])new Object[]{configFile.toAbsolutePath()}), (Throwable)e);
        }
    }
}

