/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.gitter;

import java.util.LinkedHashMap;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.spi.announce.AnnounceException;
import org.jreleaser.model.spi.announce.Announcer;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.sdk.gitter.Message;
import org.jreleaser.util.StringUtils;

public class GitterAnnouncer
implements Announcer<org.jreleaser.model.api.announce.GitterAnnouncer> {
    private final JReleaserContext context;
    private final org.jreleaser.model.internal.announce.GitterAnnouncer gitter;

    public GitterAnnouncer(JReleaserContext context) {
        this.context = context;
        this.gitter = context.getModel().getAnnounce().getGitter();
    }

    public org.jreleaser.model.api.announce.GitterAnnouncer getAnnouncer() {
        return this.gitter.asImmutable();
    }

    public String getName() {
        return "gitter";
    }

    public boolean isEnabled() {
        return this.gitter.isEnabled();
    }

    public void announce() throws AnnounceException {
        String message = "";
        if (StringUtils.isNotBlank((String)this.gitter.getMessage())) {
            message = this.gitter.getResolvedMessage(this.context);
        } else {
            LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
            props.put("changelog", MustacheUtils.passThrough((String)this.context.getChangelog()));
            this.context.getModel().getRelease().getReleaser().fillProps(props, this.context.getModel());
            message = this.gitter.getResolvedMessageTemplate(this.context, props);
        }
        this.context.getLogger().info("message: {}", new Object[]{message});
        if (!this.context.isDryrun()) {
            ClientUtils.webhook((JReleaserLogger)this.context.getLogger(), (String)this.gitter.getResolvedWebhook(), (int)this.gitter.getConnectTimeout(), (int)this.gitter.getReadTimeout(), (Object)Message.of(message));
        }
    }
}

