/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.hooks;

import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.hooks.CommandHook;
import org.jreleaser.model.internal.hooks.CommandHooks;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class CommandHooksValidator
extends Validator {
    public static void validateCommandHooks(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        int i;
        context.getLogger().debug("hooks.command");
        CommandHooks hooks = context.getModel().getHooks().getCommand();
        boolean activeSet = hooks.isActiveSet();
        hooks.resolveEnabled(context.getModel().getProject());
        for (i = 0; i < hooks.getBefore().size(); ++i) {
            CommandHooksValidator.validateCommandHook(context, mode, hooks.getBefore().get(i), "before", i, errors);
        }
        for (i = 0; i < hooks.getSuccess().size(); ++i) {
            CommandHooksValidator.validateCommandHook(context, mode, hooks.getSuccess().get(i), "success", i, errors);
        }
        for (i = 0; i < hooks.getFailure().size(); ++i) {
            CommandHooksValidator.validateCommandHook(context, mode, hooks.getFailure().get(i), "failure", i, errors);
        }
        if (hooks.isEnabled()) {
            boolean enabled;
            boolean bl = enabled = hooks.getBefore().stream().anyMatch(CommandHook::isEnabled) || hooks.getSuccess().stream().anyMatch(CommandHook::isEnabled) || hooks.getFailure().stream().anyMatch(CommandHook::isEnabled);
            if (!activeSet && !enabled) {
                context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
                hooks.disable();
            }
        }
    }

    private static void validateCommandHook(JReleaserContext context, JReleaserContext.Mode mode, CommandHook hook, String type, int index, Errors errors) {
        context.getLogger().debug("hooks.command.{}[{}]", new Object[]{type, index});
        if (!hook.isActiveSet()) {
            hook.setActive(Active.ALWAYS);
        }
        if (!hook.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((String)hook.getCmd())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"hook.cmd"}));
        }
    }
}

