/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.announce;

import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.Announce;
import org.jreleaser.model.internal.validation.announce.ArticleAnnouncerValidator;
import org.jreleaser.model.internal.validation.announce.DiscordAnnouncerValidator;
import org.jreleaser.model.internal.validation.announce.DiscourseAnnouncerValidator;
import org.jreleaser.model.internal.validation.announce.DiscussionsAnnouncerValidator;
import org.jreleaser.model.internal.validation.announce.GitterAnnouncerValidator;
import org.jreleaser.model.internal.validation.announce.GoogleChatAnnouncerValidator;
import org.jreleaser.model.internal.validation.announce.HttpAnnouncerValidator;
import org.jreleaser.model.internal.validation.announce.MastodonAnnouncerValidator;
import org.jreleaser.model.internal.validation.announce.MattermostAnnouncerValidator;
import org.jreleaser.model.internal.validation.announce.SdkmanAnnouncerValidator;
import org.jreleaser.model.internal.validation.announce.SlackAnnouncerValidator;
import org.jreleaser.model.internal.validation.announce.SmtpAnnouncerValidator;
import org.jreleaser.model.internal.validation.announce.TeamsAnnouncerValidator;
import org.jreleaser.model.internal.validation.announce.TelegramAnnouncerValidator;
import org.jreleaser.model.internal.validation.announce.TwitterAnnouncerValidator;
import org.jreleaser.model.internal.validation.announce.WebhooksAnnouncerValidator;
import org.jreleaser.model.internal.validation.announce.ZulipAnnouncerValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Errors;

public abstract class AnnouncersValidator
extends Validator {
    public static void validateAnnouncers(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Announce announce = context.getModel().getAnnounce();
        context.getLogger().debug("announce");
        if (!mode.validateConfig() && !mode.validateAnnounce()) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        ArticleAnnouncerValidator.validateArticle(context, announce.getArticle(), errors);
        DiscussionsAnnouncerValidator.validateDiscussions(context, announce.getDiscussions(), errors);
        DiscordAnnouncerValidator.validateDiscord(context, announce.getDiscord(), errors);
        DiscourseAnnouncerValidator.validateDiscourse(context, announce.getDiscourse(), errors);
        GitterAnnouncerValidator.validateGitter(context, announce.getGitter(), errors);
        GoogleChatAnnouncerValidator.validateGoogleChat(context, announce.getGoogleChat(), errors);
        HttpAnnouncerValidator.validateHttpAnnouncers(context, mode, announce.getConfiguredHttp(), errors);
        SmtpAnnouncerValidator.validateSmtp(context, announce.getMail(), errors);
        MastodonAnnouncerValidator.validateMastodon(context, announce.getMastodon(), errors);
        MattermostAnnouncerValidator.validateMattermost(context, announce.getMattermost(), errors);
        SdkmanAnnouncerValidator.validateSdkmanAnnouncer(context, announce.getSdkman(), errors);
        SlackAnnouncerValidator.validateSlack(context, announce.getSlack(), errors);
        TeamsAnnouncerValidator.validateTeams(context, announce.getTeams(), errors);
        TelegramAnnouncerValidator.validateTelegram(context, announce.getTelegram(), errors);
        TwitterAnnouncerValidator.validateTwitter(context, announce.getTwitter(), errors);
        WebhooksAnnouncerValidator.validateWebhooks(context, mode, announce.getConfiguredWebhooks(), errors);
        ZulipAnnouncerValidator.validateZulip(context, announce.getZulip(), errors);
        boolean activeSet = announce.isActiveSet();
        announce.resolveEnabled(context.getModel().getProject());
        if (announce.isEnabled()) {
            boolean enabled;
            boolean bl = enabled = announce.getArticle().isEnabled() || announce.getDiscord().isEnabled() || announce.getDiscourse().isEnabled() || announce.getDiscussions().isEnabled() || announce.getGitter().isEnabled() || announce.getGoogleChat().isEnabled() || announce.getConfiguredHttp().isEnabled() || announce.getMail().isEnabled() || announce.getMastodon().isEnabled() || announce.getMattermost().isEnabled() || announce.getSdkman().isEnabled() || announce.getSlack().isEnabled() || announce.getTeams().isEnabled() || announce.getTelegram().isEnabled() || announce.getTwitter().isEnabled() || announce.getConfiguredWebhooks().isEnabled() || announce.getZulip().isEnabled();
            if (!activeSet && !enabled) {
                context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
                announce.disable();
            }
        }
    }
}

