/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.release;

import java.util.Collections;
import java.util.Map;
import org.jreleaser.model.Active;
import org.jreleaser.model.api.common.CommitAuthor;
import org.jreleaser.model.api.release.Changelog;
import org.jreleaser.model.api.release.Releaser;
import org.jreleaser.model.internal.release.BaseReleaser;

public class GiteaReleaser
extends BaseReleaser<org.jreleaser.model.api.release.GiteaReleaser, GiteaReleaser> {
    private Boolean draft;
    private final org.jreleaser.model.api.release.GiteaReleaser immutable = new org.jreleaser.model.api.release.GiteaReleaser(){

        public boolean isPrerelease() {
            return GiteaReleaser.this.isPrerelease();
        }

        public boolean isDraft() {
            return GiteaReleaser.this.isDraft();
        }

        public String getServiceName() {
            return GiteaReleaser.this.getServiceName();
        }

        public boolean isReleaseSupported() {
            return GiteaReleaser.this.isReleaseSupported();
        }

        public String getCanonicalRepoName() {
            return GiteaReleaser.this.getCanonicalRepoName();
        }

        public String getReverseRepoHost() {
            return GiteaReleaser.this.getReverseRepoHost();
        }

        public boolean isMatch() {
            return GiteaReleaser.this.isMatch();
        }

        public String getHost() {
            return GiteaReleaser.this.host;
        }

        public String getName() {
            return GiteaReleaser.this.name;
        }

        public String getRepoUrl() {
            return GiteaReleaser.this.repoUrl;
        }

        public String getRepoCloneUrl() {
            return GiteaReleaser.this.repoCloneUrl;
        }

        public String getCommitUrl() {
            return GiteaReleaser.this.commitUrl;
        }

        public String getSrcUrl() {
            return GiteaReleaser.this.srcUrl;
        }

        public String getDownloadUrl() {
            return GiteaReleaser.this.downloadUrl;
        }

        public String getReleaseNotesUrl() {
            return GiteaReleaser.this.releaseNotesUrl;
        }

        public String getLatestReleaseUrl() {
            return GiteaReleaser.this.latestReleaseUrl;
        }

        public String getIssueTrackerUrl() {
            return GiteaReleaser.this.issueTrackerUrl;
        }

        public String getUsername() {
            return GiteaReleaser.this.username;
        }

        public String getToken() {
            return GiteaReleaser.this.token;
        }

        public String getTagName() {
            return GiteaReleaser.this.tagName;
        }

        public String getPreviousTagName() {
            return GiteaReleaser.this.previousTagName;
        }

        public String getReleaseName() {
            return GiteaReleaser.this.releaseName;
        }

        public String getBranch() {
            return GiteaReleaser.this.branch;
        }

        public Releaser.Prerelease getPrerelease() {
            return GiteaReleaser.this.prerelease.asImmutable();
        }

        public boolean isSign() {
            return GiteaReleaser.this.isSign();
        }

        public Changelog getChangelog() {
            return GiteaReleaser.this.changelog.asImmutable();
        }

        public Releaser.Milestone getMilestone() {
            return GiteaReleaser.this.milestone.asImmutable();
        }

        public Releaser.Issues getIssues() {
            return GiteaReleaser.this.issues.asImmutable();
        }

        public boolean isSkipTag() {
            return GiteaReleaser.this.isSkipTag();
        }

        public boolean isSkipRelease() {
            return GiteaReleaser.this.isSkipRelease();
        }

        public boolean isOverwrite() {
            return GiteaReleaser.this.isOverwrite();
        }

        public Releaser.Update getUpdate() {
            return GiteaReleaser.this.update.asImmutable();
        }

        public String getApiEndpoint() {
            return GiteaReleaser.this.apiEndpoint;
        }

        public boolean isArtifacts() {
            return GiteaReleaser.this.isArtifacts();
        }

        public boolean isFiles() {
            return GiteaReleaser.this.isFiles();
        }

        public boolean isChecksums() {
            return GiteaReleaser.this.isChecksums();
        }

        public boolean isSignatures() {
            return GiteaReleaser.this.isSignatures();
        }

        public Active getUploadAssets() {
            return GiteaReleaser.this.uploadAssets;
        }

        public CommitAuthor getCommitAuthor() {
            return GiteaReleaser.this.commitAuthor.asImmutable();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(GiteaReleaser.this.asMap(full));
        }

        public boolean isEnabled() {
            return GiteaReleaser.this.isEnabled();
        }

        public String getOwner() {
            return GiteaReleaser.this.owner;
        }

        public Integer getConnectTimeout() {
            return GiteaReleaser.this.connectTimeout;
        }

        public Integer getReadTimeout() {
            return GiteaReleaser.this.readTimeout;
        }
    };

    public GiteaReleaser() {
        this("gitea");
    }

    GiteaReleaser(String name) {
        super(name, true);
        this.setRepoUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}");
        this.setRepoCloneUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}.git");
        this.setCommitUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/commits");
        this.setSrcUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/src/{{repoBranch}}");
        this.setDownloadUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/releases/download/{{tagName}}/{{artifactFile}}");
        this.setReleaseNotesUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/releases/tag/{{tagName}}");
        this.setLatestReleaseUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/releases/latest");
        this.setIssueTrackerUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/issues");
    }

    @Override
    public org.jreleaser.model.api.release.GiteaReleaser asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(GiteaReleaser source) {
        super.merge(source);
        this.draft = this.merge(this.draft, source.draft);
    }

    public boolean isDraft() {
        return this.draft != null && this.draft != false;
    }

    public void setDraft(Boolean draft) {
        this.draft = draft;
    }

    public boolean isDraftSet() {
        return this.draft != null;
    }

    @Override
    public String getReverseRepoHost() {
        return null;
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        Map<String, Object> map = super.asMap(full);
        map.put("draft", this.isDraft());
        return map;
    }
}

