/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.packagers;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.Active;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Stereotype;
import org.jreleaser.model.api.common.CommitAuthor;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.packagers.AbstractRepositoryPackager;
import org.jreleaser.model.internal.packagers.PackagerRepository;
import org.jreleaser.model.internal.packagers.RepositoryTap;

public final class JbangPackager
extends AbstractRepositoryPackager<org.jreleaser.model.api.packagers.JbangPackager, JbangPackager> {
    private static final Map<Distribution.DistributionType, Set<String>> SUPPORTED = new LinkedHashMap<Distribution.DistributionType, Set<String>>();
    private final JbangRepository repository = new JbangRepository();
    private String alias;
    private final org.jreleaser.model.api.packagers.JbangPackager immutable = new org.jreleaser.model.api.packagers.JbangPackager(){

        public String getAlias() {
            return JbangPackager.this.alias;
        }

        public org.jreleaser.model.api.packagers.PackagerRepository getCatalog() {
            return JbangPackager.this.repository.asImmutable();
        }

        public org.jreleaser.model.api.packagers.PackagerRepository getPackagerRepository() {
            return this.getCatalog();
        }

        public CommitAuthor getCommitAuthor() {
            return JbangPackager.this.commitAuthor.asImmutable();
        }

        public String getTemplateDirectory() {
            return JbangPackager.this.templateDirectory;
        }

        public List<String> getSkipTemplates() {
            return Collections.unmodifiableList(JbangPackager.this.skipTemplates);
        }

        public String getType() {
            return JbangPackager.this.type;
        }

        public String getDownloadUrl() {
            return JbangPackager.this.downloadUrl;
        }

        public boolean supportsPlatform(String platform) {
            return JbangPackager.this.supportsPlatform(platform);
        }

        public boolean supportsDistribution(Distribution.DistributionType distributionType) {
            return JbangPackager.this.supportsDistribution(distributionType);
        }

        public Set<String> getSupportedFileExtensions(Distribution.DistributionType distributionType) {
            return JbangPackager.this.getSupportedFileExtensions(distributionType);
        }

        public Set<Stereotype> getSupportedStereotypes() {
            return JbangPackager.this.getSupportedStereotypes();
        }

        public boolean isSnapshotSupported() {
            return JbangPackager.this.isSnapshotSupported();
        }

        public boolean isContinueOnError() {
            return JbangPackager.this.isContinueOnError();
        }

        public Active getActive() {
            return JbangPackager.this.active;
        }

        public boolean isEnabled() {
            return JbangPackager.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(JbangPackager.this.asMap(full));
        }

        public String getPrefix() {
            return JbangPackager.this.getPrefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(JbangPackager.this.extraProperties);
        }
    };

    public JbangPackager() {
        super("jbang");
    }

    @Override
    public org.jreleaser.model.api.packagers.JbangPackager asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(JbangPackager source) {
        super.merge(source);
        this.alias = this.merge(this.alias, source.alias);
        this.setCatalog(source.repository);
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public JbangRepository getCatalog() {
        return this.repository;
    }

    public void setCatalog(JbangRepository tap) {
        this.repository.merge(tap);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        super.asMap(full, props);
        props.put("alias", this.alias);
        props.put("catalog", this.repository.asMap(full));
    }

    @Override
    public RepositoryTap getRepositoryTap() {
        return this.getPackagerRepository();
    }

    public PackagerRepository getPackagerRepository() {
        return this.repository;
    }

    @Override
    public boolean supportsPlatform(String platform) {
        return true;
    }

    @Override
    public boolean supportsDistribution(Distribution.DistributionType distributionType) {
        return SUPPORTED.containsKey(distributionType);
    }

    @Override
    public Set<String> getSupportedFileExtensions(Distribution.DistributionType distributionType) {
        return Collections.unmodifiableSet(SUPPORTED.getOrDefault(distributionType, Collections.emptySet()));
    }

    @Override
    protected boolean isNotSkipped(Artifact artifact) {
        return true;
    }

    @Override
    public boolean isSnapshotSupported() {
        return true;
    }

    static {
        SUPPORTED.put(Distribution.DistributionType.JAVA_BINARY, Collections.emptySet());
        SUPPORTED.put(Distribution.DistributionType.JLINK, Collections.emptySet());
        SUPPORTED.put(Distribution.DistributionType.SINGLE_JAR, Collections.emptySet());
    }

    public static final class JbangRepository
    extends PackagerRepository {
        public JbangRepository() {
            super("jbang", "jbang-catalog");
        }

        @Override
        public String getResolvedName() {
            return this.tapName;
        }
    }
}

