/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.packagers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.model.Active;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Stereotype;
import org.jreleaser.model.api.common.CommitAuthor;
import org.jreleaser.model.api.packagers.BrewPackager;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.AbstractRepositoryPackager;
import org.jreleaser.model.internal.packagers.PackagerRepository;
import org.jreleaser.model.internal.packagers.RepositoryTap;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.FileType;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public final class BrewPackager
extends AbstractRepositoryPackager<org.jreleaser.model.api.packagers.BrewPackager, BrewPackager> {
    private static final Map<Distribution.DistributionType, Set<String>> SUPPORTED = new LinkedHashMap<Distribution.DistributionType, Set<String>>();
    private final List<Dependency> dependencies = new ArrayList<Dependency>();
    private final List<String> livecheck = new ArrayList<String>();
    private final HomebrewTap repository = new HomebrewTap();
    private final Cask cask = new Cask();
    private String formulaName;
    private String cachedFormulaName;
    private Boolean multiPlatform;
    private final org.jreleaser.model.api.packagers.BrewPackager immutable = new org.jreleaser.model.api.packagers.BrewPackager(){

        public String getFormulaName() {
            return BrewPackager.this.formulaName;
        }

        public boolean isMultiPlatform() {
            return BrewPackager.this.isMultiPlatform();
        }

        public org.jreleaser.model.api.packagers.PackagerRepository getTap() {
            return BrewPackager.this.repository.asImmutable();
        }

        public BrewPackager.Cask getCask() {
            return BrewPackager.this.cask.asImmutable();
        }

        public List<String> getLivecheck() {
            return Collections.unmodifiableList(BrewPackager.this.livecheck);
        }

        public org.jreleaser.model.api.packagers.PackagerRepository getPackagerRepository() {
            return this.getTap();
        }

        public CommitAuthor getCommitAuthor() {
            return BrewPackager.this.commitAuthor.asImmutable();
        }

        public String getTemplateDirectory() {
            return BrewPackager.this.templateDirectory;
        }

        public List<String> getSkipTemplates() {
            return Collections.unmodifiableList(BrewPackager.this.skipTemplates);
        }

        public String getType() {
            return BrewPackager.this.type;
        }

        public String getDownloadUrl() {
            return BrewPackager.this.downloadUrl;
        }

        public boolean supportsPlatform(String platform) {
            return BrewPackager.this.supportsPlatform(platform);
        }

        public boolean supportsDistribution(Distribution.DistributionType distributionType) {
            return BrewPackager.this.supportsDistribution(distributionType);
        }

        public Set<String> getSupportedFileExtensions(Distribution.DistributionType distributionType) {
            return BrewPackager.this.getSupportedFileExtensions(distributionType);
        }

        public Set<Stereotype> getSupportedStereotypes() {
            return BrewPackager.this.getSupportedStereotypes();
        }

        public boolean isSnapshotSupported() {
            return BrewPackager.this.isSnapshotSupported();
        }

        public boolean isContinueOnError() {
            return BrewPackager.this.isContinueOnError();
        }

        public Active getActive() {
            return BrewPackager.this.active;
        }

        public boolean isEnabled() {
            return BrewPackager.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(BrewPackager.this.asMap(full));
        }

        public String getPrefix() {
            return BrewPackager.this.getPrefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(BrewPackager.this.extraProperties);
        }
    };

    public BrewPackager() {
        super("brew");
    }

    @Override
    public org.jreleaser.model.api.packagers.BrewPackager asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(BrewPackager source) {
        super.merge(source);
        this.formulaName = this.merge(this.formulaName, source.formulaName);
        this.multiPlatform = this.merge(this.multiPlatform, source.multiPlatform);
        this.setTap(source.repository);
        this.setDependenciesAsList(this.merge(this.dependencies, source.dependencies));
        this.setLivecheck(this.merge(this.livecheck, source.livecheck));
        this.setCask(source.cask);
    }

    public String getResolvedFormulaName(JReleaserContext context) {
        if (StringUtils.isBlank((String)this.cachedFormulaName)) {
            this.cachedFormulaName = Templates.resolveTemplate((String)this.formulaName, context.fullProps());
            this.cachedFormulaName = StringUtils.getClassNameForLowerCaseHyphenSeparatedName((String)this.cachedFormulaName);
        }
        return this.cachedFormulaName;
    }

    public String getResolvedFormulaName(Map<String, Object> props) {
        if (StringUtils.isBlank((String)this.cachedFormulaName)) {
            this.cachedFormulaName = Templates.resolveTemplate((String)this.formulaName, props);
            this.cachedFormulaName = StringUtils.getClassNameForLowerCaseHyphenSeparatedName((String)this.cachedFormulaName);
        } else if (this.cachedFormulaName.contains("{{")) {
            this.cachedFormulaName = Templates.resolveTemplate((String)this.cachedFormulaName, props);
            this.cachedFormulaName = StringUtils.getClassNameForLowerCaseHyphenSeparatedName((String)this.cachedFormulaName);
        }
        return this.cachedFormulaName;
    }

    public String getFormulaName() {
        return this.formulaName;
    }

    public void setFormulaName(String formulaName) {
        this.formulaName = formulaName;
    }

    public boolean isMultiPlatform() {
        return this.multiPlatform != null && this.multiPlatform != false;
    }

    public void setMultiPlatform(Boolean multiPlatform) {
        this.multiPlatform = multiPlatform;
    }

    public boolean isMultiPlatformSet() {
        return this.multiPlatform != null;
    }

    public HomebrewTap getTap() {
        return this.repository;
    }

    public void setTap(HomebrewTap repository) {
        this.repository.merge(repository);
    }

    public Cask getCask() {
        return this.cask;
    }

    public void setCask(Cask cask) {
        this.cask.merge(cask);
    }

    public void setDependencies(Map<String, String> dependencies) {
        if (null == dependencies || dependencies.isEmpty()) {
            return;
        }
        this.dependencies.clear();
        dependencies.forEach(this::addDependency);
    }

    public List<Dependency> getDependenciesAsList() {
        return this.dependencies;
    }

    public void setDependenciesAsList(List<Dependency> dependencies) {
        if (null == dependencies || dependencies.isEmpty()) {
            return;
        }
        this.dependencies.clear();
        this.dependencies.addAll(dependencies);
    }

    public void addDependencies(Map<String, String> dependencies) {
        if (null == dependencies || dependencies.isEmpty()) {
            return;
        }
        dependencies.forEach(this::addDependency);
    }

    public void addDependency(String key, String value) {
        this.dependencies.add(new Dependency(key, value));
    }

    public void addDependency(String key) {
        this.dependencies.add(new Dependency(key));
    }

    public List<String> getLivecheck() {
        return this.livecheck;
    }

    public void setLivecheck(List<String> livecheck) {
        this.livecheck.clear();
        this.livecheck.addAll(livecheck);
    }

    public boolean hasLivecheck() {
        return !this.livecheck.isEmpty();
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        super.asMap(full, props);
        props.put("formulaName", this.formulaName);
        props.put("multiPlatform", this.isMultiPlatform());
        props.put("tap", this.repository.asMap(full));
        props.put("dependencies", this.dependencies);
        props.put("livecheck", this.livecheck);
        props.put("cask", this.cask.asMap(full));
    }

    @Override
    public RepositoryTap getRepositoryTap() {
        return this.getPackagerRepository();
    }

    public PackagerRepository getPackagerRepository() {
        return this.repository;
    }

    @Override
    public boolean supportsPlatform(String platform) {
        if (this.isMultiPlatform()) {
            return StringUtils.isBlank((String)platform) || PlatformUtils.isMac((String)platform) || PlatformUtils.isLinux((String)platform) && !PlatformUtils.isAlpineLinux((String)platform);
        }
        return StringUtils.isBlank((String)platform) || PlatformUtils.isMac((String)platform);
    }

    @Override
    public boolean supportsDistribution(Distribution.DistributionType distributionType) {
        return SUPPORTED.containsKey(distributionType);
    }

    @Override
    public Set<String> getSupportedFileExtensions(Distribution.DistributionType distributionType) {
        return Collections.unmodifiableSet(SUPPORTED.getOrDefault(distributionType, Collections.emptySet()));
    }

    @Override
    public List<Artifact> resolveCandidateArtifacts(JReleaserContext context, Distribution distribution) {
        List<Artifact> candidateArtifacts = super.resolveCandidateArtifacts(context, distribution);
        if (this.cask.isEnabled()) {
            return candidateArtifacts.stream().filter(artifact -> PlatformUtils.isMac((String)artifact.getPlatform())).collect(Collectors.toList());
        }
        return candidateArtifacts;
    }

    @Override
    protected boolean isNotSkipped(Artifact artifact) {
        return StringUtils.isFalse((Object)artifact.getExtraProperties().get("skipBrew"));
    }

    static {
        Set extensions = CollectionUtils.setOf((Object[])new String[]{FileType.ZIP.extension()});
        SUPPORTED.put(Distribution.DistributionType.BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JAVA_BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JLINK, extensions);
        SUPPORTED.put(Distribution.DistributionType.NATIVE_IMAGE, extensions);
        SUPPORTED.put(Distribution.DistributionType.NATIVE_PACKAGE, CollectionUtils.setOf((Object[])new String[]{FileType.ZIP.extension(), FileType.DMG.extension(), FileType.PKG.extension()}));
        SUPPORTED.put(Distribution.DistributionType.SINGLE_JAR, CollectionUtils.setOf((Object[])new String[]{FileType.JAR.extension()}));
    }

    public static final class CaskItem
    extends AbstractModelObject<CaskItem>
    implements Domain {
        private final List<String> items = new ArrayList<String>();
        private String name;
        private final BrewPackager.CaskItem immutable = new BrewPackager.CaskItem(){

            public String getName() {
                return name;
            }

            public List<String> getItems() {
                return Collections.unmodifiableList(items);
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public CaskItem(String name, List<String> items) {
            this.name = name;
            this.items.addAll(items);
        }

        public BrewPackager.CaskItem asImmutable() {
            return this.immutable;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<String> getItems() {
            return this.items;
        }

        public void setItems(List<String> items) {
            this.items.clear();
            this.items.addAll(items);
        }

        public boolean getHasItems() {
            return !this.items.isEmpty();
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            return this.asMap();
        }

        public Map<String, Object> asMap() {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put(this.name, this.items);
            return map;
        }

        @Override
        public void merge(CaskItem source) {
            this.name = this.merge(this.name, source.name);
            this.setItems(this.merge(this.items, source.items));
        }
    }

    public static final class Cask
    extends AbstractModelObject<Cask>
    implements Domain {
        private final List<CaskItem> uninstall = new ArrayList<CaskItem>();
        private final List<CaskItem> zap = new ArrayList<CaskItem>();
        private Boolean enabled;
        private String name;
        private String displayName;
        private String pkgName;
        private String appName;
        private String appcast;
        private final BrewPackager.Cask immutable = new BrewPackager.Cask(){
            private List<? extends BrewPackager.CaskItem> uninstall;
            private List<? extends BrewPackager.CaskItem> zap;

            public boolean isEnabled() {
                return this.isEnabled();
            }

            public String getName() {
                return name;
            }

            public String getDisplayName() {
                return displayName;
            }

            public String getPkgName() {
                return pkgName;
            }

            public String getAppName() {
                return appName;
            }

            public String getAppcast() {
                return appcast;
            }

            public List<? extends BrewPackager.CaskItem> getUninstallItems() {
                if (null == this.uninstall) {
                    this.uninstall = uninstall.stream().map(CaskItem::asImmutable).collect(Collectors.toList());
                }
                return this.uninstall;
            }

            public List<? extends BrewPackager.CaskItem> getZapItems() {
                if (null == this.zap) {
                    this.zap = zap.stream().map(CaskItem::asImmutable).collect(Collectors.toList());
                }
                return this.zap;
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };
        @JsonIgnore
        private String cachedCaskName;
        @JsonIgnore
        private String cachedDisplayName;
        @JsonIgnore
        private String cachedAppName;
        @JsonIgnore
        private String cachedPkgName;

        public BrewPackager.Cask asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Cask source) {
            this.enabled = this.merge(this.enabled, source.enabled);
            this.name = this.merge(this.name, source.name);
            this.displayName = this.merge(this.displayName, source.displayName);
            this.pkgName = this.merge(this.pkgName, source.pkgName);
            this.appName = this.merge(this.appName, source.appName);
            this.appcast = this.merge(this.appcast, source.appcast);
            this.setUninstallItems(this.merge(this.uninstall, source.uninstall));
            this.setZapItems(this.merge(this.zap, source.zap));
        }

        public void enable() {
            this.enabled = true;
        }

        public void disable() {
            this.enabled = false;
        }

        public boolean isEnabled() {
            return this.enabled != null && this.enabled != false;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabledSet() {
            return this.enabled != null;
        }

        public String getResolvedAppcast(Map<String, Object> props) {
            if (StringUtils.isNotBlank((String)this.appcast)) {
                return Templates.resolveTemplate((String)this.appcast, props);
            }
            return this.appcast;
        }

        public String getResolvedCaskName(JReleaserContext context) {
            if (StringUtils.isBlank((String)this.cachedCaskName)) {
                this.cachedCaskName = Templates.resolveTemplate((String)this.name, context.getModel().props());
                this.cachedCaskName = this.cachedCaskName.toLowerCase(Locale.ENGLISH);
            }
            return this.cachedCaskName;
        }

        public String getResolvedCaskName(Map<String, Object> props) {
            if (StringUtils.isBlank((String)this.cachedCaskName)) {
                this.cachedCaskName = Templates.resolveTemplate((String)this.name, props);
                this.cachedCaskName = StringUtils.getClassNameForLowerCaseHyphenSeparatedName((String)this.cachedCaskName);
            } else if (this.cachedCaskName.contains("{{")) {
                this.cachedCaskName = Templates.resolveTemplate((String)this.cachedCaskName, props);
                this.cachedCaskName = StringUtils.getClassNameForLowerCaseHyphenSeparatedName((String)this.cachedCaskName);
            }
            return this.cachedCaskName;
        }

        public String getResolvedDisplayName(JReleaserContext context) {
            if (StringUtils.isBlank((String)this.cachedDisplayName)) {
                this.cachedDisplayName = Templates.resolveTemplate((String)this.displayName, context.getModel().props());
                this.cachedDisplayName = StringUtils.getClassNameForLowerCaseHyphenSeparatedName((String)this.cachedDisplayName);
            }
            return this.cachedDisplayName;
        }

        public String getResolvedDisplayName(Map<String, Object> props) {
            if (StringUtils.isBlank((String)this.cachedDisplayName)) {
                this.cachedDisplayName = Templates.resolveTemplate((String)this.displayName, props);
                this.cachedDisplayName = StringUtils.getNaturalName((String)StringUtils.getClassNameForLowerCaseHyphenSeparatedName((String)this.cachedDisplayName));
            } else if (this.cachedDisplayName.contains("{{")) {
                this.cachedDisplayName = Templates.resolveTemplate((String)this.cachedDisplayName, props);
                this.cachedDisplayName = StringUtils.getNaturalName((String)StringUtils.getClassNameForLowerCaseHyphenSeparatedName((String)this.cachedDisplayName));
            }
            return this.cachedDisplayName;
        }

        public String getResolvedAppName(JReleaserContext context) {
            if (StringUtils.isBlank((String)this.cachedAppName)) {
                this.cachedAppName = Templates.resolveTemplate((String)this.appName, context.getModel().props());
            }
            return this.cachedAppName;
        }

        public String getResolvedAppName(Map<String, Object> props) {
            if (StringUtils.isBlank((String)this.cachedAppName)) {
                this.cachedAppName = Templates.resolveTemplate((String)this.appName, props);
            } else if (this.cachedAppName.contains("{{")) {
                this.cachedAppName = Templates.resolveTemplate((String)this.cachedAppName, props);
            }
            return this.cachedAppName;
        }

        public String getResolvedPkgName(JReleaserContext context) {
            if (StringUtils.isBlank((String)this.cachedPkgName)) {
                this.cachedPkgName = Templates.resolveTemplate((String)this.pkgName, context.getModel().props());
            }
            return this.cachedPkgName;
        }

        public String getResolvedPkgName(Map<String, Object> props) {
            if (StringUtils.isBlank((String)this.cachedPkgName)) {
                this.cachedPkgName = Templates.resolveTemplate((String)this.pkgName, props);
            } else if (this.cachedPkgName.contains("{{")) {
                this.cachedPkgName = Templates.resolveTemplate((String)this.cachedPkgName, props);
            }
            return this.cachedPkgName;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public String getPkgName() {
            return this.pkgName;
        }

        public void setPkgName(String pkgName) {
            this.pkgName = pkgName;
        }

        public String getAppName() {
            return this.appName;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }

        public String getAppcast() {
            return this.appcast;
        }

        public void setAppcast(String appcast) {
            this.appcast = appcast;
        }

        public List<CaskItem> getUninstallItems() {
            return this.uninstall;
        }

        void setUninstallItems(List<CaskItem> uninstall) {
            this.uninstall.clear();
            this.uninstall.addAll(uninstall);
        }

        public void setUninstall(Map<String, List<String>> uninstall) {
            this.uninstall.clear();
            uninstall.forEach((name, items) -> this.uninstall.add(new CaskItem((String)name, (List<String>)items)));
        }

        public void addUninstall(CaskItem item) {
            if (null != item) {
                this.uninstall.add(item);
            }
        }

        public boolean getHasUninstall() {
            return !this.uninstall.isEmpty();
        }

        public List<CaskItem> getZapItems() {
            return this.zap;
        }

        void setZapItems(List<CaskItem> zap) {
            this.zap.clear();
            this.zap.addAll(zap);
        }

        public void setZap(Map<String, List<String>> zap) {
            this.zap.clear();
            zap.forEach((name, items) -> this.zap.add(new CaskItem((String)name, (List<String>)items)));
        }

        public void addZap(CaskItem item) {
            if (null != item) {
                this.zap.add(item);
            }
        }

        public boolean getHasZap() {
            return !this.zap.isEmpty();
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("enabled", this.isEnabled());
            map.put("name", this.name);
            map.put("displayName", this.displayName);
            map.put("appName", this.appName);
            map.put("pkgName", this.pkgName);
            map.put("appcast", this.appcast);
            if (!this.uninstall.isEmpty()) {
                map.put("uninstall", this.uninstall.stream().map(CaskItem::asMap).collect(Collectors.toList()));
            }
            if (!this.zap.isEmpty()) {
                map.put("zap", this.zap.stream().map(CaskItem::asMap).collect(Collectors.toList()));
            }
            return map;
        }
    }

    public static final class HomebrewTap
    extends PackagerRepository {
        public HomebrewTap() {
            super("homebrew", "homebrew-tap");
        }
    }

    public static final class Dependency {
        private final String key;
        private final String value;

        private Dependency(String key) {
            this(key, (String)null);
        }

        private Dependency(String key, String value) {
            this.key = key;
            this.value = StringUtils.isBlank((String)value) || "null".equalsIgnoreCase(value) ? null : value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            StringBuilder formatted = new StringBuilder();
            if (this.key.startsWith(":")) {
                formatted.append(this.key);
            } else {
                formatted.append("\"").append(this.key).append("\"");
            }
            if (StringUtils.isNotBlank((String)this.value)) {
                formatted.append(" => \"").append(this.value).append("\"");
            }
            return formatted.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Dependency that = (Dependency)o;
            return this.key.equals(that.key);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }
    }
}

