/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.assemble;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jreleaser.model.api.assemble.Assembler;
import org.jreleaser.model.internal.assemble.AbstractAssembler;
import org.jreleaser.model.internal.assemble.JavaAssembler;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.common.Glob;
import org.jreleaser.model.internal.common.Java;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.version.SemanticVersion;

public abstract class AbstractJavaAssembler<S extends AbstractJavaAssembler<S, A>, A extends Assembler>
extends AbstractAssembler<S, A>
implements JavaAssembler<A> {
    protected final Artifact mainJar = new Artifact();
    protected final List<Glob> jars = new ArrayList<Glob>();
    protected final List<Glob> files = new ArrayList<Glob>();
    protected final Java java = new Java();
    protected String executable;
    protected String templateDirectory;

    protected AbstractJavaAssembler(String type) {
        super(type);
    }

    @Override
    public void merge(S source) {
        super.merge(source);
        this.executable = this.merge(this.executable, ((AbstractJavaAssembler)source).executable);
        this.templateDirectory = this.merge(this.templateDirectory, ((AbstractJavaAssembler)source).templateDirectory);
        this.setJava(((AbstractJavaAssembler)source).java);
        this.setMainJar(((AbstractJavaAssembler)source).mainJar);
        this.setJars(this.merge(this.jars, ((AbstractJavaAssembler)source).jars));
        this.setFiles(this.merge(this.files, ((AbstractJavaAssembler)source).files));
    }

    @Override
    public Map<String, Object> props() {
        Map<String, Object> props = super.props();
        props.put("distributionExecutable", this.executable);
        props.putAll(this.java.getResolvedExtraProperties());
        CollectionUtils.safePut((String)"distributionJavaGroupId", (Object)this.java.getGroupId(), props, (boolean)true);
        CollectionUtils.safePut((String)"distributionJavaArtifactId", (Object)this.java.getArtifactId(), props, (boolean)true);
        CollectionUtils.safePut((String)"distributionJavaMainClass", (Object)this.java.getMainClass(), props, (boolean)true);
        if (StringUtils.isNotBlank((String)this.java.getVersion())) {
            props.put("distributionJavaVersion", this.java.getVersion());
            SemanticVersion jv = SemanticVersion.of((String)this.java.getVersion());
            CollectionUtils.safePut((String)"distributionJavaVersionMajor", (Object)jv.getMajor(), props, (boolean)true);
            CollectionUtils.safePut((String)"distributionJavaVersionMinor", (Object)jv.getMinor(), props, (boolean)true);
            CollectionUtils.safePut((String)"distributionJavaVersionPatch", (Object)jv.getPatch(), props, (boolean)true);
            CollectionUtils.safePut((String)"distributionJavaVersionTag", (Object)jv.getTag(), props, (boolean)true);
            CollectionUtils.safePut((String)"distributionJavaVersionBuild", (Object)jv.getBuild(), props, (boolean)true);
        } else {
            props.put("distributionJavaVersion", "");
            props.put("distributionJavaVersionMajor", "");
            props.put("distributionJavaVersionMinor", "");
            props.put("distributionJavaVersionPatch", "");
            props.put("distributionJavaVersionTag", "");
            props.put("distributionJavaVersionBuild", "");
        }
        return props;
    }

    @Override
    public String getExecutable() {
        return this.executable;
    }

    @Override
    public void setExecutable(String executable) {
        this.executable = executable;
    }

    @Override
    public String getTemplateDirectory() {
        return this.templateDirectory;
    }

    @Override
    public void setTemplateDirectory(String templateDirectory) {
        this.templateDirectory = templateDirectory;
    }

    @Override
    public Java getJava() {
        return this.java;
    }

    @Override
    public void setJava(Java java) {
        this.java.merge(java);
    }

    @Override
    public Artifact getMainJar() {
        return this.mainJar;
    }

    @Override
    public void setMainJar(Artifact mainJar) {
        this.mainJar.merge(mainJar);
    }

    @Override
    public List<Glob> getJars() {
        return this.jars;
    }

    @Override
    public void setJars(List<Glob> jars) {
        this.jars.clear();
        this.jars.addAll(jars);
    }

    @Override
    public void addJars(List<Glob> jars) {
        this.jars.addAll(jars);
    }

    @Override
    public void addJar(Glob jar) {
        if (null != jar) {
            this.jars.add(jar);
        }
    }

    @Override
    public List<Glob> getFiles() {
        return this.files;
    }

    @Override
    public void setFiles(List<Glob> files) {
        this.files.clear();
        this.files.addAll(files);
    }

    @Override
    public void addFiles(List<Glob> files) {
        this.files.addAll(files);
    }

    @Override
    public void addFile(Glob file) {
        if (null != file) {
            this.files.add(file);
        }
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("executable", this.executable);
        props.put("templateDirectory", this.templateDirectory);
        props.put("mainJar", this.mainJar.asMap(full));
        LinkedHashMap<String, Map<String, Object>> mappedJars = new LinkedHashMap<String, Map<String, Object>>();
        for (int i = 0; i < this.jars.size(); ++i) {
            mappedJars.put("glob " + i, this.jars.get(i).asMap(full));
        }
        props.put("jars", mappedJars);
        LinkedHashMap<String, Map<String, Object>> mappedFiles = new LinkedHashMap<String, Map<String, Object>>();
        for (int i = 0; i < this.files.size(); ++i) {
            mappedFiles.put("glob " + i, this.files.get(i).asMap(full));
        }
        props.put("files", mappedFiles);
        props.put("extraProperties", this.getResolvedExtraProperties());
        if (this.java.isEnabled()) {
            props.put("java", this.java.asMap(full));
        }
    }
}

