/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.announce;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.AbstractAnnouncer;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.Env;
import org.jreleaser.util.StringUtils;

public final class GoogleChatAnnouncer
extends AbstractAnnouncer<GoogleChatAnnouncer, org.jreleaser.model.api.announce.GoogleChatAnnouncer> {
    private String webhook;
    private String message;
    private String messageTemplate;
    private final org.jreleaser.model.api.announce.GoogleChatAnnouncer immutable = new org.jreleaser.model.api.announce.GoogleChatAnnouncer(){

        public String getType() {
            return "googlechat";
        }

        public String getWebhook() {
            return GoogleChatAnnouncer.this.webhook;
        }

        public String getMessage() {
            return GoogleChatAnnouncer.this.message;
        }

        public String getMessageTemplate() {
            return GoogleChatAnnouncer.this.messageTemplate;
        }

        public String getName() {
            return GoogleChatAnnouncer.this.name;
        }

        public boolean isSnapshotSupported() {
            return GoogleChatAnnouncer.this.isSnapshotSupported();
        }

        public Active getActive() {
            return GoogleChatAnnouncer.this.active;
        }

        public boolean isEnabled() {
            return GoogleChatAnnouncer.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(GoogleChatAnnouncer.this.asMap(full));
        }

        public String getPrefix() {
            return GoogleChatAnnouncer.this.getPrefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(GoogleChatAnnouncer.this.extraProperties);
        }

        public Integer getConnectTimeout() {
            return GoogleChatAnnouncer.this.connectTimeout;
        }

        public Integer getReadTimeout() {
            return GoogleChatAnnouncer.this.readTimeout;
        }
    };

    public GoogleChatAnnouncer() {
        super("googlechat");
    }

    @Override
    public org.jreleaser.model.api.announce.GoogleChatAnnouncer asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(GoogleChatAnnouncer source) {
        super.merge(source);
        this.webhook = this.merge(this.webhook, source.webhook);
        this.message = this.merge(this.message, source.message);
        this.messageTemplate = this.merge(this.messageTemplate, source.messageTemplate);
    }

    @Override
    public String getPrefix() {
        return "googleChat";
    }

    public String getResolvedMessage(JReleaserContext context) {
        Map<String, Object> props = context.fullProps();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        return Templates.resolveTemplate((String)this.message, props);
    }

    public String getResolvedMessageTemplate(JReleaserContext context, Map<String, Object> extraProps) {
        Map<String, Object> props = context.fullProps();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        props.put("tagName", context.getModel().getRelease().getReleaser().getEffectiveTagName(context.getModel()));
        props.putAll(extraProps);
        Path templatePath = context.getBasedir().resolve(this.messageTemplate);
        try {
            BufferedReader reader = Files.newBufferedReader(templatePath);
            return MustacheUtils.applyTemplate((Reader)reader, props);
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_reading_template", (Object[])new Object[]{context.relativizeToBasedir(templatePath)}));
        }
    }

    public String getResolvedWebhook() {
        return Env.env((String)"GOOGLE_CHAT_WEBHOOK", (String)this.webhook);
    }

    public String getWebhook() {
        return this.webhook;
    }

    public void setWebhook(String webhook) {
        this.webhook = webhook;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessageTemplate() {
        return this.messageTemplate;
    }

    public void setMessageTemplate(String messageTemplate) {
        this.messageTemplate = messageTemplate;
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("webhook", StringUtils.isNotBlank((String)this.getResolvedWebhook()) ? "************" : "**unset**");
        props.put("message", this.message);
        props.put("messageTemplate", this.messageTemplate);
    }
}

