/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.announce;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.AbstractAnnouncer;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.Templates;

public final class DiscussionsAnnouncer
extends AbstractAnnouncer<DiscussionsAnnouncer, org.jreleaser.model.api.announce.DiscussionsAnnouncer> {
    private String organization;
    private String team;
    private String title;
    private String message;
    private String messageTemplate;
    private final org.jreleaser.model.api.announce.DiscussionsAnnouncer immutable = new org.jreleaser.model.api.announce.DiscussionsAnnouncer(){

        public String getType() {
            return "discussions";
        }

        public String getOrganization() {
            return DiscussionsAnnouncer.this.organization;
        }

        public String getTeam() {
            return DiscussionsAnnouncer.this.team;
        }

        public String getTitle() {
            return DiscussionsAnnouncer.this.title;
        }

        public String getMessage() {
            return DiscussionsAnnouncer.this.message;
        }

        public String getMessageTemplate() {
            return DiscussionsAnnouncer.this.messageTemplate;
        }

        public String getName() {
            return DiscussionsAnnouncer.this.name;
        }

        public boolean isSnapshotSupported() {
            return DiscussionsAnnouncer.this.isSnapshotSupported();
        }

        public Active getActive() {
            return DiscussionsAnnouncer.this.active;
        }

        public boolean isEnabled() {
            return DiscussionsAnnouncer.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(DiscussionsAnnouncer.this.asMap(full));
        }

        public String getPrefix() {
            return DiscussionsAnnouncer.this.getPrefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(DiscussionsAnnouncer.this.extraProperties);
        }

        public Integer getConnectTimeout() {
            return DiscussionsAnnouncer.this.connectTimeout;
        }

        public Integer getReadTimeout() {
            return DiscussionsAnnouncer.this.readTimeout;
        }
    };

    public DiscussionsAnnouncer() {
        super("discussions");
    }

    @Override
    public org.jreleaser.model.api.announce.DiscussionsAnnouncer asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(DiscussionsAnnouncer source) {
        super.merge(source);
        this.organization = this.merge(this.organization, source.organization);
        this.team = this.merge(this.team, source.team);
        this.title = this.merge(this.title, source.title);
        this.message = this.merge(this.message, source.message);
        this.messageTemplate = this.merge(this.messageTemplate, source.messageTemplate);
    }

    public String getResolvedTitle(JReleaserContext context) {
        Map<String, Object> props = context.fullProps();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        return Templates.resolveTemplate((String)this.title, props);
    }

    public String getResolvedMessage(JReleaserContext context) {
        Map<String, Object> props = context.fullProps();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        return Templates.resolveTemplate((String)this.message, props);
    }

    public String getResolvedMessageTemplate(JReleaserContext context, Map<String, Object> extraProps) {
        Map<String, Object> props = context.fullProps();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        props.put("tagName", context.getModel().getRelease().getReleaser().getEffectiveTagName(context.getModel()));
        props.putAll(extraProps);
        Path templatePath = context.getBasedir().resolve(this.messageTemplate);
        try {
            BufferedReader reader = Files.newBufferedReader(templatePath);
            return MustacheUtils.applyTemplate((Reader)reader, props);
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_reading_template", (Object[])new Object[]{context.relativizeToBasedir(templatePath)}));
        }
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getTeam() {
        return this.team;
    }

    public void setTeam(String team) {
        this.team = team;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessageTemplate() {
        return this.messageTemplate;
    }

    public void setMessageTemplate(String messageTemplate) {
        this.messageTemplate = messageTemplate;
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("organization", this.organization);
        props.put("team", this.team);
        props.put("title", this.title);
        props.put("message", this.message);
        props.put("messageTemplate", this.messageTemplate);
    }
}

