/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal;

import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.validation.announce.AnnouncersValidator;
import org.jreleaser.model.internal.validation.assemble.AssemblersValidator;
import org.jreleaser.model.internal.validation.checksum.ChecksumValidator;
import org.jreleaser.model.internal.validation.deploy.DeployValidator;
import org.jreleaser.model.internal.validation.distributions.DistributionsValidator;
import org.jreleaser.model.internal.validation.download.DownloadersValidator;
import org.jreleaser.model.internal.validation.extensions.ExtensionsValidator;
import org.jreleaser.model.internal.validation.files.FilesValidator;
import org.jreleaser.model.internal.validation.hooks.HooksValidator;
import org.jreleaser.model.internal.validation.packagers.PackagersValidator;
import org.jreleaser.model.internal.validation.project.ProjectValidator;
import org.jreleaser.model.internal.validation.release.ReleaseValidator;
import org.jreleaser.model.internal.validation.signing.SigningValidator;
import org.jreleaser.model.internal.validation.upload.UploadersValidator;
import org.jreleaser.util.Errors;

public final class JReleaserModelValidator {
    private JReleaserModelValidator() {
    }

    public static void validate(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        context.getLogger().increaseIndent();
        context.getLogger().setPrefix("validation");
        try {
            context.getLogger().debug("--== {} ==--", new Object[]{mode});
            JReleaserModelValidator.validateModel(context, mode, errors);
        }
        finally {
            context.getLogger().restorePrefix();
            context.getLogger().decreaseIndent();
        }
    }

    private static void validateModel(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        ExtensionsValidator.validateExtensions(context, mode, errors);
        HooksValidator.validateHooks(context, mode, errors);
        ProjectValidator.validateProject(context, mode, errors);
        DownloadersValidator.validateDownloaders(context, mode, errors);
        AssemblersValidator.validateAssemblers(context, mode, errors);
        if (context.getModel().getCommit() != null) {
            SigningValidator.validateSigning(context, mode, errors);
            ReleaseValidator.validateRelease(context, mode, errors);
        }
        ChecksumValidator.validateChecksum(context, mode, errors);
        DeployValidator.validateDeploy(context, mode, errors);
        UploadersValidator.validateUploaders(context, mode, errors);
        PackagersValidator.validatePackagers(context, mode, errors);
        DistributionsValidator.validateDistributions(context, mode, errors);
        FilesValidator.validateFiles(context, mode, errors);
        AnnouncersValidator.validateAnnouncers(context, mode, errors);
        context.getLogger().setPrefix("postvalidation");
        try {
            ProjectValidator.postValidateProject(context, mode, errors);
            if (mode.validateConfig() || mode.validateAssembly()) {
                AssemblersValidator.postValidateAssemblers(context, mode, errors);
            }
            if (mode.validateConfig()) {
                DistributionsValidator.postValidateDistributions(context, mode, errors);
            }
        }
        finally {
            context.getLogger().restorePrefix();
        }
    }
}

