/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.ssh;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import net.schmizz.sshj.SSHClient;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.upload.ScpUploader;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.upload.SshUploader;
import org.jreleaser.model.spi.upload.UploadException;
import org.jreleaser.sdk.commons.AbstractArtifactUploader;
import org.jreleaser.sdk.ssh.SshUtils;

public class ScpArtifactUploader
extends AbstractArtifactUploader<ScpUploader, org.jreleaser.model.internal.upload.ScpUploader> {
    private org.jreleaser.model.internal.upload.ScpUploader uploader;

    public ScpArtifactUploader(JReleaserContext context) {
        super(context);
    }

    public org.jreleaser.model.internal.upload.ScpUploader getUploader() {
        return this.uploader;
    }

    public void setUploader(org.jreleaser.model.internal.upload.ScpUploader uploader) {
        this.uploader = uploader;
    }

    public String getType() {
        return "scp";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void upload(String name) throws UploadException {
        List artifacts = this.collectArtifacts();
        if (artifacts.isEmpty()) {
            this.context.getLogger().info(RB.$((String)"artifacts.no.match", (Object[])new Object[0]));
        }
        SSHClient ssh = SshUtils.createSSHClient(this.context, (SshUploader)this.uploader);
        try {
            for (Artifact artifact : artifacts) {
                Path path = artifact.getEffectivePath(this.context);
                this.context.getLogger().info(" - {}", new Object[]{path.getFileName()});
                if (this.context.isDryrun()) continue;
                try {
                    String uploadPath = this.uploader.getResolvedPath(this.context, artifact);
                    this.context.getLogger().debug("   " + RB.$((String)"uploader.uploading.to", (Object[])new Object[]{uploadPath}));
                    SshUtils.createDirectories(this.context, (SshUploader)this.uploader, ssh, Paths.get(uploadPath, new String[0]).getParent());
                    ssh.newSCPFileTransfer().upload(path.toAbsolutePath().toString(), uploadPath);
                }
                catch (IOException e) {
                    this.context.getLogger().trace((Throwable)e);
                    throw new UploadException(RB.$((String)"ERROR_unexpected_upload", (Object[])new Object[]{this.context.getBasedir().relativize(path)}), (Throwable)e);
                    return;
                }
            }
        }
        finally {
            SshUtils.disconnect((SshUploader)this.uploader, ssh);
        }
    }
}

