/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.Locale;
import org.jreleaser.util.StringUtils;

public class Flatpak {

    public static enum Runtime {
        FREEDESKTOP("org.freedesktop.Platform", "org.freedesktop.Sdk"),
        GNOME("org.gnome.Platform", "org.gnome.Sdk"),
        KDE("org.kde.Platform", "org.kde.Sdk"),
        ELEMENTARY("io.elementary.Platform", "io.elementary.Sdk");

        private final String runtime;
        private final String sdk;

        private Runtime(String runtime, String sdk) {
            this.runtime = runtime;
            this.sdk = sdk;
        }

        public String runtime() {
            return this.runtime;
        }

        public String sdk() {
            return this.sdk;
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        public static Runtime of(String str) {
            if (StringUtils.isBlank((String)str)) {
                return null;
            }
            return Runtime.valueOf(str.toUpperCase(Locale.ENGLISH).trim());
        }
    }
}

