/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.twitter;

import java.util.List;
import java.util.Objects;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.sdk.twitter.TwitterException;
import org.jreleaser.util.StringUtils;
import twitter4j.Status;
import twitter4j.StatusUpdate;
import twitter4j.TwitterFactory;
import twitter4j.conf.ConfigurationBuilder;

public class Twitter {
    private final JReleaserLogger logger;
    private final twitter4j.Twitter twitter;
    private final boolean dryrun;

    public Twitter(JReleaserLogger logger, String apiHost, int connectTimeout, int readTimeout, String consumerKey, String consumerToken, String accessToken, String accessTokenSecret, boolean dryrun) {
        Objects.requireNonNull(logger, "'logger' must not be null");
        StringUtils.requireNonBlank((String)apiHost, (String)"'apiHost' must not be blank");
        StringUtils.requireNonBlank((String)consumerKey, (String)"'consumerKey' must not be blank");
        StringUtils.requireNonBlank((String)consumerToken, (String)"'consumerToken' must not be blank");
        StringUtils.requireNonBlank((String)accessToken, (String)"'accessToken' must not be blank");
        StringUtils.requireNonBlank((String)accessTokenSecret, (String)"'accessTokenSecret' must not be blank");
        this.logger = logger;
        this.dryrun = dryrun;
        this.twitter = new TwitterFactory(new ConfigurationBuilder().setRestBaseURL(apiHost).setHttpConnectionTimeout(connectTimeout * 1000).setHttpReadTimeout(readTimeout * 1000).setOAuthConsumerKey(consumerKey).setOAuthConsumerSecret(consumerToken).setOAuthAccessToken(accessToken).setOAuthAccessTokenSecret(accessTokenSecret).build()).getInstance();
        this.logger.debug(RB.$((String)"workflow.dryrun", (Object[])new Object[0]), new Object[]{dryrun});
    }

    public void updateStatus(List<String> statuses) throws TwitterException {
        this.wrap(() -> {
            String message = (String)statuses.get(0);
            Status status = this.twitter.updateStatus(message);
            for (int i = 1; i < statuses.size(); ++i) {
                status = this.twitter.updateStatus(new StatusUpdate((String)statuses.get(i)).inReplyToStatusId(status.getId()));
            }
        });
    }

    private void wrap(TwitterOperation op) throws TwitterException {
        try {
            if (!this.dryrun) {
                op.execute();
            }
        }
        catch (twitter4j.TwitterException e) {
            this.logger.trace((Throwable)e);
            throw new TwitterException(RB.$((String)"sdk.operation.failed", (Object[])new Object[]{"Twitter"}), e);
        }
    }

    private static interface TwitterOperation {
        public void execute() throws twitter4j.TwitterException;
    }
}

