/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.kohsuke.github.GHEvent;
import org.kohsuke.github.GHHook;
import org.kohsuke.github.GHOrgHook;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHRepoHook;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubInteractiveObject;
import org.kohsuke.github.Requester;

class GHHooks {
    GHHooks() {
    }

    static Context repoContext(GHRepository repository, GHUser owner) {
        return new RepoContext(repository, owner);
    }

    static Context orgContext(GHOrganization organization) {
        return new OrgContext(organization);
    }

    private static class OrgContext
    extends Context {
        private final GHOrganization organization;

        private OrgContext(GHOrganization organization) {
            super(organization.root);
            this.organization = organization;
        }

        @Override
        String collection() {
            return String.format("/orgs/%s/hooks", this.organization.getLogin());
        }

        @Override
        Class<? extends GHHook[]> collectionClass() {
            return GHOrgHook[].class;
        }

        @Override
        Class<? extends GHHook> clazz() {
            return GHOrgHook.class;
        }

        @Override
        GHHook wrap(GHHook hook) {
            return ((GHOrgHook)hook).wrap(this.organization);
        }
    }

    private static class RepoContext
    extends Context {
        private final GHRepository repository;
        private final GHUser owner;

        private RepoContext(GHRepository repository, GHUser owner) {
            super(repository.root);
            this.repository = repository;
            this.owner = owner;
        }

        @Override
        String collection() {
            return String.format("/repos/%s/%s/hooks", this.owner.getLogin(), this.repository.getName());
        }

        @Override
        Class<? extends GHHook[]> collectionClass() {
            return GHRepoHook[].class;
        }

        @Override
        Class<? extends GHHook> clazz() {
            return GHRepoHook.class;
        }

        @Override
        GHHook wrap(GHHook hook) {
            return ((GHRepoHook)hook).wrap(this.repository);
        }
    }

    static abstract class Context
    extends GitHubInteractiveObject {
        private Context(GitHub root) {
            this.root = root;
        }

        public List<GHHook> getHooks() throws IOException {
            GHHook[] hookArray = ((Requester)this.root.createRequest().withUrlPath(this.collection(), new String[0])).fetch(this.collectionClass());
            ArrayList<GHHook> list = new ArrayList<GHHook>(Arrays.asList(hookArray));
            for (GHHook h : list) {
                this.wrap(h);
            }
            return list;
        }

        public GHHook getHook(int id) throws IOException {
            GHHook hook = ((Requester)this.root.createRequest().withUrlPath(this.collection() + "/" + id, new String[0])).fetch(this.clazz());
            return this.wrap(hook);
        }

        public GHHook createHook(String name, Map<String, String> config, Collection<GHEvent> events, boolean active) throws IOException {
            ArrayList<String> ea = null;
            if (events != null) {
                ea = new ArrayList<String>();
                for (GHEvent e : events) {
                    ea.add(e.symbol());
                }
            }
            GHHook hook = ((Requester)((Requester)((Requester)((Requester)((Requester)((Requester)this.root.createRequest().method("POST")).with("name", name)).with("active", active)).with("config", config)).with("events", ea)).withUrlPath(this.collection(), new String[0])).fetch(this.clazz());
            return this.wrap(hook);
        }

        abstract String collection();

        abstract Class<? extends GHHook[]> collectionClass();

        abstract Class<? extends GHHook> clazz();

        abstract GHHook wrap(GHHook var1);
    }
}

