{- hat-trans -cpp -}
module Data.Word
  ( Word, Word8, Word16, Word32, Word64
  ) where

import Data.WordBuiltin
import PreludeBuiltinTypes
import qualified TraceOrigData.Word
import TraceOrigIx
import Ix
import Ratio

#define INSTANCE_EQ(T)		\
; foreign import haskell "Prelude.==" eq/**/T :: T -> T -> Bool \
; instance Eq T where { (==) = eq/**/T }

#define INSTANCE_ORD(T)		\
; foreign import haskell "Prelude.<=" le/**/T :: T -> T -> Bool \
; instance Ord T where { (<=) = le/**/T }

#define INSTANCE_NUM(T)		\
; foreign import haskell "Prelude.+" add/**/T :: T -> T -> T \
; foreign import haskell "Prelude.-" sub/**/T :: T -> T -> T \
; foreign import haskell "Prelude.*" mul/**/T :: T -> T -> T \
; foreign import haskell "Prelude.abs"    abs/**/T    :: T -> T \
; foreign import haskell "Prelude.negate" negate/**/T :: T -> T \
; foreign import haskell "Prelude.signum" signum/**/T :: T -> T \
; foreign import haskell "Prelude.fromInteger" fromInteger/**/T :: Integer -> T \
; instance Num T where		\
    { (+) = add/**/T		\
    ; (-) = sub/**/T		\
    ; (*) = mul/**/T		\
    ; abs = abs/**/T		\
    ; negate = negate/**/T	\
    ; signum = signum/**/T	\
    ; fromInteger = fromInteger/**/T	\
    }

#define INSTANCE_BOUNDED(T)	\
; foreign import haskell "Prelude.minBound" min/**/T :: T	\
; foreign import haskell "Prelude.maxBound" max/**/T :: T	\
; instance Bounded T where	\
    { minBound = min/**/T		\
    ; maxBound = max/**/T		\
    }

#define INSTANCE_REAL(T)	\
; instance Real T where	{ toRational x = toInt/**/T x % 1	}

#define INSTANCE_INTEGRAL(T)	\
; foreign import haskell "Prelude.quot" quot/**/T :: T -> T -> T	\
; foreign import haskell "Prelude.rem"  rem/**/T  :: T -> T -> T 	\
; foreign import haskell "Prelude.toInteger" toInt/**/T :: T -> Prelude.Integer	\
; instance Integral T where	\
    { quot = quot/**/T		\
    ; rem  = rem/**/T		\
    ; toInteger = toInt/**/T	\
    }

#define INSTANCE_IX(T)		\
; foreign import haskell "Ix.range" range/**/T :: (T,T) -> [T]		\
; foreign import haskell "Ix.index" index/**/T :: (T,T) -> T -> Int	\
; foreign import haskell "Ix.inRange" inRange/**/T :: (T,T) -> T -> Bool\
; instance Ix T where		\
    { range = range/**/T		\
    ; index = index/**/T		\
    ; inRange = inRange/**/T	\
    }

#define INSTANCE_ENUM(T)	\
; foreign import haskell "Prelude.toEnum"   toEnum/**/T   :: Int -> T	\
; foreign import haskell "Prelude.fromEnum" fromEnum/**/T :: T -> Int	\
; foreign import haskell "Prelude.enumFrom" enumFrom/**/T :: T -> [T]	\
; foreign import haskell "Prelude.enumFromThen" enumFromThen/**/T :: T->T->[T]\
; instance Enum T where		\
    {  toEnum = toEnum/**/T	\
    ;  fromEnum = fromEnum/**/T	\
    ;  enumFrom = enumFrom/**/T	\
    ;  enumFromThen = enumFromThen/**/T	\
    }

#define INSTANCE_READ(T)				\
; foreign import haskell "Prelude.readsPrec"		\
    readsPrec/**/T :: Int -> String -> [(T,String)]	\
; instance Read T where	 {  readsPrec = readsPrec/**/T }

#define INSTANCE_SHOW(T)				\
; foreign import haskell "Prelude.showsPrec"		\
    showsPrec/**/T :: Int->T->String->String		\
; instance Show T where	 {  showsPrec = showsPrec/**/T }

INSTANCE_EQ(Word)
INSTANCE_EQ(Word8)
INSTANCE_EQ(Word16)
INSTANCE_EQ(Word32)
INSTANCE_EQ(Word64)

INSTANCE_ORD(Word)
INSTANCE_ORD(Word8)
INSTANCE_ORD(Word16)
INSTANCE_ORD(Word32)
INSTANCE_ORD(Word64)

INSTANCE_NUM(Word)
INSTANCE_NUM(Word8)
INSTANCE_NUM(Word16)
INSTANCE_NUM(Word32)
INSTANCE_NUM(Word64)

INSTANCE_BOUNDED(Word)
INSTANCE_BOUNDED(Word8)
INSTANCE_BOUNDED(Word16)
INSTANCE_BOUNDED(Word32)
INSTANCE_BOUNDED(Word64)

INSTANCE_REAL(Word)
INSTANCE_REAL(Word8)
INSTANCE_REAL(Word16)
INSTANCE_REAL(Word32)
INSTANCE_REAL(Word64)

INSTANCE_INTEGRAL(Word)
INSTANCE_INTEGRAL(Word8)
INSTANCE_INTEGRAL(Word16)
INSTANCE_INTEGRAL(Word32)
INSTANCE_INTEGRAL(Word64)

{-
INSTANCE_IX(Word)
INSTANCE_IX(Word8)
INSTANCE_IX(Word16)
INSTANCE_IX(Word32)
INSTANCE_IX(Word64)
-}

INSTANCE_ENUM(Word)
INSTANCE_ENUM(Word8)
INSTANCE_ENUM(Word16)
INSTANCE_ENUM(Word32)
INSTANCE_ENUM(Word64)

INSTANCE_READ(Word)
INSTANCE_READ(Word8)
INSTANCE_READ(Word16)
INSTANCE_READ(Word32)
INSTANCE_READ(Word64)

INSTANCE_SHOW(Word)
INSTANCE_SHOW(Word8)
INSTANCE_SHOW(Word16)
INSTANCE_SHOW(Word32)
INSTANCE_SHOW(Word64)
