{-# hat-trans -cpp #-}
module Data.PackedString
  ( 
   -- * The @PackedString@ type
    PackedString         -- abstract, instances: Eq, Ord, Show, Typeable

   -- * Converting to and from @PackedString@s
  , packString  -- :: String -> PackedString
  , unpackPS    -- :: PackedString -> String
   -- * List-like manipulation functions
  , nilPS       -- :: PackedString
  , consPS      -- :: Char -> PackedString -> PackedString
  , headPS      -- :: PackedString -> Char
  , tailPS      -- :: PackedString -> PackedString
  , nullPS      -- :: PackedString -> Bool
  , appendPS    -- :: PackedString -> PackedString -> PackedString
  , lengthPS    -- :: PackedString -> Int
  , indexPS     -- :: PackedString -> Int -> Char
  , mapPS       -- :: (Char -> Char) -> PackedString -> PackedString
  , filterPS    -- :: (Char -> Bool) -> PackedString -> PackedString
  , reversePS   -- :: PackedString -> PackedString
  , concatPS    -- :: [PackedString] -> PackedString
  , elemPS      -- :: Char -> PackedString -> Bool
  , substrPS    -- :: PackedString -> Int -> Int -> PackedString
  , takePS      -- :: Int -> PackedString -> PackedString
  , dropPS      -- :: Int -> PackedString -> PackedString
  , splitAtPS   -- :: Int -> PackedString -> (PackedString, PackedString)

  , foldlPS     -- :: (a -> Char -> a) -> a -> PackedString -> a
  , foldrPS     -- :: (Char -> a -> a) -> a -> PackedString -> a
  , takeWhilePS -- :: (Char -> Bool) -> PackedString -> PackedString
  , dropWhilePS -- :: (Char -> Bool) -> PackedString -> PackedString
  , spanPS      -- :: (Char -> Bool) -> PackedString -> (PackedString, PackedString)
  , breakPS     -- :: (Char -> Bool) -> PackedString -> (PackedString, PackedString)
  , linesPS     -- :: PackedString -> [PackedString]

  , wordsPS     -- :: PackedString -> [PackedString]
  , splitPS     -- :: Char -> PackedString -> [PackedString]
  , splitWithPS -- :: (Char -> Bool) -> PackedString -> [PackedString]

#if __GLASGOW_HASKELL__ >= 600 || __NHC__ >= 117
  , unlinesPS  -- :: [PackedString] -> PackedString
  , unwordsPS  -- :: [PackedString] -> PackedString
  , joinPS     -- :: PackedString -> [PackedString] -> PackedString
#endif
  ) where

import Data.PackedStringBuiltin
import PreludeBuiltinTypes
import qualified TraceOrigData.PackedString
import qualified TraceOrigPrelude

foreign import haskell "Data.PackedString.packString"
  packString            :: String -> PackedString
foreign import haskell "Data.PackedString.unpackPS"
  unpackPS              :: PackedString -> String

foreign import haskell "Prelude.=="
  primEqPackedString    :: PackedString -> PackedString -> Bool
foreign import haskell "Prelude.<="
  primLePackedString    :: PackedString -> PackedString -> Bool
foreign import haskell "Prelude.showsPrec"
  primShowsPrecPackedString :: Int -> PackedString -> String -> String

instance Eq PackedString where
  (==)      = primEqPackedString
instance Ord PackedString where
  (<=)      = primLePackedString
instance Show PackedString where
  showsPrec = primShowsPrecPackedString

foreign import haskell "Data.PackedString.nilPS"
  nilPS          :: PackedString
foreign import haskell "Data.PackedString.consPS"
  consPS         :: Char -> PackedString -> PackedString
foreign import haskell "Data.PackedString.headPS"
  headPS         :: PackedString -> Char
foreign import haskell "Data.PackedString.tailPS"
  tailPS         :: PackedString -> PackedString
foreign import haskell "Data.PackedString.nullPS"
  nullPS         :: PackedString -> Bool
foreign import haskell "Data.PackedString.appendPS"
  appendPS       :: PackedString -> PackedString -> PackedString
foreign import haskell "Data.PackedString.lengthPS"
  lengthPS       :: PackedString -> Int
foreign import haskell "Data.PackedString.indexPS"
  indexPS        :: PackedString -> Int -> Char
foreign import haskell "Data.PackedString.mapPS"
  mapPS          :: (Char->Char) -> PackedString -> PackedString
foreign import haskell "Data.PackedString.filterPS"
  filterPS       :: (Char->Bool) -> PackedString -> PackedString
foreign import haskell "Data.PackedString.reversePS"
  reversePS      :: PackedString -> PackedString
foreign import haskell "Data.PackedString.concatPS"
  concatPS       :: [PackedString] -> PackedString
foreign import haskell "Data.PackedString.elemPS"
  elemPS         :: Char -> PackedString -> Bool
foreign import haskell "Data.PackedString.substrPS"
  substrPS       :: PackedString -> Int -> Int -> PackedString
foreign import haskell "Data.PackedString.takePS"
  takePS         :: Int -> PackedString -> PackedString
foreign import haskell "Data.PackedString.dropPS"
  dropPS         :: Int -> PackedString -> PackedString
foreign import haskell "Data.PackedString.splitAtPS"
  splitAtPS      :: Int -> PackedString -> (PackedString,PackedString)

foreign import haskell "Data.PackedString.foldlPS"
  foldlPS        :: (a->Char->a) -> a -> PackedString -> a
foreign import haskell "Data.PackedString.foldrPS"
  foldrPS        :: (Char->a->a) -> a -> PackedString -> a
foreign import haskell "Data.PackedString.takeWhilePS"
  takeWhilePS    :: (Char->Bool) -> PackedString -> PackedString
foreign import haskell "Data.PackedString.dropWhilePS"
  dropWhilePS    :: (Char->Bool) -> PackedString -> PackedString
foreign import haskell "Data.PackedString.spanPS"
  spanPS         :: (Char->Bool) -> PackedString -> (PackedString,PackedString)
foreign import haskell "Data.PackedString.breakPS"
  breakPS        :: (Char->Bool) -> PackedString -> (PackedString,PackedString)

foreign import haskell "Data.PackedString.linesPS"
  linesPS        :: PackedString -> [PackedString]
foreign import haskell "Data.PackedString.wordsPS"
  wordsPS        :: PackedString -> [PackedString]
foreign import haskell "Data.PackedString.splitPS"
  splitPS        :: Char -> PackedString -> [PackedString]
foreign import haskell "Data.PackedString.splitWithPS"
  splitWithPS    :: (Char->Bool) -> PackedString -> [PackedString]

#if __GLASGOW_HASKELL__ >= 600 || __NHC__ >= 117
foreign import haskell "Data.PackedString.unlinesPS"
  unlinesPS      :: [PackedString] -> PackedString
foreign import haskell "Data.PackedString.unwordsPS"
  unwordsPS      :: [PackedString] -> PackedString
foreign import haskell "Data.PackedString.joinPS"
  joinPS         :: PackedString -> [PackedString] -> PackedString
#endif
