/*
 * Copyright 2010-2013 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.codehaus.griffon.runtime.core.resources;

import griffon.core.GriffonApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Andres Almiray
 * @since 1.1.0
 */
public class DefaultResourcesInjector extends AbstractResourcesInjector {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultResourcesInjector.class);

    public DefaultResourcesInjector(GriffonApplication app) {
        super(app);
    }

    protected Object resolveResource(String key, String[] args) {
        return getApp().resolveResource(key, args, getApp().getLocale());
    }

    protected Object resolveResource(String key, String[] args, String defaultValue) {
        return getApp().resolveResource(key, args, defaultValue, getApp().getLocale());
    }
}
